/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.opencorporates.schemas.OCNiceEnhancedDescription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"code_scheme_id", "code", "enhanced_descriptions"})
public class OCNiceClassification {
    @JsonProperty(value="code_scheme_id")
    @JsonPropertyDescription(value="The scheme of the classification")
    @NotNull
    private CodeSchemeId codeSchemeId;
    @JsonProperty(value="code")
    @JsonPropertyDescription(value="The classification code")
    @NotNull
    private String code;
    @JsonProperty(value="enhanced_descriptions")
    @JsonPropertyDescription(value="Enhanced descriptions of the classification (may enhance restrict, or otherwise alter standard classification)")
    @Valid
    private List<OCNiceEnhancedDescription> enhancedDescriptions = new ArrayList<OCNiceEnhancedDescription>();

    @JsonProperty(value="code_scheme_id")
    public CodeSchemeId getCodeSchemeId() {
        return this.codeSchemeId;
    }

    @JsonProperty(value="code_scheme_id")
    public void setCodeSchemeId(CodeSchemeId codeSchemeId) {
        this.codeSchemeId = codeSchemeId;
    }

    @JsonProperty(value="code")
    public String getCode() {
        return this.code;
    }

    @JsonProperty(value="code")
    public void setCode(String code) {
        this.code = code;
    }

    @JsonProperty(value="enhanced_descriptions")
    public List<OCNiceEnhancedDescription> getEnhancedDescriptions() {
        return this.enhancedDescriptions;
    }

    @JsonProperty(value="enhanced_descriptions")
    public void setEnhancedDescriptions(List<OCNiceEnhancedDescription> enhancedDescriptions) {
        this.enhancedDescriptions = enhancedDescriptions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCNiceClassification.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("codeSchemeId");
        sb.append('=');
        sb.append(this.codeSchemeId == null ? "<null>" : this.codeSchemeId);
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(this.code == null ? "<null>" : this.code);
        sb.append(',');
        sb.append("enhancedDescriptions");
        sb.append('=');
        sb.append(this.enhancedDescriptions == null ? "<null>" : this.enhancedDescriptions);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.enhancedDescriptions == null ? 0 : this.enhancedDescriptions.hashCode());
        result = result * 31 + (this.code == null ? 0 : this.code.hashCode());
        result = result * 31 + (this.codeSchemeId == null ? 0 : this.codeSchemeId.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCNiceClassification)) {
            return false;
        }
        OCNiceClassification rhs = (OCNiceClassification)other;
        return (this.enhancedDescriptions == rhs.enhancedDescriptions || this.enhancedDescriptions != null && this.enhancedDescriptions.equals(rhs.enhancedDescriptions)) && (this.code == rhs.code || this.code != null && this.code.equals(rhs.code)) && (this.codeSchemeId == rhs.codeSchemeId || this.codeSchemeId != null && this.codeSchemeId.equals((Object)rhs.codeSchemeId));
    }

    public static enum CodeSchemeId {
        WIPO_NICE("wipo_nice");

        private final String value;
        private static final Map<String, CodeSchemeId> CONSTANTS;

        private CodeSchemeId(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static CodeSchemeId fromValue(String value) {
            CodeSchemeId constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, CodeSchemeId>();
            for (CodeSchemeId c : CodeSchemeId.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

