/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.opencorporates.schemas.OCPublisher;
import java.net.URI;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"publisher", "jurisdiction_code", "title", "url", "media_type"})
public class OCPublication {
    @JsonProperty(value="publisher")
    @JsonPropertyDescription(value="A gazette publisher")
    @Valid
    @NotNull
    private OCPublisher publisher;
    @JsonProperty(value="jurisdiction_code")
    @JsonPropertyDescription(value="The jurisdiction covered by the gazette")
    private String jurisdictionCode;
    @JsonProperty(value="title")
    @JsonPropertyDescription(value="The title of the gazette")
    private String title;
    @JsonProperty(value="url")
    @JsonPropertyDescription(value="The URL of the gazette")
    private URI url;
    @JsonProperty(value="media_type")
    @JsonPropertyDescription(value="The media type of the URL resource")
    private String mediaType;

    @JsonProperty(value="publisher")
    public OCPublisher getPublisher() {
        return this.publisher;
    }

    @JsonProperty(value="publisher")
    public void setPublisher(OCPublisher publisher) {
        this.publisher = publisher;
    }

    @JsonProperty(value="jurisdiction_code")
    public String getJurisdictionCode() {
        return this.jurisdictionCode;
    }

    @JsonProperty(value="jurisdiction_code")
    public void setJurisdictionCode(String jurisdictionCode) {
        this.jurisdictionCode = jurisdictionCode;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="url")
    public URI getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(URI url) {
        this.url = url;
    }

    @JsonProperty(value="media_type")
    public String getMediaType() {
        return this.mediaType;
    }

    @JsonProperty(value="media_type")
    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCPublication.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("publisher");
        sb.append('=');
        sb.append(this.publisher == null ? "<null>" : this.publisher);
        sb.append(',');
        sb.append("jurisdictionCode");
        sb.append('=');
        sb.append(this.jurisdictionCode == null ? "<null>" : this.jurisdictionCode);
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(this.title == null ? "<null>" : this.title);
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(this.url == null ? "<null>" : this.url);
        sb.append(',');
        sb.append("mediaType");
        sb.append('=');
        sb.append(this.mediaType == null ? "<null>" : this.mediaType);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.publisher == null ? 0 : this.publisher.hashCode());
        result = result * 31 + (this.jurisdictionCode == null ? 0 : this.jurisdictionCode.hashCode());
        result = result * 31 + (this.mediaType == null ? 0 : this.mediaType.hashCode());
        result = result * 31 + (this.title == null ? 0 : this.title.hashCode());
        result = result * 31 + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCPublication)) {
            return false;
        }
        OCPublication rhs = (OCPublication)other;
        return (this.publisher == rhs.publisher || this.publisher != null && this.publisher.equals(rhs.publisher)) && (this.jurisdictionCode == rhs.jurisdictionCode || this.jurisdictionCode != null && this.jurisdictionCode.equals(rhs.jurisdictionCode)) && (this.mediaType == rhs.mediaType || this.mediaType != null && this.mediaType.equals(rhs.mediaType)) && (this.title == rhs.title || this.title != null && this.title.equals(rhs.title)) && (this.url == rhs.url || this.url != null && this.url.equals(rhs.url));
    }
}

