/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"source_url", "sample_date", "start_date", "end_date", "confidence", "company_name", "company_jurisdiction", "licence_number", "jurisdiction_classification", "regulator", "licence_jurisdiction", "status", "retrieved_at", "category"})
public class OCSimpleLicenceSchema {
    @JsonProperty(value="source_url")
    @JsonPropertyDescription(value="Place where this fact can be verified")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String sourceUrl;
    @JsonProperty(value="sample_date")
    @JsonPropertyDescription(value="Date on which this fact was known to be true")
    @NotNull
    private LocalDate sampleDate;
    @JsonProperty(value="start_date")
    private LocalDate startDate;
    @JsonProperty(value="end_date")
    private LocalDate endDate;
    @JsonProperty(value="confidence")
    @JsonPropertyDescription(value="Confidence in accuracy of data")
    private Confidence confidence;
    @JsonProperty(value="company_name")
    @JsonPropertyDescription(value="Name of the company holding the licence")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String companyName;
    @JsonProperty(value="company_jurisdiction")
    @JsonPropertyDescription(value="Jurisdiction where company is based")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String companyJurisdiction;
    @JsonProperty(value="licence_number")
    @JsonPropertyDescription(value="Licence number or code")
    private String licenceNumber;
    @JsonProperty(value="jurisdiction_classification")
    @JsonPropertyDescription(value="Description of how regulator classifies licence")
    private String jurisdictionClassification;
    @JsonProperty(value="regulator")
    @JsonPropertyDescription(value="The regulating body that issued the licence")
    private String regulator;
    @JsonProperty(value="licence_jurisdiction")
    @JsonPropertyDescription(value="Jurisdiction for which licence is issued")
    @Size(min=1)
    private @Size(min=1) String licenceJurisdiction;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="Status of the licence")
    private String status;
    @JsonProperty(value="retrieved_at")
    private LocalDate retrievedAt;
    @JsonProperty(value="category")
    @JsonPropertyDescription(value="Category of licence")
    private Category category;

    @JsonProperty(value="source_url")
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="source_url")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    @JsonProperty(value="sample_date")
    public LocalDate getSampleDate() {
        return this.sampleDate;
    }

    @JsonProperty(value="sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    @JsonProperty(value="start_date")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="start_date")
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    @JsonProperty(value="end_date")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="end_date")
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    @JsonProperty(value="confidence")
    public Confidence getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="confidence")
    public void setConfidence(Confidence confidence) {
        this.confidence = confidence;
    }

    @JsonProperty(value="company_name")
    public String getCompanyName() {
        return this.companyName;
    }

    @JsonProperty(value="company_name")
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @JsonProperty(value="company_jurisdiction")
    public String getCompanyJurisdiction() {
        return this.companyJurisdiction;
    }

    @JsonProperty(value="company_jurisdiction")
    public void setCompanyJurisdiction(String companyJurisdiction) {
        this.companyJurisdiction = companyJurisdiction;
    }

    @JsonProperty(value="licence_number")
    public String getLicenceNumber() {
        return this.licenceNumber;
    }

    @JsonProperty(value="licence_number")
    public void setLicenceNumber(String licenceNumber) {
        this.licenceNumber = licenceNumber;
    }

    @JsonProperty(value="jurisdiction_classification")
    public String getJurisdictionClassification() {
        return this.jurisdictionClassification;
    }

    @JsonProperty(value="jurisdiction_classification")
    public void setJurisdictionClassification(String jurisdictionClassification) {
        this.jurisdictionClassification = jurisdictionClassification;
    }

    @JsonProperty(value="regulator")
    public String getRegulator() {
        return this.regulator;
    }

    @JsonProperty(value="regulator")
    public void setRegulator(String regulator) {
        this.regulator = regulator;
    }

    @JsonProperty(value="licence_jurisdiction")
    public String getLicenceJurisdiction() {
        return this.licenceJurisdiction;
    }

    @JsonProperty(value="licence_jurisdiction")
    public void setLicenceJurisdiction(String licenceJurisdiction) {
        this.licenceJurisdiction = licenceJurisdiction;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty(value="retrieved_at")
    public LocalDate getRetrievedAt() {
        return this.retrievedAt;
    }

    @JsonProperty(value="retrieved_at")
    public void setRetrievedAt(LocalDate retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    @JsonProperty(value="category")
    public Category getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    public void setCategory(Category category) {
        this.category = category;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCSimpleLicenceSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(this.sourceUrl == null ? "<null>" : this.sourceUrl);
        sb.append(',');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(this.sampleDate == null ? "<null>" : this.sampleDate);
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(this.startDate == null ? "<null>" : this.startDate);
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(this.endDate == null ? "<null>" : this.endDate);
        sb.append(',');
        sb.append("confidence");
        sb.append('=');
        sb.append(this.confidence == null ? "<null>" : this.confidence);
        sb.append(',');
        sb.append("companyName");
        sb.append('=');
        sb.append(this.companyName == null ? "<null>" : this.companyName);
        sb.append(',');
        sb.append("companyJurisdiction");
        sb.append('=');
        sb.append(this.companyJurisdiction == null ? "<null>" : this.companyJurisdiction);
        sb.append(',');
        sb.append("licenceNumber");
        sb.append('=');
        sb.append(this.licenceNumber == null ? "<null>" : this.licenceNumber);
        sb.append(',');
        sb.append("jurisdictionClassification");
        sb.append('=');
        sb.append(this.jurisdictionClassification == null ? "<null>" : this.jurisdictionClassification);
        sb.append(',');
        sb.append("regulator");
        sb.append('=');
        sb.append(this.regulator == null ? "<null>" : this.regulator);
        sb.append(',');
        sb.append("licenceJurisdiction");
        sb.append('=');
        sb.append(this.licenceJurisdiction == null ? "<null>" : this.licenceJurisdiction);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(this.retrievedAt == null ? "<null>" : this.retrievedAt);
        sb.append(',');
        sb.append("category");
        sb.append('=');
        sb.append(this.category == null ? "<null>" : this.category);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = result * 31 + (this.confidence == null ? 0 : this.confidence.hashCode());
        result = result * 31 + (this.companyName == null ? 0 : this.companyName.hashCode());
        result = result * 31 + (this.companyJurisdiction == null ? 0 : this.companyJurisdiction.hashCode());
        result = result * 31 + (this.licenceNumber == null ? 0 : this.licenceNumber.hashCode());
        result = result * 31 + (this.jurisdictionClassification == null ? 0 : this.jurisdictionClassification.hashCode());
        result = result * 31 + (this.sourceUrl == null ? 0 : this.sourceUrl.hashCode());
        result = result * 31 + (this.retrievedAt == null ? 0 : this.retrievedAt.hashCode());
        result = result * 31 + (this.licenceJurisdiction == null ? 0 : this.licenceJurisdiction.hashCode());
        result = result * 31 + (this.sampleDate == null ? 0 : this.sampleDate.hashCode());
        result = result * 31 + (this.regulator == null ? 0 : this.regulator.hashCode());
        result = result * 31 + (this.category == null ? 0 : this.category.hashCode());
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCSimpleLicenceSchema)) {
            return false;
        }
        OCSimpleLicenceSchema rhs = (OCSimpleLicenceSchema)other;
        return (this.endDate == rhs.endDate || this.endDate != null && this.endDate.equals(rhs.endDate)) && (this.confidence == rhs.confidence || this.confidence != null && this.confidence.equals((Object)rhs.confidence)) && (this.companyName == rhs.companyName || this.companyName != null && this.companyName.equals(rhs.companyName)) && (this.companyJurisdiction == rhs.companyJurisdiction || this.companyJurisdiction != null && this.companyJurisdiction.equals(rhs.companyJurisdiction)) && (this.licenceNumber == rhs.licenceNumber || this.licenceNumber != null && this.licenceNumber.equals(rhs.licenceNumber)) && (this.jurisdictionClassification == rhs.jurisdictionClassification || this.jurisdictionClassification != null && this.jurisdictionClassification.equals(rhs.jurisdictionClassification)) && (this.sourceUrl == rhs.sourceUrl || this.sourceUrl != null && this.sourceUrl.equals(rhs.sourceUrl)) && (this.retrievedAt == rhs.retrievedAt || this.retrievedAt != null && this.retrievedAt.equals(rhs.retrievedAt)) && (this.licenceJurisdiction == rhs.licenceJurisdiction || this.licenceJurisdiction != null && this.licenceJurisdiction.equals(rhs.licenceJurisdiction)) && (this.sampleDate == rhs.sampleDate || this.sampleDate != null && this.sampleDate.equals(rhs.sampleDate)) && (this.regulator == rhs.regulator || this.regulator != null && this.regulator.equals(rhs.regulator)) && (this.category == rhs.category || this.category != null && this.category.equals((Object)rhs.category)) && (this.startDate == rhs.startDate || this.startDate != null && this.startDate.equals(rhs.startDate)) && (this.status == rhs.status || this.status != null && this.status.equals(rhs.status));
    }

    public static enum Confidence {
        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");

        private final String value;
        private static final Map<String, Confidence> CONSTANTS;

        private Confidence(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Confidence fromValue(String value) {
            Confidence constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Confidence>();
            for (Confidence c : Confidence.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Category {
        FINANCIAL("Financial"),
        BUSINESS("Business");

        private final String value;
        private static final Map<String, Category> CONSTANTS;

        private Category(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Category fromValue(String value) {
            Category constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Category>();
            for (Category c : Category.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

