/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.opencorporates.schemas.OCEntity;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"data_type", "previous_entity", "subsequent_entity", "subsequent_registration_start_date", "previous_registration_end_date", "publication_date", "start_date", "start_date_type", "sample_date", "retrieved_at", "source_url", "confidence"})
public class OCSubsequentRegistrationSchema {
    @JsonProperty(value="data_type")
    @NotNull
    private DataType dataType;
    @JsonProperty(value="previous_entity")
    @Valid
    @NotNull
    private OCEntity previousEntity;
    @JsonProperty(value="subsequent_entity")
    @Valid
    @NotNull
    private OCEntity subsequentEntity;
    @JsonProperty(value="subsequent_registration_start_date")
    @JsonPropertyDescription(value="date when subsequent registration started")
    private LocalDate subsequentRegistrationStartDate;
    @JsonProperty(value="previous_registration_end_date")
    @JsonPropertyDescription(value="date when previous registration ended")
    private LocalDate previousRegistrationEndDate;
    @JsonProperty(value="publication_date")
    @JsonPropertyDescription(value="the publication date of the filing/notice that gives details of the alternate registration")
    private LocalDate publicationDate;
    @JsonProperty(value="start_date")
    @JsonPropertyDescription(value="date when subsequent registration was valid from")
    private LocalDate startDate;
    @JsonProperty(value="start_date_type")
    private StartDateType startDateType;
    @JsonProperty(value="sample_date")
    @JsonPropertyDescription(value="date when subsequent registration was sampled")
    private LocalDate sampleDate;
    @JsonProperty(value="retrieved_at")
    @JsonPropertyDescription(value="date when subsequent registration was retrieved")
    @NotNull
    private LocalDate retrievedAt;
    @JsonProperty(value="source_url")
    @JsonPropertyDescription(value="URL of the source of the data (e.g. download URL), or if there is not persistent URL the page from which it can be found (e.g. search page)")
    private String sourceUrl;
    @JsonProperty(value="confidence")
    @JsonPropertyDescription(value="Confidence in accuracy of data")
    @NotNull
    private Confidence confidence;

    @JsonProperty(value="data_type")
    public DataType getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="data_type")
    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    @JsonProperty(value="previous_entity")
    public OCEntity getPreviousEntity() {
        return this.previousEntity;
    }

    @JsonProperty(value="previous_entity")
    public void setPreviousEntity(OCEntity previousEntity) {
        this.previousEntity = previousEntity;
    }

    @JsonProperty(value="subsequent_entity")
    public OCEntity getSubsequentEntity() {
        return this.subsequentEntity;
    }

    @JsonProperty(value="subsequent_entity")
    public void setSubsequentEntity(OCEntity subsequentEntity) {
        this.subsequentEntity = subsequentEntity;
    }

    @JsonProperty(value="subsequent_registration_start_date")
    public LocalDate getSubsequentRegistrationStartDate() {
        return this.subsequentRegistrationStartDate;
    }

    @JsonProperty(value="subsequent_registration_start_date")
    public void setSubsequentRegistrationStartDate(LocalDate subsequentRegistrationStartDate) {
        this.subsequentRegistrationStartDate = subsequentRegistrationStartDate;
    }

    @JsonProperty(value="previous_registration_end_date")
    public LocalDate getPreviousRegistrationEndDate() {
        return this.previousRegistrationEndDate;
    }

    @JsonProperty(value="previous_registration_end_date")
    public void setPreviousRegistrationEndDate(LocalDate previousRegistrationEndDate) {
        this.previousRegistrationEndDate = previousRegistrationEndDate;
    }

    @JsonProperty(value="publication_date")
    public LocalDate getPublicationDate() {
        return this.publicationDate;
    }

    @JsonProperty(value="publication_date")
    public void setPublicationDate(LocalDate publicationDate) {
        this.publicationDate = publicationDate;
    }

    @JsonProperty(value="start_date")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="start_date")
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    @JsonProperty(value="start_date_type")
    public StartDateType getStartDateType() {
        return this.startDateType;
    }

    @JsonProperty(value="start_date_type")
    public void setStartDateType(StartDateType startDateType) {
        this.startDateType = startDateType;
    }

    @JsonProperty(value="sample_date")
    public LocalDate getSampleDate() {
        return this.sampleDate;
    }

    @JsonProperty(value="sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    @JsonProperty(value="retrieved_at")
    public LocalDate getRetrievedAt() {
        return this.retrievedAt;
    }

    @JsonProperty(value="retrieved_at")
    public void setRetrievedAt(LocalDate retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    @JsonProperty(value="source_url")
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="source_url")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    @JsonProperty(value="confidence")
    public Confidence getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="confidence")
    public void setConfidence(Confidence confidence) {
        this.confidence = confidence;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCSubsequentRegistrationSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dataType");
        sb.append('=');
        sb.append(this.dataType == null ? "<null>" : this.dataType);
        sb.append(',');
        sb.append("previousEntity");
        sb.append('=');
        sb.append(this.previousEntity == null ? "<null>" : this.previousEntity);
        sb.append(',');
        sb.append("subsequentEntity");
        sb.append('=');
        sb.append(this.subsequentEntity == null ? "<null>" : this.subsequentEntity);
        sb.append(',');
        sb.append("subsequentRegistrationStartDate");
        sb.append('=');
        sb.append(this.subsequentRegistrationStartDate == null ? "<null>" : this.subsequentRegistrationStartDate);
        sb.append(',');
        sb.append("previousRegistrationEndDate");
        sb.append('=');
        sb.append(this.previousRegistrationEndDate == null ? "<null>" : this.previousRegistrationEndDate);
        sb.append(',');
        sb.append("publicationDate");
        sb.append('=');
        sb.append(this.publicationDate == null ? "<null>" : this.publicationDate);
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(this.startDate == null ? "<null>" : this.startDate);
        sb.append(',');
        sb.append("startDateType");
        sb.append('=');
        sb.append(this.startDateType == null ? "<null>" : this.startDateType);
        sb.append(',');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(this.sampleDate == null ? "<null>" : this.sampleDate);
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(this.retrievedAt == null ? "<null>" : this.retrievedAt);
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(this.sourceUrl == null ? "<null>" : this.sourceUrl);
        sb.append(',');
        sb.append("confidence");
        sb.append('=');
        sb.append(this.confidence == null ? "<null>" : this.confidence);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.startDateType == null ? 0 : this.startDateType.hashCode());
        result = result * 31 + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = result * 31 + (this.confidence == null ? 0 : this.confidence.hashCode());
        result = result * 31 + (this.subsequentRegistrationStartDate == null ? 0 : this.subsequentRegistrationStartDate.hashCode());
        result = result * 31 + (this.sourceUrl == null ? 0 : this.sourceUrl.hashCode());
        result = result * 31 + (this.retrievedAt == null ? 0 : this.retrievedAt.hashCode());
        result = result * 31 + (this.previousRegistrationEndDate == null ? 0 : this.previousRegistrationEndDate.hashCode());
        result = result * 31 + (this.sampleDate == null ? 0 : this.sampleDate.hashCode());
        result = result * 31 + (this.subsequentEntity == null ? 0 : this.subsequentEntity.hashCode());
        result = result * 31 + (this.previousEntity == null ? 0 : this.previousEntity.hashCode());
        result = result * 31 + (this.publicationDate == null ? 0 : this.publicationDate.hashCode());
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCSubsequentRegistrationSchema)) {
            return false;
        }
        OCSubsequentRegistrationSchema rhs = (OCSubsequentRegistrationSchema)other;
        return (this.startDateType == rhs.startDateType || this.startDateType != null && this.startDateType.equals((Object)rhs.startDateType)) && (this.dataType == rhs.dataType || this.dataType != null && this.dataType.equals((Object)rhs.dataType)) && (this.confidence == rhs.confidence || this.confidence != null && this.confidence.equals((Object)rhs.confidence)) && (this.subsequentRegistrationStartDate == rhs.subsequentRegistrationStartDate || this.subsequentRegistrationStartDate != null && this.subsequentRegistrationStartDate.equals(rhs.subsequentRegistrationStartDate)) && (this.sourceUrl == rhs.sourceUrl || this.sourceUrl != null && this.sourceUrl.equals(rhs.sourceUrl)) && (this.retrievedAt == rhs.retrievedAt || this.retrievedAt != null && this.retrievedAt.equals(rhs.retrievedAt)) && (this.previousRegistrationEndDate == rhs.previousRegistrationEndDate || this.previousRegistrationEndDate != null && this.previousRegistrationEndDate.equals(rhs.previousRegistrationEndDate)) && (this.sampleDate == rhs.sampleDate || this.sampleDate != null && this.sampleDate.equals(rhs.sampleDate)) && (this.subsequentEntity == rhs.subsequentEntity || this.subsequentEntity != null && this.subsequentEntity.equals(rhs.subsequentEntity)) && (this.previousEntity == rhs.previousEntity || this.previousEntity != null && this.previousEntity.equals(rhs.previousEntity)) && (this.publicationDate == rhs.publicationDate || this.publicationDate != null && this.publicationDate.equals(rhs.publicationDate)) && (this.startDate == rhs.startDate || this.startDate != null && this.startDate.equals(rhs.startDate));
    }

    public static enum StartDateType {
        AT("at"),
        BEFORE("before"),
        AFTER("after");

        private final String value;
        private static final Map<String, StartDateType> CONSTANTS;

        private StartDateType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static StartDateType fromValue(String value) {
            StartDateType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, StartDateType>();
            for (StartDateType c : StartDateType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum DataType {
        SUBSEQUENT_REGISTRATION("subsequent-registration");

        private final String value;
        private static final Map<String, DataType> CONSTANTS;

        private DataType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DataType fromValue(String value) {
            DataType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DataType>();
            for (DataType c : DataType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Confidence {
        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");

        private final String value;
        private static final Map<String, Confidence> CONSTANTS;

        private Confidence(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Confidence fromValue(String value) {
            Confidence constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Confidence>();
            for (Confidence c : Confidence.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

