/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.opencorporates.schemas.OCObject;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "object"})
public class OCUpdateAction {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="The type of change")
    private Type type;
    @JsonProperty(value="object")
    @JsonPropertyDescription(value="The object that was changed")
    @Valid
    @NotNull
    private OCObject object;

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    @JsonProperty(value="object")
    public OCObject getObject() {
        return this.object;
    }

    @JsonProperty(value="object")
    public void setObject(OCObject object) {
        this.object = object;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCUpdateAction.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("object");
        sb.append('=');
        sb.append(this.object == null ? "<null>" : this.object);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.object == null ? 0 : this.object.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCUpdateAction)) {
            return false;
        }
        OCUpdateAction rhs = (OCUpdateAction)other;
        return (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.object == rhs.object || this.object != null && this.object.equals(rhs.object));
    }

    public static enum Type {
        CANCELLATION("cancellation"),
        CORRECTION("correction");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

