/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas.includes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.opencorporates.schemas.OCAlternativeName;
import com.opencorporates.schemas.OCIdentifier;
import com.opencorporates.schemas.OCIndustryCode;
import com.opencorporates.schemas.includes.OCAddressWithType;
import com.opencorporates.schemas.includes.OCCompanyForNesting;
import com.opencorporates.schemas.includes.OCOtherAttributes__1;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "jurisdiction", "company", "relationship_with_company", "website", "uid", "telephone_number", "fax_number", "registered_address", "headquarters_address", "mailing_address", "addresses", "industry_codes", "alternative_names", "date_of_birth", "nationality", "country_of_residence", "identifiers", "other_attributes"})
public class OCPerson {
    @JsonProperty(value="name")
    @NotNull
    private Object name;
    @JsonProperty(value="jurisdiction")
    @JsonPropertyDescription(value="Name of the jurisdiction in which the entity is based")
    private String jurisdiction;
    @JsonProperty(value="company")
    @JsonPropertyDescription(value="A company in OpenCorporates")
    @Valid
    private OCCompanyForNesting company;
    @JsonProperty(value="relationship_with_company")
    private RelationshipWithCompany relationshipWithCompany;
    @JsonProperty(value="website")
    private Object website;
    @JsonProperty(value="uid")
    @JsonPropertyDescription(value="Unique id of the person. Note: the unique id is not expected to be globally unique, but only unique with reference to the source from which it is derived. No check is made for uniqueness")
    @Size(min=1)
    private @Size(min=1) String uid;
    @JsonProperty(value="telephone_number")
    @Size(min=4)
    private @Size(min=4) String telephoneNumber;
    @JsonProperty(value="fax_number")
    @Size(min=4)
    private @Size(min=4) String faxNumber;
    @JsonProperty(value="registered_address")
    private Object registeredAddress;
    @JsonProperty(value="headquarters_address")
    private Object headquartersAddress;
    @JsonProperty(value="mailing_address")
    private Object mailingAddress;
    @JsonProperty(value="addresses")
    @Valid
    private List<OCAddressWithType> addresses = new ArrayList<OCAddressWithType>();
    @JsonProperty(value="industry_codes")
    @Valid
    private List<OCIndustryCode> industryCodes = new ArrayList<OCIndustryCode>();
    @JsonProperty(value="alternative_names")
    @Valid
    private List<OCAlternativeName> alternativeNames = new ArrayList<OCAlternativeName>();
    @JsonProperty(value="date_of_birth")
    private Object dateOfBirth;
    @JsonProperty(value="nationality")
    @JsonPropertyDescription(value="The person's nationality")
    private String nationality;
    @JsonProperty(value="country_of_residence")
    @JsonPropertyDescription(value="The normal country of residence for the person")
    private String countryOfResidence;
    @JsonProperty(value="identifiers")
    private List<OCIdentifier> identifiers = new ArrayList<OCIdentifier>();
    @JsonProperty(value="other_attributes")
    @JsonPropertyDescription(value="Use for other attributes for which we don't yet have curated schema attributes")
    @Valid
    private OCOtherAttributes__1 otherAttributes;

    @JsonProperty(value="name")
    public Object getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(Object name) {
        this.name = name;
    }

    @JsonProperty(value="jurisdiction")
    public String getJurisdiction() {
        return this.jurisdiction;
    }

    @JsonProperty(value="jurisdiction")
    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    @JsonProperty(value="company")
    public OCCompanyForNesting getCompany() {
        return this.company;
    }

    @JsonProperty(value="company")
    public void setCompany(OCCompanyForNesting company) {
        this.company = company;
    }

    @JsonProperty(value="relationship_with_company")
    public RelationshipWithCompany getRelationshipWithCompany() {
        return this.relationshipWithCompany;
    }

    @JsonProperty(value="relationship_with_company")
    public void setRelationshipWithCompany(RelationshipWithCompany relationshipWithCompany) {
        this.relationshipWithCompany = relationshipWithCompany;
    }

    @JsonProperty(value="website")
    public Object getWebsite() {
        return this.website;
    }

    @JsonProperty(value="website")
    public void setWebsite(Object website) {
        this.website = website;
    }

    @JsonProperty(value="uid")
    public String getUid() {
        return this.uid;
    }

    @JsonProperty(value="uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    @JsonProperty(value="telephone_number")
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    @JsonProperty(value="telephone_number")
    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    @JsonProperty(value="fax_number")
    public String getFaxNumber() {
        return this.faxNumber;
    }

    @JsonProperty(value="fax_number")
    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
    }

    @JsonProperty(value="registered_address")
    public Object getRegisteredAddress() {
        return this.registeredAddress;
    }

    @JsonProperty(value="registered_address")
    public void setRegisteredAddress(Object registeredAddress) {
        this.registeredAddress = registeredAddress;
    }

    @JsonProperty(value="headquarters_address")
    public Object getHeadquartersAddress() {
        return this.headquartersAddress;
    }

    @JsonProperty(value="headquarters_address")
    public void setHeadquartersAddress(Object headquartersAddress) {
        this.headquartersAddress = headquartersAddress;
    }

    @JsonProperty(value="mailing_address")
    public Object getMailingAddress() {
        return this.mailingAddress;
    }

    @JsonProperty(value="mailing_address")
    public void setMailingAddress(Object mailingAddress) {
        this.mailingAddress = mailingAddress;
    }

    @JsonProperty(value="addresses")
    public List<OCAddressWithType> getAddresses() {
        return this.addresses;
    }

    @JsonProperty(value="addresses")
    public void setAddresses(List<OCAddressWithType> addresses) {
        this.addresses = addresses;
    }

    @JsonProperty(value="industry_codes")
    public List<OCIndustryCode> getIndustryCodes() {
        return this.industryCodes;
    }

    @JsonProperty(value="industry_codes")
    public void setIndustryCodes(List<OCIndustryCode> industryCodes) {
        this.industryCodes = industryCodes;
    }

    @JsonProperty(value="alternative_names")
    public List<OCAlternativeName> getAlternativeNames() {
        return this.alternativeNames;
    }

    @JsonProperty(value="alternative_names")
    public void setAlternativeNames(List<OCAlternativeName> alternativeNames) {
        this.alternativeNames = alternativeNames;
    }

    @JsonProperty(value="date_of_birth")
    public Object getDateOfBirth() {
        return this.dateOfBirth;
    }

    @JsonProperty(value="date_of_birth")
    public void setDateOfBirth(Object dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    @JsonProperty(value="nationality")
    public String getNationality() {
        return this.nationality;
    }

    @JsonProperty(value="nationality")
    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    @JsonProperty(value="country_of_residence")
    public String getCountryOfResidence() {
        return this.countryOfResidence;
    }

    @JsonProperty(value="country_of_residence")
    public void setCountryOfResidence(String countryOfResidence) {
        this.countryOfResidence = countryOfResidence;
    }

    @JsonProperty(value="identifiers")
    public List<OCIdentifier> getIdentifiers() {
        return this.identifiers;
    }

    @JsonProperty(value="identifiers")
    public void setIdentifiers(List<OCIdentifier> identifiers) {
        this.identifiers = identifiers;
    }

    @JsonProperty(value="other_attributes")
    public OCOtherAttributes__1 getOtherAttributes() {
        return this.otherAttributes;
    }

    @JsonProperty(value="other_attributes")
    public void setOtherAttributes(OCOtherAttributes__1 otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCPerson.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("jurisdiction");
        sb.append('=');
        sb.append(this.jurisdiction == null ? "<null>" : this.jurisdiction);
        sb.append(',');
        sb.append("company");
        sb.append('=');
        sb.append(this.company == null ? "<null>" : this.company);
        sb.append(',');
        sb.append("relationshipWithCompany");
        sb.append('=');
        sb.append(this.relationshipWithCompany == null ? "<null>" : this.relationshipWithCompany);
        sb.append(',');
        sb.append("website");
        sb.append('=');
        sb.append(this.website == null ? "<null>" : this.website);
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(this.uid == null ? "<null>" : this.uid);
        sb.append(',');
        sb.append("telephoneNumber");
        sb.append('=');
        sb.append(this.telephoneNumber == null ? "<null>" : this.telephoneNumber);
        sb.append(',');
        sb.append("faxNumber");
        sb.append('=');
        sb.append(this.faxNumber == null ? "<null>" : this.faxNumber);
        sb.append(',');
        sb.append("registeredAddress");
        sb.append('=');
        sb.append(this.registeredAddress == null ? "<null>" : this.registeredAddress);
        sb.append(',');
        sb.append("headquartersAddress");
        sb.append('=');
        sb.append(this.headquartersAddress == null ? "<null>" : this.headquartersAddress);
        sb.append(',');
        sb.append("mailingAddress");
        sb.append('=');
        sb.append(this.mailingAddress == null ? "<null>" : this.mailingAddress);
        sb.append(',');
        sb.append("addresses");
        sb.append('=');
        sb.append(this.addresses == null ? "<null>" : this.addresses);
        sb.append(',');
        sb.append("industryCodes");
        sb.append('=');
        sb.append(this.industryCodes == null ? "<null>" : this.industryCodes);
        sb.append(',');
        sb.append("alternativeNames");
        sb.append('=');
        sb.append(this.alternativeNames == null ? "<null>" : this.alternativeNames);
        sb.append(',');
        sb.append("dateOfBirth");
        sb.append('=');
        sb.append(this.dateOfBirth == null ? "<null>" : this.dateOfBirth);
        sb.append(',');
        sb.append("nationality");
        sb.append('=');
        sb.append(this.nationality == null ? "<null>" : this.nationality);
        sb.append(',');
        sb.append("countryOfResidence");
        sb.append('=');
        sb.append(this.countryOfResidence == null ? "<null>" : this.countryOfResidence);
        sb.append(',');
        sb.append("identifiers");
        sb.append('=');
        sb.append(this.identifiers == null ? "<null>" : this.identifiers);
        sb.append(',');
        sb.append("otherAttributes");
        sb.append('=');
        sb.append(this.otherAttributes == null ? "<null>" : this.otherAttributes);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.website == null ? 0 : this.website.hashCode());
        result = result * 31 + (this.addresses == null ? 0 : this.addresses.hashCode());
        result = result * 31 + (this.telephoneNumber == null ? 0 : this.telephoneNumber.hashCode());
        result = result * 31 + (this.identifiers == null ? 0 : this.identifiers.hashCode());
        result = result * 31 + (this.jurisdiction == null ? 0 : this.jurisdiction.hashCode());
        result = result * 31 + (this.dateOfBirth == null ? 0 : this.dateOfBirth.hashCode());
        result = result * 31 + (this.headquartersAddress == null ? 0 : this.headquartersAddress.hashCode());
        result = result * 31 + (this.industryCodes == null ? 0 : this.industryCodes.hashCode());
        result = result * 31 + (this.countryOfResidence == null ? 0 : this.countryOfResidence.hashCode());
        result = result * 31 + (this.otherAttributes == null ? 0 : this.otherAttributes.hashCode());
        result = result * 31 + (this.uid == null ? 0 : this.uid.hashCode());
        result = result * 31 + (this.alternativeNames == null ? 0 : this.alternativeNames.hashCode());
        result = result * 31 + (this.registeredAddress == null ? 0 : this.registeredAddress.hashCode());
        result = result * 31 + (this.nationality == null ? 0 : this.nationality.hashCode());
        result = result * 31 + (this.mailingAddress == null ? 0 : this.mailingAddress.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.relationshipWithCompany == null ? 0 : this.relationshipWithCompany.hashCode());
        result = result * 31 + (this.faxNumber == null ? 0 : this.faxNumber.hashCode());
        result = result * 31 + (this.company == null ? 0 : this.company.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCPerson)) {
            return false;
        }
        OCPerson rhs = (OCPerson)other;
        return (this.website == rhs.website || this.website != null && this.website.equals(rhs.website)) && (this.addresses == rhs.addresses || this.addresses != null && this.addresses.equals(rhs.addresses)) && (this.telephoneNumber == rhs.telephoneNumber || this.telephoneNumber != null && this.telephoneNumber.equals(rhs.telephoneNumber)) && (this.identifiers == rhs.identifiers || this.identifiers != null && this.identifiers.equals(rhs.identifiers)) && (this.jurisdiction == rhs.jurisdiction || this.jurisdiction != null && this.jurisdiction.equals(rhs.jurisdiction)) && (this.dateOfBirth == rhs.dateOfBirth || this.dateOfBirth != null && this.dateOfBirth.equals(rhs.dateOfBirth)) && (this.headquartersAddress == rhs.headquartersAddress || this.headquartersAddress != null && this.headquartersAddress.equals(rhs.headquartersAddress)) && (this.industryCodes == rhs.industryCodes || this.industryCodes != null && this.industryCodes.equals(rhs.industryCodes)) && (this.countryOfResidence == rhs.countryOfResidence || this.countryOfResidence != null && this.countryOfResidence.equals(rhs.countryOfResidence)) && (this.otherAttributes == rhs.otherAttributes || this.otherAttributes != null && this.otherAttributes.equals(rhs.otherAttributes)) && (this.uid == rhs.uid || this.uid != null && this.uid.equals(rhs.uid)) && (this.alternativeNames == rhs.alternativeNames || this.alternativeNames != null && this.alternativeNames.equals(rhs.alternativeNames)) && (this.registeredAddress == rhs.registeredAddress || this.registeredAddress != null && this.registeredAddress.equals(rhs.registeredAddress)) && (this.nationality == rhs.nationality || this.nationality != null && this.nationality.equals(rhs.nationality)) && (this.mailingAddress == rhs.mailingAddress || this.mailingAddress != null && this.mailingAddress.equals(rhs.mailingAddress)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.relationshipWithCompany == rhs.relationshipWithCompany || this.relationshipWithCompany != null && this.relationshipWithCompany.equals((Object)rhs.relationshipWithCompany)) && (this.faxNumber == rhs.faxNumber || this.faxNumber != null && this.faxNumber.equals(rhs.faxNumber)) && (this.company == rhs.company || this.company != null && this.company.equals(rhs.company));
    }

    public static enum RelationshipWithCompany {
        EMPLOYEE("employee"),
        DIRECTOR("director"),
        SHAREHOLDER("shareholder");

        private final String value;
        private static final Map<String, RelationshipWithCompany> CONSTANTS;

        private RelationshipWithCompany(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static RelationshipWithCompany fromValue(String value) {
            RelationshipWithCompany constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, RelationshipWithCompany>();
            for (RelationshipWithCompany c : RelationshipWithCompany.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

