
package com.opencorporates.schemas;

import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Other arbitrary attributes for a given company
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "jurisdiction_of_origin",
    "home_company_number",
    "home_legal_name",
    "merged_into"
})
public class OCAllAttributes {

    /**
     * The jurisdiction of the 'home' company if this is a branch
     * 
     */
    @JsonProperty("jurisdiction_of_origin")
    @JsonPropertyDescription("The jurisdiction of the 'home' company if this is a branch")
    @Size(min = 1)
    private String jurisdictionOfOrigin;
    /**
     * If the entity is a 'branch', this is the company_number of the 'home' company in the home company's jurisdiction
     * 
     */
    @JsonProperty("home_company_number")
    @JsonPropertyDescription("If the entity is a 'branch', this is the company_number of the 'home' company in the home company's jurisdiction")
    @Size(min = 1)
    private String homeCompanyNumber;
    /**
     * The legal name of the 'home' company in its jurisdiction if this is a branch, and the name is different from the legal name of the branch
     * 
     */
    @JsonProperty("home_legal_name")
    @JsonPropertyDescription("The legal name of the 'home' company in its jurisdiction if this is a branch, and the name is different from the legal name of the branch")
    @Size(min = 1)
    private String homeLegalName;
    /**
     * Information on the merger of this company into a 'survivor' company
     * 
     */
    @JsonProperty("merged_into")
    @JsonPropertyDescription("Information on the merger of this company into a 'survivor' company")
    @Valid
    private OCMergedInto mergedInto;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The jurisdiction of the 'home' company if this is a branch
     * 
     */
    @JsonProperty("jurisdiction_of_origin")
    public String getJurisdictionOfOrigin() {
        return jurisdictionOfOrigin;
    }

    /**
     * The jurisdiction of the 'home' company if this is a branch
     * 
     */
    @JsonProperty("jurisdiction_of_origin")
    public void setJurisdictionOfOrigin(String jurisdictionOfOrigin) {
        this.jurisdictionOfOrigin = jurisdictionOfOrigin;
    }

    /**
     * If the entity is a 'branch', this is the company_number of the 'home' company in the home company's jurisdiction
     * 
     */
    @JsonProperty("home_company_number")
    public String getHomeCompanyNumber() {
        return homeCompanyNumber;
    }

    /**
     * If the entity is a 'branch', this is the company_number of the 'home' company in the home company's jurisdiction
     * 
     */
    @JsonProperty("home_company_number")
    public void setHomeCompanyNumber(String homeCompanyNumber) {
        this.homeCompanyNumber = homeCompanyNumber;
    }

    /**
     * The legal name of the 'home' company in its jurisdiction if this is a branch, and the name is different from the legal name of the branch
     * 
     */
    @JsonProperty("home_legal_name")
    public String getHomeLegalName() {
        return homeLegalName;
    }

    /**
     * The legal name of the 'home' company in its jurisdiction if this is a branch, and the name is different from the legal name of the branch
     * 
     */
    @JsonProperty("home_legal_name")
    public void setHomeLegalName(String homeLegalName) {
        this.homeLegalName = homeLegalName;
    }

    /**
     * Information on the merger of this company into a 'survivor' company
     * 
     */
    @JsonProperty("merged_into")
    public OCMergedInto getMergedInto() {
        return mergedInto;
    }

    /**
     * Information on the merger of this company into a 'survivor' company
     * 
     */
    @JsonProperty("merged_into")
    public void setMergedInto(OCMergedInto mergedInto) {
        this.mergedInto = mergedInto;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCAllAttributes.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("jurisdictionOfOrigin");
        sb.append('=');
        sb.append(((this.jurisdictionOfOrigin == null)?"<null>":this.jurisdictionOfOrigin));
        sb.append(',');
        sb.append("homeCompanyNumber");
        sb.append('=');
        sb.append(((this.homeCompanyNumber == null)?"<null>":this.homeCompanyNumber));
        sb.append(',');
        sb.append("homeLegalName");
        sb.append('=');
        sb.append(((this.homeLegalName == null)?"<null>":this.homeLegalName));
        sb.append(',');
        sb.append("mergedInto");
        sb.append('=');
        sb.append(((this.mergedInto == null)?"<null>":this.mergedInto));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.jurisdictionOfOrigin == null)? 0 :this.jurisdictionOfOrigin.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.homeLegalName == null)? 0 :this.homeLegalName.hashCode()));
        result = ((result* 31)+((this.mergedInto == null)? 0 :this.mergedInto.hashCode()));
        result = ((result* 31)+((this.homeCompanyNumber == null)? 0 :this.homeCompanyNumber.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCAllAttributes) == false) {
            return false;
        }
        OCAllAttributes rhs = ((OCAllAttributes) other);
        return ((((((this.jurisdictionOfOrigin == rhs.jurisdictionOfOrigin)||((this.jurisdictionOfOrigin!= null)&&this.jurisdictionOfOrigin.equals(rhs.jurisdictionOfOrigin)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.homeLegalName == rhs.homeLegalName)||((this.homeLegalName!= null)&&this.homeLegalName.equals(rhs.homeLegalName))))&&((this.mergedInto == rhs.mergedInto)||((this.mergedInto!= null)&&this.mergedInto.equals(rhs.mergedInto))))&&((this.homeCompanyNumber == rhs.homeCompanyNumber)||((this.homeCompanyNumber!= null)&&this.homeCompanyNumber.equals(rhs.homeCompanyNumber))));
    }

}
