
package com.opencorporates.schemas;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * A representation of multiple registrations for the same entity
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "data_type",
    "alternate_entities",
    "alternate_registration_start_date",
    "alternate_registration_end_date",
    "publication_date",
    "start_date",
    "start_date_type",
    "sample_date",
    "retrieved_at",
    "source_url",
    "confidence"
})
public class OCAlternateRegistrationSchema {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("data_type")
    @NotNull
    private OCAlternateRegistrationSchema.DataType dataType;
    /**
     * array of entities that are linked via alternate registrations
     * (Required)
     * 
     */
    @JsonProperty("alternate_entities")
    @JsonPropertyDescription("array of entities that are linked via alternate registrations")
    @Valid
    @NotNull
    private List<OCEntity> alternateEntities = new ArrayList<OCEntity>();
    /**
     * date when alternate registration started
     * 
     */
    @JsonProperty("alternate_registration_start_date")
    @JsonPropertyDescription("date when alternate registration started")
    private LocalDate alternateRegistrationStartDate;
    /**
     * date when alternate registration ended
     * 
     */
    @JsonProperty("alternate_registration_end_date")
    @JsonPropertyDescription("date when alternate registration ended")
    private LocalDate alternateRegistrationEndDate;
    /**
     * the publication date of the filing/notice that gives details of the alternate registration
     * 
     */
    @JsonProperty("publication_date")
    @JsonPropertyDescription("the publication date of the filing/notice that gives details of the alternate registration")
    private LocalDate publicationDate;
    /**
     * date when alternate registration was valid from
     * 
     */
    @JsonProperty("start_date")
    @JsonPropertyDescription("date when alternate registration was valid from")
    private LocalDate startDate;
    @JsonProperty("start_date_type")
    private OCAlternateRegistrationSchema.StartDateType startDateType;
    /**
     * date when alternate registration was sampled
     * 
     */
    @JsonProperty("sample_date")
    @JsonPropertyDescription("date when alternate registration was sampled")
    private LocalDate sampleDate;
    /**
     * date when alternate registration was retrieved
     * (Required)
     * 
     */
    @JsonProperty("retrieved_at")
    @JsonPropertyDescription("date when alternate registration was retrieved")
    @NotNull
    private LocalDate retrievedAt;
    /**
     * URL of the source of the data (e.g. download URL), or if there is not persistent URL the page from which it can be found (e.g. search page)
     * 
     */
    @JsonProperty("source_url")
    @JsonPropertyDescription("URL of the source of the data (e.g. download URL), or if there is not persistent URL the page from which it can be found (e.g. search page)")
    private String sourceUrl;
    /**
     * Confidence in accuracy of data
     * (Required)
     * 
     */
    @JsonProperty("confidence")
    @JsonPropertyDescription("Confidence in accuracy of data")
    @NotNull
    private OCAlternateRegistrationSchema.Confidence confidence;

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("data_type")
    public OCAlternateRegistrationSchema.DataType getDataType() {
        return dataType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("data_type")
    public void setDataType(OCAlternateRegistrationSchema.DataType dataType) {
        this.dataType = dataType;
    }

    /**
     * array of entities that are linked via alternate registrations
     * (Required)
     * 
     */
    @JsonProperty("alternate_entities")
    public List<OCEntity> getAlternateEntities() {
        return alternateEntities;
    }

    /**
     * array of entities that are linked via alternate registrations
     * (Required)
     * 
     */
    @JsonProperty("alternate_entities")
    public void setAlternateEntities(List<OCEntity> alternateEntities) {
        this.alternateEntities = alternateEntities;
    }

    /**
     * date when alternate registration started
     * 
     */
    @JsonProperty("alternate_registration_start_date")
    public LocalDate getAlternateRegistrationStartDate() {
        return alternateRegistrationStartDate;
    }

    /**
     * date when alternate registration started
     * 
     */
    @JsonProperty("alternate_registration_start_date")
    public void setAlternateRegistrationStartDate(LocalDate alternateRegistrationStartDate) {
        this.alternateRegistrationStartDate = alternateRegistrationStartDate;
    }

    /**
     * date when alternate registration ended
     * 
     */
    @JsonProperty("alternate_registration_end_date")
    public LocalDate getAlternateRegistrationEndDate() {
        return alternateRegistrationEndDate;
    }

    /**
     * date when alternate registration ended
     * 
     */
    @JsonProperty("alternate_registration_end_date")
    public void setAlternateRegistrationEndDate(LocalDate alternateRegistrationEndDate) {
        this.alternateRegistrationEndDate = alternateRegistrationEndDate;
    }

    /**
     * the publication date of the filing/notice that gives details of the alternate registration
     * 
     */
    @JsonProperty("publication_date")
    public LocalDate getPublicationDate() {
        return publicationDate;
    }

    /**
     * the publication date of the filing/notice that gives details of the alternate registration
     * 
     */
    @JsonProperty("publication_date")
    public void setPublicationDate(LocalDate publicationDate) {
        this.publicationDate = publicationDate;
    }

    /**
     * date when alternate registration was valid from
     * 
     */
    @JsonProperty("start_date")
    public LocalDate getStartDate() {
        return startDate;
    }

    /**
     * date when alternate registration was valid from
     * 
     */
    @JsonProperty("start_date")
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    @JsonProperty("start_date_type")
    public OCAlternateRegistrationSchema.StartDateType getStartDateType() {
        return startDateType;
    }

    @JsonProperty("start_date_type")
    public void setStartDateType(OCAlternateRegistrationSchema.StartDateType startDateType) {
        this.startDateType = startDateType;
    }

    /**
     * date when alternate registration was sampled
     * 
     */
    @JsonProperty("sample_date")
    public LocalDate getSampleDate() {
        return sampleDate;
    }

    /**
     * date when alternate registration was sampled
     * 
     */
    @JsonProperty("sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    /**
     * date when alternate registration was retrieved
     * (Required)
     * 
     */
    @JsonProperty("retrieved_at")
    public LocalDate getRetrievedAt() {
        return retrievedAt;
    }

    /**
     * date when alternate registration was retrieved
     * (Required)
     * 
     */
    @JsonProperty("retrieved_at")
    public void setRetrievedAt(LocalDate retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    /**
     * URL of the source of the data (e.g. download URL), or if there is not persistent URL the page from which it can be found (e.g. search page)
     * 
     */
    @JsonProperty("source_url")
    public String getSourceUrl() {
        return sourceUrl;
    }

    /**
     * URL of the source of the data (e.g. download URL), or if there is not persistent URL the page from which it can be found (e.g. search page)
     * 
     */
    @JsonProperty("source_url")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    /**
     * Confidence in accuracy of data
     * (Required)
     * 
     */
    @JsonProperty("confidence")
    public OCAlternateRegistrationSchema.Confidence getConfidence() {
        return confidence;
    }

    /**
     * Confidence in accuracy of data
     * (Required)
     * 
     */
    @JsonProperty("confidence")
    public void setConfidence(OCAlternateRegistrationSchema.Confidence confidence) {
        this.confidence = confidence;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCAlternateRegistrationSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dataType");
        sb.append('=');
        sb.append(((this.dataType == null)?"<null>":this.dataType));
        sb.append(',');
        sb.append("alternateEntities");
        sb.append('=');
        sb.append(((this.alternateEntities == null)?"<null>":this.alternateEntities));
        sb.append(',');
        sb.append("alternateRegistrationStartDate");
        sb.append('=');
        sb.append(((this.alternateRegistrationStartDate == null)?"<null>":this.alternateRegistrationStartDate));
        sb.append(',');
        sb.append("alternateRegistrationEndDate");
        sb.append('=');
        sb.append(((this.alternateRegistrationEndDate == null)?"<null>":this.alternateRegistrationEndDate));
        sb.append(',');
        sb.append("publicationDate");
        sb.append('=');
        sb.append(((this.publicationDate == null)?"<null>":this.publicationDate));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("startDateType");
        sb.append('=');
        sb.append(((this.startDateType == null)?"<null>":this.startDateType));
        sb.append(',');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(((this.sampleDate == null)?"<null>":this.sampleDate));
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(((this.retrievedAt == null)?"<null>":this.retrievedAt));
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(((this.sourceUrl == null)?"<null>":this.sourceUrl));
        sb.append(',');
        sb.append("confidence");
        sb.append('=');
        sb.append(((this.confidence == null)?"<null>":this.confidence));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.sourceUrl == null)? 0 :this.sourceUrl.hashCode()));
        result = ((result* 31)+((this.retrievedAt == null)? 0 :this.retrievedAt.hashCode()));
        result = ((result* 31)+((this.alternateEntities == null)? 0 :this.alternateEntities.hashCode()));
        result = ((result* 31)+((this.startDateType == null)? 0 :this.startDateType.hashCode()));
        result = ((result* 31)+((this.dataType == null)? 0 :this.dataType.hashCode()));
        result = ((result* 31)+((this.confidence == null)? 0 :this.confidence.hashCode()));
        result = ((result* 31)+((this.alternateRegistrationStartDate == null)? 0 :this.alternateRegistrationStartDate.hashCode()));
        result = ((result* 31)+((this.sampleDate == null)? 0 :this.sampleDate.hashCode()));
        result = ((result* 31)+((this.alternateRegistrationEndDate == null)? 0 :this.alternateRegistrationEndDate.hashCode()));
        result = ((result* 31)+((this.publicationDate == null)? 0 :this.publicationDate.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCAlternateRegistrationSchema) == false) {
            return false;
        }
        OCAlternateRegistrationSchema rhs = ((OCAlternateRegistrationSchema) other);
        return ((((((((((((this.sourceUrl == rhs.sourceUrl)||((this.sourceUrl!= null)&&this.sourceUrl.equals(rhs.sourceUrl)))&&((this.retrievedAt == rhs.retrievedAt)||((this.retrievedAt!= null)&&this.retrievedAt.equals(rhs.retrievedAt))))&&((this.alternateEntities == rhs.alternateEntities)||((this.alternateEntities!= null)&&this.alternateEntities.equals(rhs.alternateEntities))))&&((this.startDateType == rhs.startDateType)||((this.startDateType!= null)&&this.startDateType.equals(rhs.startDateType))))&&((this.dataType == rhs.dataType)||((this.dataType!= null)&&this.dataType.equals(rhs.dataType))))&&((this.confidence == rhs.confidence)||((this.confidence!= null)&&this.confidence.equals(rhs.confidence))))&&((this.alternateRegistrationStartDate == rhs.alternateRegistrationStartDate)||((this.alternateRegistrationStartDate!= null)&&this.alternateRegistrationStartDate.equals(rhs.alternateRegistrationStartDate))))&&((this.sampleDate == rhs.sampleDate)||((this.sampleDate!= null)&&this.sampleDate.equals(rhs.sampleDate))))&&((this.alternateRegistrationEndDate == rhs.alternateRegistrationEndDate)||((this.alternateRegistrationEndDate!= null)&&this.alternateRegistrationEndDate.equals(rhs.alternateRegistrationEndDate))))&&((this.publicationDate == rhs.publicationDate)||((this.publicationDate!= null)&&this.publicationDate.equals(rhs.publicationDate))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))));
    }


    /**
     * Confidence in accuracy of data
     * 
     */
    public enum Confidence {

        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");
        private final String value;
        private final static Map<String, OCAlternateRegistrationSchema.Confidence> CONSTANTS = new HashMap<String, OCAlternateRegistrationSchema.Confidence>();

        static {
            for (OCAlternateRegistrationSchema.Confidence c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Confidence(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCAlternateRegistrationSchema.Confidence fromValue(String value) {
            OCAlternateRegistrationSchema.Confidence constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum DataType {

        ALTERNATE_REGISTRATION("alternate-registration");
        private final String value;
        private final static Map<String, OCAlternateRegistrationSchema.DataType> CONSTANTS = new HashMap<String, OCAlternateRegistrationSchema.DataType>();

        static {
            for (OCAlternateRegistrationSchema.DataType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private DataType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCAlternateRegistrationSchema.DataType fromValue(String value) {
            OCAlternateRegistrationSchema.DataType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum StartDateType {

        AT("at"),
        BEFORE("before"),
        AFTER("after");
        private final String value;
        private final static Map<String, OCAlternateRegistrationSchema.StartDateType> CONSTANTS = new HashMap<String, OCAlternateRegistrationSchema.StartDateType>();

        static {
            for (OCAlternateRegistrationSchema.StartDateType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private StartDateType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCAlternateRegistrationSchema.StartDateType fromValue(String value) {
            OCAlternateRegistrationSchema.StartDateType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
