
package com.opencorporates.schemas;

import java.net.URI;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Document
 * <p>
 * A section of an issue
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "page_range",
    "url",
    "media_type"
})
public class OCDocument {

    /**
     * The page range of the document within the issue
     * 
     */
    @JsonProperty("page_range")
    @JsonPropertyDescription("The page range of the document within the issue")
    @Pattern(regexp = "^[0-9]*(-[0-9]*)?$")
    private String pageRange;
    /**
     * The URL of the document
     * (Required)
     * 
     */
    @JsonProperty("url")
    @JsonPropertyDescription("The URL of the document")
    @NotNull
    private URI url;
    /**
     * The media type of the URL resource
     * 
     */
    @JsonProperty("media_type")
    @JsonPropertyDescription("The media type of the URL resource")
    private String mediaType;

    /**
     * The page range of the document within the issue
     * 
     */
    @JsonProperty("page_range")
    public String getPageRange() {
        return pageRange;
    }

    /**
     * The page range of the document within the issue
     * 
     */
    @JsonProperty("page_range")
    public void setPageRange(String pageRange) {
        this.pageRange = pageRange;
    }

    /**
     * The URL of the document
     * (Required)
     * 
     */
    @JsonProperty("url")
    public URI getUrl() {
        return url;
    }

    /**
     * The URL of the document
     * (Required)
     * 
     */
    @JsonProperty("url")
    public void setUrl(URI url) {
        this.url = url;
    }

    /**
     * The media type of the URL resource
     * 
     */
    @JsonProperty("media_type")
    public String getMediaType() {
        return mediaType;
    }

    /**
     * The media type of the URL resource
     * 
     */
    @JsonProperty("media_type")
    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCDocument.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("pageRange");
        sb.append('=');
        sb.append(((this.pageRange == null)?"<null>":this.pageRange));
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(((this.url == null)?"<null>":this.url));
        sb.append(',');
        sb.append("mediaType");
        sb.append('=');
        sb.append(((this.mediaType == null)?"<null>":this.mediaType));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.pageRange == null)? 0 :this.pageRange.hashCode()));
        result = ((result* 31)+((this.mediaType == null)? 0 :this.mediaType.hashCode()));
        result = ((result* 31)+((this.url == null)? 0 :this.url.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCDocument) == false) {
            return false;
        }
        OCDocument rhs = ((OCDocument) other);
        return ((((this.pageRange == rhs.pageRange)||((this.pageRange!= null)&&this.pageRange.equals(rhs.pageRange)))&&((this.mediaType == rhs.mediaType)||((this.mediaType!= null)&&this.mediaType.equals(rhs.mediaType))))&&((this.url == rhs.url)||((this.url!= null)&&this.url.equals(rhs.url))));
    }

}
