
package com.opencorporates.schemas;

import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * A document of some sort (PDF, TIFF, HTML) associated with a filing
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "uid",
    "file_format",
    "original_source_url",
    "source_url",
    "source_location",
    "language",
    "classification",
    "pages"
})
public class OCFilingDocument {

    /**
     * Unique id/reference for the filing if it has one
     * 
     */
    @JsonProperty("uid")
    @JsonPropertyDescription("Unique id/reference for the filing if it has one")
    private String uid;
    /**
     * Format of the document, if known
     * 
     */
    @JsonProperty("file_format")
    @JsonPropertyDescription("Format of the document, if known")
    private OCFilingDocument.FileFormat fileFormat;
    /**
     * Persistent URL for the document, if there is one
     * 
     */
    @JsonProperty("original_source_url")
    @JsonPropertyDescription("Persistent URL for the document, if there is one")
    private String originalSourceUrl;
    /**
     * Source url of the web page for the filing or if there is not persistent URL the page from which it can be found (e.g. search page)
     * 
     */
    @JsonProperty("source_url")
    @JsonPropertyDescription("Source url of the web page for the filing or if there is not persistent URL the page from which it can be found (e.g. search page)")
    @Size(min = 11)
    private String sourceUrl;
    /**
     * If the accounts filing has been put on sources.opencorporates.com the path to the filing
     * 
     */
    @JsonProperty("source_location")
    @JsonPropertyDescription("If the accounts filing has been put on sources.opencorporates.com the path to the filing")
    private String sourceLocation;
    /**
     * Should be represented as two-letter ISO-639 code
     * 
     */
    @JsonProperty("language")
    @JsonPropertyDescription("Should be represented as two-letter ISO-639 code")
    @Size(min = 2, max = 2)
    private String language;
    /**
     * type of document (at the moment only XBRL is the only option here)
     * 
     */
    @JsonProperty("classification")
    @JsonPropertyDescription("type of document (at the moment only XBRL is the only option here)")
    private OCFilingDocument.Classification classification;
    /**
     * Number of pages, if known
     * 
     */
    @JsonProperty("pages")
    @JsonPropertyDescription("Number of pages, if known")
    private Integer pages;

    /**
     * Unique id/reference for the filing if it has one
     * 
     */
    @JsonProperty("uid")
    public String getUid() {
        return uid;
    }

    /**
     * Unique id/reference for the filing if it has one
     * 
     */
    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    /**
     * Format of the document, if known
     * 
     */
    @JsonProperty("file_format")
    public OCFilingDocument.FileFormat getFileFormat() {
        return fileFormat;
    }

    /**
     * Format of the document, if known
     * 
     */
    @JsonProperty("file_format")
    public void setFileFormat(OCFilingDocument.FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    /**
     * Persistent URL for the document, if there is one
     * 
     */
    @JsonProperty("original_source_url")
    public String getOriginalSourceUrl() {
        return originalSourceUrl;
    }

    /**
     * Persistent URL for the document, if there is one
     * 
     */
    @JsonProperty("original_source_url")
    public void setOriginalSourceUrl(String originalSourceUrl) {
        this.originalSourceUrl = originalSourceUrl;
    }

    /**
     * Source url of the web page for the filing or if there is not persistent URL the page from which it can be found (e.g. search page)
     * 
     */
    @JsonProperty("source_url")
    public String getSourceUrl() {
        return sourceUrl;
    }

    /**
     * Source url of the web page for the filing or if there is not persistent URL the page from which it can be found (e.g. search page)
     * 
     */
    @JsonProperty("source_url")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    /**
     * If the accounts filing has been put on sources.opencorporates.com the path to the filing
     * 
     */
    @JsonProperty("source_location")
    public String getSourceLocation() {
        return sourceLocation;
    }

    /**
     * If the accounts filing has been put on sources.opencorporates.com the path to the filing
     * 
     */
    @JsonProperty("source_location")
    public void setSourceLocation(String sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    /**
     * Should be represented as two-letter ISO-639 code
     * 
     */
    @JsonProperty("language")
    public String getLanguage() {
        return language;
    }

    /**
     * Should be represented as two-letter ISO-639 code
     * 
     */
    @JsonProperty("language")
    public void setLanguage(String language) {
        this.language = language;
    }

    /**
     * type of document (at the moment only XBRL is the only option here)
     * 
     */
    @JsonProperty("classification")
    public OCFilingDocument.Classification getClassification() {
        return classification;
    }

    /**
     * type of document (at the moment only XBRL is the only option here)
     * 
     */
    @JsonProperty("classification")
    public void setClassification(OCFilingDocument.Classification classification) {
        this.classification = classification;
    }

    /**
     * Number of pages, if known
     * 
     */
    @JsonProperty("pages")
    public Integer getPages() {
        return pages;
    }

    /**
     * Number of pages, if known
     * 
     */
    @JsonProperty("pages")
    public void setPages(Integer pages) {
        this.pages = pages;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCFilingDocument.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("fileFormat");
        sb.append('=');
        sb.append(((this.fileFormat == null)?"<null>":this.fileFormat));
        sb.append(',');
        sb.append("originalSourceUrl");
        sb.append('=');
        sb.append(((this.originalSourceUrl == null)?"<null>":this.originalSourceUrl));
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(((this.sourceUrl == null)?"<null>":this.sourceUrl));
        sb.append(',');
        sb.append("sourceLocation");
        sb.append('=');
        sb.append(((this.sourceLocation == null)?"<null>":this.sourceLocation));
        sb.append(',');
        sb.append("language");
        sb.append('=');
        sb.append(((this.language == null)?"<null>":this.language));
        sb.append(',');
        sb.append("classification");
        sb.append('=');
        sb.append(((this.classification == null)?"<null>":this.classification));
        sb.append(',');
        sb.append("pages");
        sb.append('=');
        sb.append(((this.pages == null)?"<null>":this.pages));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.originalSourceUrl == null)? 0 :this.originalSourceUrl.hashCode()));
        result = ((result* 31)+((this.sourceUrl == null)? 0 :this.sourceUrl.hashCode()));
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.pages == null)? 0 :this.pages.hashCode()));
        result = ((result* 31)+((this.sourceLocation == null)? 0 :this.sourceLocation.hashCode()));
        result = ((result* 31)+((this.language == null)? 0 :this.language.hashCode()));
        result = ((result* 31)+((this.classification == null)? 0 :this.classification.hashCode()));
        result = ((result* 31)+((this.fileFormat == null)? 0 :this.fileFormat.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCFilingDocument) == false) {
            return false;
        }
        OCFilingDocument rhs = ((OCFilingDocument) other);
        return (((((((((this.originalSourceUrl == rhs.originalSourceUrl)||((this.originalSourceUrl!= null)&&this.originalSourceUrl.equals(rhs.originalSourceUrl)))&&((this.sourceUrl == rhs.sourceUrl)||((this.sourceUrl!= null)&&this.sourceUrl.equals(rhs.sourceUrl))))&&((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid))))&&((this.pages == rhs.pages)||((this.pages!= null)&&this.pages.equals(rhs.pages))))&&((this.sourceLocation == rhs.sourceLocation)||((this.sourceLocation!= null)&&this.sourceLocation.equals(rhs.sourceLocation))))&&((this.language == rhs.language)||((this.language!= null)&&this.language.equals(rhs.language))))&&((this.classification == rhs.classification)||((this.classification!= null)&&this.classification.equals(rhs.classification))))&&((this.fileFormat == rhs.fileFormat)||((this.fileFormat!= null)&&this.fileFormat.equals(rhs.fileFormat))));
    }


    /**
     * type of document (at the moment only XBRL is the only option here)
     * 
     */
    public enum Classification {

        XBRL("xbrl");
        private final String value;
        private final static Map<String, OCFilingDocument.Classification> CONSTANTS = new HashMap<String, OCFilingDocument.Classification>();

        static {
            for (OCFilingDocument.Classification c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Classification(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCFilingDocument.Classification fromValue(String value) {
            OCFilingDocument.Classification constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }


    /**
     * Format of the document, if known
     * 
     */
    public enum FileFormat {

        XML("xml"),
        PDF("pdf"),
        HTML("html"),
        DOC("doc");
        private final String value;
        private final static Map<String, OCFilingDocument.FileFormat> CONSTANTS = new HashMap<String, OCFilingDocument.FileFormat>();

        static {
            for (OCFilingDocument.FileFormat c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private FileFormat(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCFilingDocument.FileFormat fromValue(String value) {
            OCFilingDocument.FileFormat constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
