
package com.opencorporates.schemas;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * A Financial-Payment is a payment from government to a recipient
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "sample_date",
    "source_jurisdiction",
    "company",
    "data",
    "retrieved_at"
})
public class OCFinancialPaymentSchema {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    @NotNull
    private LocalDate sampleDate;
    /**
     * Jurisdiction of the source of the data
     * 
     */
    @JsonProperty("source_jurisdiction")
    @JsonPropertyDescription("Jurisdiction of the source of the data")
    private String sourceJurisdiction;
    /**
     * A company which is the subject of a statement
     * (Required)
     * 
     */
    @JsonProperty("company")
    @JsonPropertyDescription("A company which is the subject of a statement")
    @Valid
    @NotNull
    private OCCompany company;
    /**
     * This is an array of data objects, that is the objects which actually contain the data about the datum. Generally there will only be one element in this, although in for some types of data_types there may naturally be several releated to the same company, e.g. shareholders
     * (Required)
     * 
     */
    @JsonProperty("data")
    @JsonPropertyDescription("This is an array of data objects, that is the objects which actually contain the data about the datum. Generally there will only be one element in this, although in for some types of data_types there may naturally be several releated to the same company, e.g. shareholders")
    @Valid
    @NotNull
    private List<OCFinancialPaymentDataObject> data = new ArrayList<OCFinancialPaymentDataObject>();
    @JsonProperty("retrieved_at")
    private LocalDate retrievedAt;

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    public LocalDate getSampleDate() {
        return sampleDate;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    /**
     * Jurisdiction of the source of the data
     * 
     */
    @JsonProperty("source_jurisdiction")
    public String getSourceJurisdiction() {
        return sourceJurisdiction;
    }

    /**
     * Jurisdiction of the source of the data
     * 
     */
    @JsonProperty("source_jurisdiction")
    public void setSourceJurisdiction(String sourceJurisdiction) {
        this.sourceJurisdiction = sourceJurisdiction;
    }

    /**
     * A company which is the subject of a statement
     * (Required)
     * 
     */
    @JsonProperty("company")
    public OCCompany getCompany() {
        return company;
    }

    /**
     * A company which is the subject of a statement
     * (Required)
     * 
     */
    @JsonProperty("company")
    public void setCompany(OCCompany company) {
        this.company = company;
    }

    /**
     * This is an array of data objects, that is the objects which actually contain the data about the datum. Generally there will only be one element in this, although in for some types of data_types there may naturally be several releated to the same company, e.g. shareholders
     * (Required)
     * 
     */
    @JsonProperty("data")
    public List<OCFinancialPaymentDataObject> getData() {
        return data;
    }

    /**
     * This is an array of data objects, that is the objects which actually contain the data about the datum. Generally there will only be one element in this, although in for some types of data_types there may naturally be several releated to the same company, e.g. shareholders
     * (Required)
     * 
     */
    @JsonProperty("data")
    public void setData(List<OCFinancialPaymentDataObject> data) {
        this.data = data;
    }

    @JsonProperty("retrieved_at")
    public LocalDate getRetrievedAt() {
        return retrievedAt;
    }

    @JsonProperty("retrieved_at")
    public void setRetrievedAt(LocalDate retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCFinancialPaymentSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(((this.sampleDate == null)?"<null>":this.sampleDate));
        sb.append(',');
        sb.append("sourceJurisdiction");
        sb.append('=');
        sb.append(((this.sourceJurisdiction == null)?"<null>":this.sourceJurisdiction));
        sb.append(',');
        sb.append("company");
        sb.append('=');
        sb.append(((this.company == null)?"<null>":this.company));
        sb.append(',');
        sb.append("data");
        sb.append('=');
        sb.append(((this.data == null)?"<null>":this.data));
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(((this.retrievedAt == null)?"<null>":this.retrievedAt));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.sampleDate == null)? 0 :this.sampleDate.hashCode()));
        result = ((result* 31)+((this.company == null)? 0 :this.company.hashCode()));
        result = ((result* 31)+((this.sourceJurisdiction == null)? 0 :this.sourceJurisdiction.hashCode()));
        result = ((result* 31)+((this.data == null)? 0 :this.data.hashCode()));
        result = ((result* 31)+((this.retrievedAt == null)? 0 :this.retrievedAt.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCFinancialPaymentSchema) == false) {
            return false;
        }
        OCFinancialPaymentSchema rhs = ((OCFinancialPaymentSchema) other);
        return ((((((this.sampleDate == rhs.sampleDate)||((this.sampleDate!= null)&&this.sampleDate.equals(rhs.sampleDate)))&&((this.company == rhs.company)||((this.company!= null)&&this.company.equals(rhs.company))))&&((this.sourceJurisdiction == rhs.sourceJurisdiction)||((this.sourceJurisdiction!= null)&&this.sourceJurisdiction.equals(rhs.sourceJurisdiction))))&&((this.data == rhs.data)||((this.data!= null)&&this.data.equals(rhs.data))))&&((this.retrievedAt == rhs.retrievedAt)||((this.retrievedAt!= null)&&this.retrievedAt.equals(rhs.retrievedAt))));
    }

}
