
package com.opencorporates.schemas;

import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * An identifier for an entity (possibly other things, e.g. securities in the future). Examples are tax IDs, non-profit IDs, SEC CIK numbers, Federal Reserve RSSD id. The main requirements for an identifier is that they should be well-defined, and issued by a government or have statutory standing
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "uid",
    "identifier_system_code"
})
public class OCIdentifier {

    /**
     * The unique identifier given by the identifier system – it should be unique in the context of the identifier_system
     * (Required)
     * 
     */
    @JsonProperty("uid")
    @JsonPropertyDescription("The unique identifier given by the identifier system \u2013 it should be unique in the context of the identifier_system")
    @Size(min = 1)
    @NotNull
    private String uid;
    /**
     * An identifier representing the identifier scheme. Some examples of this are us_fein (US Federal tax number), us_sec_cik (US Securities and Exchange Commission CIK), uk_ew_cc (Charity Commission of England & Wales), lei (Global Legal Entity Identifier System)
     * (Required)
     * 
     */
    @JsonProperty("identifier_system_code")
    @JsonPropertyDescription("An identifier representing the identifier scheme. Some examples of this are us_fein (US Federal tax number), us_sec_cik (US Securities and Exchange Commission CIK), uk_ew_cc (Charity Commission of England & Wales), lei (Global Legal Entity Identifier System)")
    @NotNull
    private String identifierSystemCode;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The unique identifier given by the identifier system – it should be unique in the context of the identifier_system
     * (Required)
     * 
     */
    @JsonProperty("uid")
    public String getUid() {
        return uid;
    }

    /**
     * The unique identifier given by the identifier system – it should be unique in the context of the identifier_system
     * (Required)
     * 
     */
    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    /**
     * An identifier representing the identifier scheme. Some examples of this are us_fein (US Federal tax number), us_sec_cik (US Securities and Exchange Commission CIK), uk_ew_cc (Charity Commission of England & Wales), lei (Global Legal Entity Identifier System)
     * (Required)
     * 
     */
    @JsonProperty("identifier_system_code")
    public String getIdentifierSystemCode() {
        return identifierSystemCode;
    }

    /**
     * An identifier representing the identifier scheme. Some examples of this are us_fein (US Federal tax number), us_sec_cik (US Securities and Exchange Commission CIK), uk_ew_cc (Charity Commission of England & Wales), lei (Global Legal Entity Identifier System)
     * (Required)
     * 
     */
    @JsonProperty("identifier_system_code")
    public void setIdentifierSystemCode(String identifierSystemCode) {
        this.identifierSystemCode = identifierSystemCode;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCIdentifier.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("identifierSystemCode");
        sb.append('=');
        sb.append(((this.identifierSystemCode == null)?"<null>":this.identifierSystemCode));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.identifierSystemCode == null)? 0 :this.identifierSystemCode.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCIdentifier) == false) {
            return false;
        }
        OCIdentifier rhs = ((OCIdentifier) other);
        return ((((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid)))&&((this.identifierSystemCode == rhs.identifierSystemCode)||((this.identifierSystemCode!= null)&&this.identifierSystemCode.equals(rhs.identifierSystemCode))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
