
package com.opencorporates.schemas;

import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * The issue of the gazette in which the notice is published. An issue contains many notices.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "identifier",
    "edition_id"
})
public class OCIssue {

    /**
     * The identifier of the issue
     * (Required)
     * 
     */
    @JsonProperty("identifier")
    @JsonPropertyDescription("The identifier of the issue")
    @NotNull
    private String identifier;
    /**
     * The identifier of the edition of which the issue is a part
     * 
     */
    @JsonProperty("edition_id")
    @JsonPropertyDescription("The identifier of the edition of which the issue is a part")
    private String editionId;

    /**
     * The identifier of the issue
     * (Required)
     * 
     */
    @JsonProperty("identifier")
    public String getIdentifier() {
        return identifier;
    }

    /**
     * The identifier of the issue
     * (Required)
     * 
     */
    @JsonProperty("identifier")
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    /**
     * The identifier of the edition of which the issue is a part
     * 
     */
    @JsonProperty("edition_id")
    public String getEditionId() {
        return editionId;
    }

    /**
     * The identifier of the edition of which the issue is a part
     * 
     */
    @JsonProperty("edition_id")
    public void setEditionId(String editionId) {
        this.editionId = editionId;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCIssue.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("identifier");
        sb.append('=');
        sb.append(((this.identifier == null)?"<null>":this.identifier));
        sb.append(',');
        sb.append("editionId");
        sb.append('=');
        sb.append(((this.editionId == null)?"<null>":this.editionId));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.editionId == null)? 0 :this.editionId.hashCode()));
        result = ((result* 31)+((this.identifier == null)? 0 :this.identifier.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCIssue) == false) {
            return false;
        }
        OCIssue rhs = ((OCIssue) other);
        return (((this.editionId == rhs.editionId)||((this.editionId!= null)&&this.editionId.equals(rhs.editionId)))&&((this.identifier == rhs.identifier)||((this.identifier!= null)&&this.identifier.equals(rhs.identifier))));
    }

}
