
package com.opencorporates.schemas;

import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Enhanced description for NICE Trademark Classification
 * <p>
 * NICE Trademark classifications are quite broad, and the specific areas being claimed for are often not for a complete classification but for an arbitrary set of areas, specified in freetext by the trademark owner.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "language",
    "description"
})
public class OCNiceEnhancedDescription {

    /**
     * The language code as 2-letter ISO 639 language code
     * 
     */
    @JsonProperty("language")
    @JsonPropertyDescription("The language code as 2-letter ISO 639 language code")
    @Size(min = 2, max = 2)
    private String language;
    /**
     * The text of the description
     * 
     */
    @JsonProperty("description")
    @JsonPropertyDescription("The text of the description")
    private String description;

    /**
     * The language code as 2-letter ISO 639 language code
     * 
     */
    @JsonProperty("language")
    public String getLanguage() {
        return language;
    }

    /**
     * The language code as 2-letter ISO 639 language code
     * 
     */
    @JsonProperty("language")
    public void setLanguage(String language) {
        this.language = language;
    }

    /**
     * The text of the description
     * 
     */
    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    /**
     * The text of the description
     * 
     */
    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCNiceEnhancedDescription.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("language");
        sb.append('=');
        sb.append(((this.language == null)?"<null>":this.language));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.language == null)? 0 :this.language.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCNiceEnhancedDescription) == false) {
            return false;
        }
        OCNiceEnhancedDescription rhs = ((OCNiceEnhancedDescription) other);
        return (((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description)))&&((this.language == rhs.language)||((this.language!= null)&&this.language.equals(rhs.language))));
    }

}
