
package com.opencorporates.schemas;

import java.net.URI;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Publication
 * <p>
 * A gazette
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "publisher",
    "jurisdiction_code",
    "title",
    "url",
    "media_type"
})
public class OCPublication {

    /**
     * Publisher
     * <p>
     * A gazette publisher
     * (Required)
     * 
     */
    @JsonProperty("publisher")
    @JsonPropertyDescription("A gazette publisher")
    @Valid
    @NotNull
    private OCPublisher publisher;
    /**
     * The jurisdiction covered by the gazette
     * 
     */
    @JsonProperty("jurisdiction_code")
    @JsonPropertyDescription("The jurisdiction covered by the gazette")
    private String jurisdictionCode;
    /**
     * The title of the gazette
     * 
     */
    @JsonProperty("title")
    @JsonPropertyDescription("The title of the gazette")
    private String title;
    /**
     * The URL of the gazette
     * 
     */
    @JsonProperty("url")
    @JsonPropertyDescription("The URL of the gazette")
    private URI url;
    /**
     * The media type of the URL resource
     * 
     */
    @JsonProperty("media_type")
    @JsonPropertyDescription("The media type of the URL resource")
    private String mediaType;

    /**
     * Publisher
     * <p>
     * A gazette publisher
     * (Required)
     * 
     */
    @JsonProperty("publisher")
    public OCPublisher getPublisher() {
        return publisher;
    }

    /**
     * Publisher
     * <p>
     * A gazette publisher
     * (Required)
     * 
     */
    @JsonProperty("publisher")
    public void setPublisher(OCPublisher publisher) {
        this.publisher = publisher;
    }

    /**
     * The jurisdiction covered by the gazette
     * 
     */
    @JsonProperty("jurisdiction_code")
    public String getJurisdictionCode() {
        return jurisdictionCode;
    }

    /**
     * The jurisdiction covered by the gazette
     * 
     */
    @JsonProperty("jurisdiction_code")
    public void setJurisdictionCode(String jurisdictionCode) {
        this.jurisdictionCode = jurisdictionCode;
    }

    /**
     * The title of the gazette
     * 
     */
    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    /**
     * The title of the gazette
     * 
     */
    @JsonProperty("title")
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * The URL of the gazette
     * 
     */
    @JsonProperty("url")
    public URI getUrl() {
        return url;
    }

    /**
     * The URL of the gazette
     * 
     */
    @JsonProperty("url")
    public void setUrl(URI url) {
        this.url = url;
    }

    /**
     * The media type of the URL resource
     * 
     */
    @JsonProperty("media_type")
    public String getMediaType() {
        return mediaType;
    }

    /**
     * The media type of the URL resource
     * 
     */
    @JsonProperty("media_type")
    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCPublication.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("publisher");
        sb.append('=');
        sb.append(((this.publisher == null)?"<null>":this.publisher));
        sb.append(',');
        sb.append("jurisdictionCode");
        sb.append('=');
        sb.append(((this.jurisdictionCode == null)?"<null>":this.jurisdictionCode));
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(((this.title == null)?"<null>":this.title));
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(((this.url == null)?"<null>":this.url));
        sb.append(',');
        sb.append("mediaType");
        sb.append('=');
        sb.append(((this.mediaType == null)?"<null>":this.mediaType));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.publisher == null)? 0 :this.publisher.hashCode()));
        result = ((result* 31)+((this.jurisdictionCode == null)? 0 :this.jurisdictionCode.hashCode()));
        result = ((result* 31)+((this.mediaType == null)? 0 :this.mediaType.hashCode()));
        result = ((result* 31)+((this.title == null)? 0 :this.title.hashCode()));
        result = ((result* 31)+((this.url == null)? 0 :this.url.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCPublication) == false) {
            return false;
        }
        OCPublication rhs = ((OCPublication) other);
        return ((((((this.publisher == rhs.publisher)||((this.publisher!= null)&&this.publisher.equals(rhs.publisher)))&&((this.jurisdictionCode == rhs.jurisdictionCode)||((this.jurisdictionCode!= null)&&this.jurisdictionCode.equals(rhs.jurisdictionCode))))&&((this.mediaType == rhs.mediaType)||((this.mediaType!= null)&&this.mediaType.equals(rhs.mediaType))))&&((this.title == rhs.title)||((this.title!= null)&&this.title.equals(rhs.title))))&&((this.url == rhs.url)||((this.url!= null)&&this.url.equals(rhs.url))));
    }

}
