
package com.opencorporates.schemas;

import java.net.URI;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.opencorporates.schemas.includes.OCOrganisation;


/**
 * Register
 * <p>
 * The official register of which this entry is a part
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "registrar",
    "jurisdiction",
    "title",
    "url"
})
public class OCRegister {

    /**
     * An entity which is a distinct organisation, but is not a company nor an individual. Examples include governments and governmental entities (e.g. Multilateral Development Banks, Government Departments, municipalities, etc), and also membership organisations
     * 
     */
    @JsonProperty("registrar")
    @JsonPropertyDescription("An entity which is a distinct organisation, but is not a company nor an individual. Examples include governments and governmental entities (e.g. Multilateral Development Banks, Government Departments, municipalities, etc), and also membership organisations")
    @Valid
    private OCOrganisation registrar;
    /**
     * The jurisdiction covered by the register
     * 
     */
    @JsonProperty("jurisdiction")
    @JsonPropertyDescription("The jurisdiction covered by the register")
    private String jurisdiction;
    /**
     * The title of the register
     * (Required)
     * 
     */
    @JsonProperty("title")
    @JsonPropertyDescription("The title of the register")
    @NotNull
    private String title;
    /**
     * The URL of the register
     * 
     */
    @JsonProperty("url")
    @JsonPropertyDescription("The URL of the register")
    private URI url;

    /**
     * An entity which is a distinct organisation, but is not a company nor an individual. Examples include governments and governmental entities (e.g. Multilateral Development Banks, Government Departments, municipalities, etc), and also membership organisations
     * 
     */
    @JsonProperty("registrar")
    public OCOrganisation getRegistrar() {
        return registrar;
    }

    /**
     * An entity which is a distinct organisation, but is not a company nor an individual. Examples include governments and governmental entities (e.g. Multilateral Development Banks, Government Departments, municipalities, etc), and also membership organisations
     * 
     */
    @JsonProperty("registrar")
    public void setRegistrar(OCOrganisation registrar) {
        this.registrar = registrar;
    }

    /**
     * The jurisdiction covered by the register
     * 
     */
    @JsonProperty("jurisdiction")
    public String getJurisdiction() {
        return jurisdiction;
    }

    /**
     * The jurisdiction covered by the register
     * 
     */
    @JsonProperty("jurisdiction")
    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    /**
     * The title of the register
     * (Required)
     * 
     */
    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    /**
     * The title of the register
     * (Required)
     * 
     */
    @JsonProperty("title")
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * The URL of the register
     * 
     */
    @JsonProperty("url")
    public URI getUrl() {
        return url;
    }

    /**
     * The URL of the register
     * 
     */
    @JsonProperty("url")
    public void setUrl(URI url) {
        this.url = url;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCRegister.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("registrar");
        sb.append('=');
        sb.append(((this.registrar == null)?"<null>":this.registrar));
        sb.append(',');
        sb.append("jurisdiction");
        sb.append('=');
        sb.append(((this.jurisdiction == null)?"<null>":this.jurisdiction));
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(((this.title == null)?"<null>":this.title));
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(((this.url == null)?"<null>":this.url));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.registrar == null)? 0 :this.registrar.hashCode()));
        result = ((result* 31)+((this.title == null)? 0 :this.title.hashCode()));
        result = ((result* 31)+((this.url == null)? 0 :this.url.hashCode()));
        result = ((result* 31)+((this.jurisdiction == null)? 0 :this.jurisdiction.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCRegister) == false) {
            return false;
        }
        OCRegister rhs = ((OCRegister) other);
        return (((((this.registrar == rhs.registrar)||((this.registrar!= null)&&this.registrar.equals(rhs.registrar)))&&((this.title == rhs.title)||((this.title!= null)&&this.title.equals(rhs.title))))&&((this.url == rhs.url)||((this.url!= null)&&this.url.equals(rhs.url))))&&((this.jurisdiction == rhs.jurisdiction)||((this.jurisdiction!= null)&&this.jurisdiction.equals(rhs.jurisdiction))));
    }

}
