
package com.opencorporates.schemas;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * A parcel of shares in a company
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "number_of_shares",
    "percentage_of_shares",
    "percentage_of_shares_min",
    "percentage_of_shares_max",
    "voting_percentage",
    "voting_percentage_min",
    "voting_percentage_max",
    "share_class",
    "start_date",
    "end_date",
    "sample_date",
    "shareholders"
})
public class OCShareParcel {

    /**
     * Number of shares, if known
     * 
     */
    @JsonProperty("number_of_shares")
    @JsonPropertyDescription("Number of shares, if known")
    private Integer numberOfShares;
    /**
     * Percentage of shares, if known
     * 
     */
    @JsonProperty("percentage_of_shares")
    @JsonPropertyDescription("Percentage of shares, if known")
    private Double percentageOfShares;
    /**
     * Minimum percentage of shares (if for example a band of percentage is given)
     * 
     */
    @JsonProperty("percentage_of_shares_min")
    @JsonPropertyDescription("Minimum percentage of shares (if for example a band of percentage is given)")
    private Double percentageOfSharesMin;
    /**
     * Maximum percentage of shares (if for example a band of percentage is given)
     * 
     */
    @JsonProperty("percentage_of_shares_max")
    @JsonPropertyDescription("Maximum percentage of shares (if for example a band of percentage is given)")
    private Double percentageOfSharesMax;
    /**
     * Percentage of votes, if known
     * 
     */
    @JsonProperty("voting_percentage")
    @JsonPropertyDescription("Percentage of votes, if known")
    private Double votingPercentage;
    /**
     * Minimum percentage of votes (if for example a band of votes is given)
     * 
     */
    @JsonProperty("voting_percentage_min")
    @JsonPropertyDescription("Minimum percentage of votes (if for example a band of votes is given)")
    private Double votingPercentageMin;
    /**
     * Maximum percentage of votes (if for example a band of votes is given)
     * 
     */
    @JsonProperty("voting_percentage_max")
    @JsonPropertyDescription("Maximum percentage of votes (if for example a band of votes is given)")
    private Double votingPercentageMax;
    /**
     * Share class or classes, if known
     * 
     */
    @JsonProperty("share_class")
    @JsonPropertyDescription("Share class or classes, if known")
    private String shareClass;
    @JsonProperty("start_date")
    private LocalDate startDate;
    @JsonProperty("end_date")
    private LocalDate endDate;
    @JsonProperty("sample_date")
    private LocalDate sampleDate;
    /**
     * Legal persons who own this share parcel
     * 
     */
    @JsonProperty("shareholders")
    @JsonPropertyDescription("Legal persons who own this share parcel")
    @Size(min = 1)
    @Valid
    private List<OCShareholder> shareholders = new ArrayList<OCShareholder>();
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * Number of shares, if known
     * 
     */
    @JsonProperty("number_of_shares")
    public Integer getNumberOfShares() {
        return numberOfShares;
    }

    /**
     * Number of shares, if known
     * 
     */
    @JsonProperty("number_of_shares")
    public void setNumberOfShares(Integer numberOfShares) {
        this.numberOfShares = numberOfShares;
    }

    /**
     * Percentage of shares, if known
     * 
     */
    @JsonProperty("percentage_of_shares")
    public Double getPercentageOfShares() {
        return percentageOfShares;
    }

    /**
     * Percentage of shares, if known
     * 
     */
    @JsonProperty("percentage_of_shares")
    public void setPercentageOfShares(Double percentageOfShares) {
        this.percentageOfShares = percentageOfShares;
    }

    /**
     * Minimum percentage of shares (if for example a band of percentage is given)
     * 
     */
    @JsonProperty("percentage_of_shares_min")
    public Double getPercentageOfSharesMin() {
        return percentageOfSharesMin;
    }

    /**
     * Minimum percentage of shares (if for example a band of percentage is given)
     * 
     */
    @JsonProperty("percentage_of_shares_min")
    public void setPercentageOfSharesMin(Double percentageOfSharesMin) {
        this.percentageOfSharesMin = percentageOfSharesMin;
    }

    /**
     * Maximum percentage of shares (if for example a band of percentage is given)
     * 
     */
    @JsonProperty("percentage_of_shares_max")
    public Double getPercentageOfSharesMax() {
        return percentageOfSharesMax;
    }

    /**
     * Maximum percentage of shares (if for example a band of percentage is given)
     * 
     */
    @JsonProperty("percentage_of_shares_max")
    public void setPercentageOfSharesMax(Double percentageOfSharesMax) {
        this.percentageOfSharesMax = percentageOfSharesMax;
    }

    /**
     * Percentage of votes, if known
     * 
     */
    @JsonProperty("voting_percentage")
    public Double getVotingPercentage() {
        return votingPercentage;
    }

    /**
     * Percentage of votes, if known
     * 
     */
    @JsonProperty("voting_percentage")
    public void setVotingPercentage(Double votingPercentage) {
        this.votingPercentage = votingPercentage;
    }

    /**
     * Minimum percentage of votes (if for example a band of votes is given)
     * 
     */
    @JsonProperty("voting_percentage_min")
    public Double getVotingPercentageMin() {
        return votingPercentageMin;
    }

    /**
     * Minimum percentage of votes (if for example a band of votes is given)
     * 
     */
    @JsonProperty("voting_percentage_min")
    public void setVotingPercentageMin(Double votingPercentageMin) {
        this.votingPercentageMin = votingPercentageMin;
    }

    /**
     * Maximum percentage of votes (if for example a band of votes is given)
     * 
     */
    @JsonProperty("voting_percentage_max")
    public Double getVotingPercentageMax() {
        return votingPercentageMax;
    }

    /**
     * Maximum percentage of votes (if for example a band of votes is given)
     * 
     */
    @JsonProperty("voting_percentage_max")
    public void setVotingPercentageMax(Double votingPercentageMax) {
        this.votingPercentageMax = votingPercentageMax;
    }

    /**
     * Share class or classes, if known
     * 
     */
    @JsonProperty("share_class")
    public String getShareClass() {
        return shareClass;
    }

    /**
     * Share class or classes, if known
     * 
     */
    @JsonProperty("share_class")
    public void setShareClass(String shareClass) {
        this.shareClass = shareClass;
    }

    @JsonProperty("start_date")
    public LocalDate getStartDate() {
        return startDate;
    }

    @JsonProperty("start_date")
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    @JsonProperty("end_date")
    public LocalDate getEndDate() {
        return endDate;
    }

    @JsonProperty("end_date")
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    @JsonProperty("sample_date")
    public LocalDate getSampleDate() {
        return sampleDate;
    }

    @JsonProperty("sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    /**
     * Legal persons who own this share parcel
     * 
     */
    @JsonProperty("shareholders")
    public List<OCShareholder> getShareholders() {
        return shareholders;
    }

    /**
     * Legal persons who own this share parcel
     * 
     */
    @JsonProperty("shareholders")
    public void setShareholders(List<OCShareholder> shareholders) {
        this.shareholders = shareholders;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCShareParcel.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("numberOfShares");
        sb.append('=');
        sb.append(((this.numberOfShares == null)?"<null>":this.numberOfShares));
        sb.append(',');
        sb.append("percentageOfShares");
        sb.append('=');
        sb.append(((this.percentageOfShares == null)?"<null>":this.percentageOfShares));
        sb.append(',');
        sb.append("percentageOfSharesMin");
        sb.append('=');
        sb.append(((this.percentageOfSharesMin == null)?"<null>":this.percentageOfSharesMin));
        sb.append(',');
        sb.append("percentageOfSharesMax");
        sb.append('=');
        sb.append(((this.percentageOfSharesMax == null)?"<null>":this.percentageOfSharesMax));
        sb.append(',');
        sb.append("votingPercentage");
        sb.append('=');
        sb.append(((this.votingPercentage == null)?"<null>":this.votingPercentage));
        sb.append(',');
        sb.append("votingPercentageMin");
        sb.append('=');
        sb.append(((this.votingPercentageMin == null)?"<null>":this.votingPercentageMin));
        sb.append(',');
        sb.append("votingPercentageMax");
        sb.append('=');
        sb.append(((this.votingPercentageMax == null)?"<null>":this.votingPercentageMax));
        sb.append(',');
        sb.append("shareClass");
        sb.append('=');
        sb.append(((this.shareClass == null)?"<null>":this.shareClass));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(((this.sampleDate == null)?"<null>":this.sampleDate));
        sb.append(',');
        sb.append("shareholders");
        sb.append('=');
        sb.append(((this.shareholders == null)?"<null>":this.shareholders));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.percentageOfSharesMin == null)? 0 :this.percentageOfSharesMin.hashCode()));
        result = ((result* 31)+((this.votingPercentageMin == null)? 0 :this.votingPercentageMin.hashCode()));
        result = ((result* 31)+((this.shareholders == null)? 0 :this.shareholders.hashCode()));
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.shareClass == null)? 0 :this.shareClass.hashCode()));
        result = ((result* 31)+((this.numberOfShares == null)? 0 :this.numberOfShares.hashCode()));
        result = ((result* 31)+((this.percentageOfShares == null)? 0 :this.percentageOfShares.hashCode()));
        result = ((result* 31)+((this.percentageOfSharesMax == null)? 0 :this.percentageOfSharesMax.hashCode()));
        result = ((result* 31)+((this.votingPercentage == null)? 0 :this.votingPercentage.hashCode()));
        result = ((result* 31)+((this.votingPercentageMax == null)? 0 :this.votingPercentageMax.hashCode()));
        result = ((result* 31)+((this.sampleDate == null)? 0 :this.sampleDate.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCShareParcel) == false) {
            return false;
        }
        OCShareParcel rhs = ((OCShareParcel) other);
        return ((((((((((((((this.percentageOfSharesMin == rhs.percentageOfSharesMin)||((this.percentageOfSharesMin!= null)&&this.percentageOfSharesMin.equals(rhs.percentageOfSharesMin)))&&((this.votingPercentageMin == rhs.votingPercentageMin)||((this.votingPercentageMin!= null)&&this.votingPercentageMin.equals(rhs.votingPercentageMin))))&&((this.shareholders == rhs.shareholders)||((this.shareholders!= null)&&this.shareholders.equals(rhs.shareholders))))&&((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate))))&&((this.shareClass == rhs.shareClass)||((this.shareClass!= null)&&this.shareClass.equals(rhs.shareClass))))&&((this.numberOfShares == rhs.numberOfShares)||((this.numberOfShares!= null)&&this.numberOfShares.equals(rhs.numberOfShares))))&&((this.percentageOfShares == rhs.percentageOfShares)||((this.percentageOfShares!= null)&&this.percentageOfShares.equals(rhs.percentageOfShares))))&&((this.percentageOfSharesMax == rhs.percentageOfSharesMax)||((this.percentageOfSharesMax!= null)&&this.percentageOfSharesMax.equals(rhs.percentageOfSharesMax))))&&((this.votingPercentage == rhs.votingPercentage)||((this.votingPercentage!= null)&&this.votingPercentage.equals(rhs.votingPercentage))))&&((this.votingPercentageMax == rhs.votingPercentageMax)||((this.votingPercentageMax!= null)&&this.votingPercentageMax.equals(rhs.votingPercentageMax))))&&((this.sampleDate == rhs.sampleDate)||((this.sampleDate!= null)&&this.sampleDate.equals(rhs.sampleDate))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))));
    }

}
