
package com.opencorporates.schemas;

import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "jurisdiction",
    "company_number",
    "identifier",
    "type",
    "address",
    "address_country"
})
public class OCShareholder {

    /**
     * Name of natural person or company
     * (Required)
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Name of natural person or company")
    @Size(min = 1)
    @NotNull
    private String name;
    /**
     * Jurisdiction of registration, if company
     * 
     */
    @JsonProperty("jurisdiction")
    @JsonPropertyDescription("Jurisdiction of registration, if company")
    private String jurisdiction;
    /**
     * Company number, if company and known
     * 
     */
    @JsonProperty("company_number")
    @JsonPropertyDescription("Company number, if company and known")
    private String companyNumber;
    /**
     * Unique identifier of person
     * 
     */
    @JsonProperty("identifier")
    @JsonPropertyDescription("Unique identifier of person")
    private String identifier;
    /**
     * Type of person if known (company or natural person)
     * 
     */
    @JsonProperty("type")
    @JsonPropertyDescription("Type of person if known (company or natural person)")
    private OCShareholder.Type type;
    @JsonProperty("address")
    private Object address;
    /**
     * Country part of owner's address (for example if address not given)
     * 
     */
    @JsonProperty("address_country")
    @JsonPropertyDescription("Country part of owner's address (for example if address not given)")
    private String addressCountry;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * Name of natural person or company
     * (Required)
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * Name of natural person or company
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Jurisdiction of registration, if company
     * 
     */
    @JsonProperty("jurisdiction")
    public String getJurisdiction() {
        return jurisdiction;
    }

    /**
     * Jurisdiction of registration, if company
     * 
     */
    @JsonProperty("jurisdiction")
    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    /**
     * Company number, if company and known
     * 
     */
    @JsonProperty("company_number")
    public String getCompanyNumber() {
        return companyNumber;
    }

    /**
     * Company number, if company and known
     * 
     */
    @JsonProperty("company_number")
    public void setCompanyNumber(String companyNumber) {
        this.companyNumber = companyNumber;
    }

    /**
     * Unique identifier of person
     * 
     */
    @JsonProperty("identifier")
    public String getIdentifier() {
        return identifier;
    }

    /**
     * Unique identifier of person
     * 
     */
    @JsonProperty("identifier")
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    /**
     * Type of person if known (company or natural person)
     * 
     */
    @JsonProperty("type")
    public OCShareholder.Type getType() {
        return type;
    }

    /**
     * Type of person if known (company or natural person)
     * 
     */
    @JsonProperty("type")
    public void setType(OCShareholder.Type type) {
        this.type = type;
    }

    @JsonProperty("address")
    public Object getAddress() {
        return address;
    }

    @JsonProperty("address")
    public void setAddress(Object address) {
        this.address = address;
    }

    /**
     * Country part of owner's address (for example if address not given)
     * 
     */
    @JsonProperty("address_country")
    public String getAddressCountry() {
        return addressCountry;
    }

    /**
     * Country part of owner's address (for example if address not given)
     * 
     */
    @JsonProperty("address_country")
    public void setAddressCountry(String addressCountry) {
        this.addressCountry = addressCountry;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCShareholder.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("jurisdiction");
        sb.append('=');
        sb.append(((this.jurisdiction == null)?"<null>":this.jurisdiction));
        sb.append(',');
        sb.append("companyNumber");
        sb.append('=');
        sb.append(((this.companyNumber == null)?"<null>":this.companyNumber));
        sb.append(',');
        sb.append("identifier");
        sb.append('=');
        sb.append(((this.identifier == null)?"<null>":this.identifier));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("address");
        sb.append('=');
        sb.append(((this.address == null)?"<null>":this.address));
        sb.append(',');
        sb.append("addressCountry");
        sb.append('=');
        sb.append(((this.addressCountry == null)?"<null>":this.addressCountry));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.addressCountry == null)? 0 :this.addressCountry.hashCode()));
        result = ((result* 31)+((this.identifier == null)? 0 :this.identifier.hashCode()));
        result = ((result* 31)+((this.address == null)? 0 :this.address.hashCode()));
        result = ((result* 31)+((this.companyNumber == null)? 0 :this.companyNumber.hashCode()));
        result = ((result* 31)+((this.jurisdiction == null)? 0 :this.jurisdiction.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCShareholder) == false) {
            return false;
        }
        OCShareholder rhs = ((OCShareholder) other);
        return (((((((((this.addressCountry == rhs.addressCountry)||((this.addressCountry!= null)&&this.addressCountry.equals(rhs.addressCountry)))&&((this.identifier == rhs.identifier)||((this.identifier!= null)&&this.identifier.equals(rhs.identifier))))&&((this.address == rhs.address)||((this.address!= null)&&this.address.equals(rhs.address))))&&((this.companyNumber == rhs.companyNumber)||((this.companyNumber!= null)&&this.companyNumber.equals(rhs.companyNumber))))&&((this.jurisdiction == rhs.jurisdiction)||((this.jurisdiction!= null)&&this.jurisdiction.equals(rhs.jurisdiction))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))));
    }


    /**
     * Type of person if known (company or natural person)
     * 
     */
    public enum Type {

        COMPANY("Company"),
        PERSON("Person");
        private final String value;
        private final static Map<String, OCShareholder.Type> CONSTANTS = new HashMap<String, OCShareholder.Type>();

        static {
            for (OCShareholder.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Type(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCShareholder.Type fromValue(String value) {
            OCShareholder.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
