
package com.opencorporates.schemas;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "source_url",
    "sample_date",
    "start_date",
    "end_date",
    "confidence",
    "retrieved_at",
    "parent_name",
    "parent_jurisdiction",
    "parent_identifier",
    "direct",
    "percentage_controlled",
    "subsidiary_name",
    "subsidiary_jurisdiction",
    "subsidiary_identifier"
})
public class OCSimpleSubsidiarySchema {

    /**
     * Place where this fact can be verified
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    @JsonPropertyDescription("Place where this fact can be verified")
    @Size(min = 1)
    @NotNull
    private String sourceUrl;
    /**
     * Date on which this fact was known to be true
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    @JsonPropertyDescription("Date on which this fact was known to be true")
    @NotNull
    private LocalDate sampleDate;
    /**
     * Earliest known date this was known to be a subsidiary
     * 
     */
    @JsonProperty("start_date")
    @JsonPropertyDescription("Earliest known date this was known to be a subsidiary")
    private LocalDate startDate;
    /**
     * Latest known date this was known to be a subsidiary
     * 
     */
    @JsonProperty("end_date")
    @JsonPropertyDescription("Latest known date this was known to be a subsidiary")
    private LocalDate endDate;
    /**
     * Confidence in accuracy of data
     * 
     */
    @JsonProperty("confidence")
    @JsonPropertyDescription("Confidence in accuracy of data")
    private OCSimpleSubsidiarySchema.Confidence confidence;
    @JsonProperty("retrieved_at")
    private LocalDate retrievedAt;
    /**
     * Name of the controlling company
     * (Required)
     * 
     */
    @JsonProperty("parent_name")
    @JsonPropertyDescription("Name of the controlling company")
    @Size(min = 1)
    @NotNull
    private String parentName;
    /**
     * Jurisdiction where controlling company is based
     * (Required)
     * 
     */
    @JsonProperty("parent_jurisdiction")
    @JsonPropertyDescription("Jurisdiction where controlling company is based")
    @Size(min = 1)
    @NotNull
    private String parentJurisdiction;
    /**
     * Any unique ID for the controlling company
     * 
     */
    @JsonProperty("parent_identifier")
    @JsonPropertyDescription("Any unique ID for the controlling company")
    private String parentIdentifier;
    /**
     * Is the control relationship direct or indirect (if unknown, leave blank)?
     * 
     */
    @JsonProperty("direct")
    @JsonPropertyDescription("Is the control relationship direct or indirect (if unknown, leave blank)?")
    private Boolean direct;
    /**
     * Percentage of the subsidiary that is controlled (if known), either directly or indirectly
     * 
     */
    @JsonProperty("percentage_controlled")
    @JsonPropertyDescription("Percentage of the subsidiary that is controlled (if known), either directly or indirectly")
    @Pattern(regexp = "^[0-9]{1,2}0?[.]?[0-9]{0,2}$")
    private String percentageControlled;
    /**
     * The name of the subsidiary
     * (Required)
     * 
     */
    @JsonProperty("subsidiary_name")
    @JsonPropertyDescription("The name of the subsidiary")
    @Size(min = 1)
    @NotNull
    private String subsidiaryName;
    /**
     * Jurisdiction of the subsidiary
     * (Required)
     * 
     */
    @JsonProperty("subsidiary_jurisdiction")
    @JsonPropertyDescription("Jurisdiction of the subsidiary")
    @Size(min = 1)
    @NotNull
    private String subsidiaryJurisdiction;
    /**
     * Any unique id for the subsidiary that might be provided in the source
     * 
     */
    @JsonProperty("subsidiary_identifier")
    @JsonPropertyDescription("Any unique id for the subsidiary that might be provided in the source")
    private String subsidiaryIdentifier;

    /**
     * Place where this fact can be verified
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    public String getSourceUrl() {
        return sourceUrl;
    }

    /**
     * Place where this fact can be verified
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    /**
     * Date on which this fact was known to be true
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    public LocalDate getSampleDate() {
        return sampleDate;
    }

    /**
     * Date on which this fact was known to be true
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    /**
     * Earliest known date this was known to be a subsidiary
     * 
     */
    @JsonProperty("start_date")
    public LocalDate getStartDate() {
        return startDate;
    }

    /**
     * Earliest known date this was known to be a subsidiary
     * 
     */
    @JsonProperty("start_date")
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    /**
     * Latest known date this was known to be a subsidiary
     * 
     */
    @JsonProperty("end_date")
    public LocalDate getEndDate() {
        return endDate;
    }

    /**
     * Latest known date this was known to be a subsidiary
     * 
     */
    @JsonProperty("end_date")
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    /**
     * Confidence in accuracy of data
     * 
     */
    @JsonProperty("confidence")
    public OCSimpleSubsidiarySchema.Confidence getConfidence() {
        return confidence;
    }

    /**
     * Confidence in accuracy of data
     * 
     */
    @JsonProperty("confidence")
    public void setConfidence(OCSimpleSubsidiarySchema.Confidence confidence) {
        this.confidence = confidence;
    }

    @JsonProperty("retrieved_at")
    public LocalDate getRetrievedAt() {
        return retrievedAt;
    }

    @JsonProperty("retrieved_at")
    public void setRetrievedAt(LocalDate retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    /**
     * Name of the controlling company
     * (Required)
     * 
     */
    @JsonProperty("parent_name")
    public String getParentName() {
        return parentName;
    }

    /**
     * Name of the controlling company
     * (Required)
     * 
     */
    @JsonProperty("parent_name")
    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    /**
     * Jurisdiction where controlling company is based
     * (Required)
     * 
     */
    @JsonProperty("parent_jurisdiction")
    public String getParentJurisdiction() {
        return parentJurisdiction;
    }

    /**
     * Jurisdiction where controlling company is based
     * (Required)
     * 
     */
    @JsonProperty("parent_jurisdiction")
    public void setParentJurisdiction(String parentJurisdiction) {
        this.parentJurisdiction = parentJurisdiction;
    }

    /**
     * Any unique ID for the controlling company
     * 
     */
    @JsonProperty("parent_identifier")
    public String getParentIdentifier() {
        return parentIdentifier;
    }

    /**
     * Any unique ID for the controlling company
     * 
     */
    @JsonProperty("parent_identifier")
    public void setParentIdentifier(String parentIdentifier) {
        this.parentIdentifier = parentIdentifier;
    }

    /**
     * Is the control relationship direct or indirect (if unknown, leave blank)?
     * 
     */
    @JsonProperty("direct")
    public Boolean getDirect() {
        return direct;
    }

    /**
     * Is the control relationship direct or indirect (if unknown, leave blank)?
     * 
     */
    @JsonProperty("direct")
    public void setDirect(Boolean direct) {
        this.direct = direct;
    }

    /**
     * Percentage of the subsidiary that is controlled (if known), either directly or indirectly
     * 
     */
    @JsonProperty("percentage_controlled")
    public String getPercentageControlled() {
        return percentageControlled;
    }

    /**
     * Percentage of the subsidiary that is controlled (if known), either directly or indirectly
     * 
     */
    @JsonProperty("percentage_controlled")
    public void setPercentageControlled(String percentageControlled) {
        this.percentageControlled = percentageControlled;
    }

    /**
     * The name of the subsidiary
     * (Required)
     * 
     */
    @JsonProperty("subsidiary_name")
    public String getSubsidiaryName() {
        return subsidiaryName;
    }

    /**
     * The name of the subsidiary
     * (Required)
     * 
     */
    @JsonProperty("subsidiary_name")
    public void setSubsidiaryName(String subsidiaryName) {
        this.subsidiaryName = subsidiaryName;
    }

    /**
     * Jurisdiction of the subsidiary
     * (Required)
     * 
     */
    @JsonProperty("subsidiary_jurisdiction")
    public String getSubsidiaryJurisdiction() {
        return subsidiaryJurisdiction;
    }

    /**
     * Jurisdiction of the subsidiary
     * (Required)
     * 
     */
    @JsonProperty("subsidiary_jurisdiction")
    public void setSubsidiaryJurisdiction(String subsidiaryJurisdiction) {
        this.subsidiaryJurisdiction = subsidiaryJurisdiction;
    }

    /**
     * Any unique id for the subsidiary that might be provided in the source
     * 
     */
    @JsonProperty("subsidiary_identifier")
    public String getSubsidiaryIdentifier() {
        return subsidiaryIdentifier;
    }

    /**
     * Any unique id for the subsidiary that might be provided in the source
     * 
     */
    @JsonProperty("subsidiary_identifier")
    public void setSubsidiaryIdentifier(String subsidiaryIdentifier) {
        this.subsidiaryIdentifier = subsidiaryIdentifier;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCSimpleSubsidiarySchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(((this.sourceUrl == null)?"<null>":this.sourceUrl));
        sb.append(',');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(((this.sampleDate == null)?"<null>":this.sampleDate));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("confidence");
        sb.append('=');
        sb.append(((this.confidence == null)?"<null>":this.confidence));
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(((this.retrievedAt == null)?"<null>":this.retrievedAt));
        sb.append(',');
        sb.append("parentName");
        sb.append('=');
        sb.append(((this.parentName == null)?"<null>":this.parentName));
        sb.append(',');
        sb.append("parentJurisdiction");
        sb.append('=');
        sb.append(((this.parentJurisdiction == null)?"<null>":this.parentJurisdiction));
        sb.append(',');
        sb.append("parentIdentifier");
        sb.append('=');
        sb.append(((this.parentIdentifier == null)?"<null>":this.parentIdentifier));
        sb.append(',');
        sb.append("direct");
        sb.append('=');
        sb.append(((this.direct == null)?"<null>":this.direct));
        sb.append(',');
        sb.append("percentageControlled");
        sb.append('=');
        sb.append(((this.percentageControlled == null)?"<null>":this.percentageControlled));
        sb.append(',');
        sb.append("subsidiaryName");
        sb.append('=');
        sb.append(((this.subsidiaryName == null)?"<null>":this.subsidiaryName));
        sb.append(',');
        sb.append("subsidiaryJurisdiction");
        sb.append('=');
        sb.append(((this.subsidiaryJurisdiction == null)?"<null>":this.subsidiaryJurisdiction));
        sb.append(',');
        sb.append("subsidiaryIdentifier");
        sb.append('=');
        sb.append(((this.subsidiaryIdentifier == null)?"<null>":this.subsidiaryIdentifier));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.percentageControlled == null)? 0 :this.percentageControlled.hashCode()));
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.confidence == null)? 0 :this.confidence.hashCode()));
        result = ((result* 31)+((this.direct == null)? 0 :this.direct.hashCode()));
        result = ((result* 31)+((this.parentIdentifier == null)? 0 :this.parentIdentifier.hashCode()));
        result = ((result* 31)+((this.subsidiaryJurisdiction == null)? 0 :this.subsidiaryJurisdiction.hashCode()));
        result = ((result* 31)+((this.sourceUrl == null)? 0 :this.sourceUrl.hashCode()));
        result = ((result* 31)+((this.parentName == null)? 0 :this.parentName.hashCode()));
        result = ((result* 31)+((this.subsidiaryName == null)? 0 :this.subsidiaryName.hashCode()));
        result = ((result* 31)+((this.retrievedAt == null)? 0 :this.retrievedAt.hashCode()));
        result = ((result* 31)+((this.sampleDate == null)? 0 :this.sampleDate.hashCode()));
        result = ((result* 31)+((this.parentJurisdiction == null)? 0 :this.parentJurisdiction.hashCode()));
        result = ((result* 31)+((this.subsidiaryIdentifier == null)? 0 :this.subsidiaryIdentifier.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCSimpleSubsidiarySchema) == false) {
            return false;
        }
        OCSimpleSubsidiarySchema rhs = ((OCSimpleSubsidiarySchema) other);
        return (((((((((((((((this.percentageControlled == rhs.percentageControlled)||((this.percentageControlled!= null)&&this.percentageControlled.equals(rhs.percentageControlled)))&&((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate))))&&((this.confidence == rhs.confidence)||((this.confidence!= null)&&this.confidence.equals(rhs.confidence))))&&((this.direct == rhs.direct)||((this.direct!= null)&&this.direct.equals(rhs.direct))))&&((this.parentIdentifier == rhs.parentIdentifier)||((this.parentIdentifier!= null)&&this.parentIdentifier.equals(rhs.parentIdentifier))))&&((this.subsidiaryJurisdiction == rhs.subsidiaryJurisdiction)||((this.subsidiaryJurisdiction!= null)&&this.subsidiaryJurisdiction.equals(rhs.subsidiaryJurisdiction))))&&((this.sourceUrl == rhs.sourceUrl)||((this.sourceUrl!= null)&&this.sourceUrl.equals(rhs.sourceUrl))))&&((this.parentName == rhs.parentName)||((this.parentName!= null)&&this.parentName.equals(rhs.parentName))))&&((this.subsidiaryName == rhs.subsidiaryName)||((this.subsidiaryName!= null)&&this.subsidiaryName.equals(rhs.subsidiaryName))))&&((this.retrievedAt == rhs.retrievedAt)||((this.retrievedAt!= null)&&this.retrievedAt.equals(rhs.retrievedAt))))&&((this.sampleDate == rhs.sampleDate)||((this.sampleDate!= null)&&this.sampleDate.equals(rhs.sampleDate))))&&((this.parentJurisdiction == rhs.parentJurisdiction)||((this.parentJurisdiction!= null)&&this.parentJurisdiction.equals(rhs.parentJurisdiction))))&&((this.subsidiaryIdentifier == rhs.subsidiaryIdentifier)||((this.subsidiaryIdentifier!= null)&&this.subsidiaryIdentifier.equals(rhs.subsidiaryIdentifier))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))));
    }


    /**
     * Confidence in accuracy of data
     * 
     */
    public enum Confidence {

        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");
        private final String value;
        private final static Map<String, OCSimpleSubsidiarySchema.Confidence> CONSTANTS = new HashMap<String, OCSimpleSubsidiarySchema.Confidence>();

        static {
            for (OCSimpleSubsidiarySchema.Confidence c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Confidence(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCSimpleSubsidiarySchema.Confidence fromValue(String value) {
            OCSimpleSubsidiarySchema.Confidence constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
