
package com.opencorporates.schemas;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * A representation of entity registration changing over time
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "data_type",
    "previous_entity",
    "subsequent_entity",
    "subsequent_registration_start_date",
    "previous_registration_end_date",
    "publication_date",
    "start_date",
    "start_date_type",
    "sample_date",
    "retrieved_at",
    "source_url",
    "confidence"
})
public class OCSubsequentRegistrationSchema {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("data_type")
    @NotNull
    private OCSubsequentRegistrationSchema.DataType dataType;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("previous_entity")
    @Valid
    @NotNull
    private OCEntity previousEntity;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("subsequent_entity")
    @Valid
    @NotNull
    private OCEntity subsequentEntity;
    /**
     * date when subsequent registration started
     * 
     */
    @JsonProperty("subsequent_registration_start_date")
    @JsonPropertyDescription("date when subsequent registration started")
    private LocalDate subsequentRegistrationStartDate;
    /**
     * date when previous registration ended
     * 
     */
    @JsonProperty("previous_registration_end_date")
    @JsonPropertyDescription("date when previous registration ended")
    private LocalDate previousRegistrationEndDate;
    /**
     * the publication date of the filing/notice that gives details of the alternate registration
     * 
     */
    @JsonProperty("publication_date")
    @JsonPropertyDescription("the publication date of the filing/notice that gives details of the alternate registration")
    private LocalDate publicationDate;
    /**
     * date when subsequent registration was valid from
     * 
     */
    @JsonProperty("start_date")
    @JsonPropertyDescription("date when subsequent registration was valid from")
    private LocalDate startDate;
    @JsonProperty("start_date_type")
    private OCSubsequentRegistrationSchema.StartDateType startDateType;
    /**
     * date when subsequent registration was sampled
     * 
     */
    @JsonProperty("sample_date")
    @JsonPropertyDescription("date when subsequent registration was sampled")
    private LocalDate sampleDate;
    /**
     * date when subsequent registration was retrieved
     * (Required)
     * 
     */
    @JsonProperty("retrieved_at")
    @JsonPropertyDescription("date when subsequent registration was retrieved")
    @NotNull
    private LocalDate retrievedAt;
    /**
     * URL of the source of the data (e.g. download URL), or if there is not persistent URL the page from which it can be found (e.g. search page)
     * 
     */
    @JsonProperty("source_url")
    @JsonPropertyDescription("URL of the source of the data (e.g. download URL), or if there is not persistent URL the page from which it can be found (e.g. search page)")
    private String sourceUrl;
    /**
     * Confidence in accuracy of data
     * (Required)
     * 
     */
    @JsonProperty("confidence")
    @JsonPropertyDescription("Confidence in accuracy of data")
    @NotNull
    private OCSubsequentRegistrationSchema.Confidence confidence;

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("data_type")
    public OCSubsequentRegistrationSchema.DataType getDataType() {
        return dataType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("data_type")
    public void setDataType(OCSubsequentRegistrationSchema.DataType dataType) {
        this.dataType = dataType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("previous_entity")
    public OCEntity getPreviousEntity() {
        return previousEntity;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("previous_entity")
    public void setPreviousEntity(OCEntity previousEntity) {
        this.previousEntity = previousEntity;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("subsequent_entity")
    public OCEntity getSubsequentEntity() {
        return subsequentEntity;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("subsequent_entity")
    public void setSubsequentEntity(OCEntity subsequentEntity) {
        this.subsequentEntity = subsequentEntity;
    }

    /**
     * date when subsequent registration started
     * 
     */
    @JsonProperty("subsequent_registration_start_date")
    public LocalDate getSubsequentRegistrationStartDate() {
        return subsequentRegistrationStartDate;
    }

    /**
     * date when subsequent registration started
     * 
     */
    @JsonProperty("subsequent_registration_start_date")
    public void setSubsequentRegistrationStartDate(LocalDate subsequentRegistrationStartDate) {
        this.subsequentRegistrationStartDate = subsequentRegistrationStartDate;
    }

    /**
     * date when previous registration ended
     * 
     */
    @JsonProperty("previous_registration_end_date")
    public LocalDate getPreviousRegistrationEndDate() {
        return previousRegistrationEndDate;
    }

    /**
     * date when previous registration ended
     * 
     */
    @JsonProperty("previous_registration_end_date")
    public void setPreviousRegistrationEndDate(LocalDate previousRegistrationEndDate) {
        this.previousRegistrationEndDate = previousRegistrationEndDate;
    }

    /**
     * the publication date of the filing/notice that gives details of the alternate registration
     * 
     */
    @JsonProperty("publication_date")
    public LocalDate getPublicationDate() {
        return publicationDate;
    }

    /**
     * the publication date of the filing/notice that gives details of the alternate registration
     * 
     */
    @JsonProperty("publication_date")
    public void setPublicationDate(LocalDate publicationDate) {
        this.publicationDate = publicationDate;
    }

    /**
     * date when subsequent registration was valid from
     * 
     */
    @JsonProperty("start_date")
    public LocalDate getStartDate() {
        return startDate;
    }

    /**
     * date when subsequent registration was valid from
     * 
     */
    @JsonProperty("start_date")
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    @JsonProperty("start_date_type")
    public OCSubsequentRegistrationSchema.StartDateType getStartDateType() {
        return startDateType;
    }

    @JsonProperty("start_date_type")
    public void setStartDateType(OCSubsequentRegistrationSchema.StartDateType startDateType) {
        this.startDateType = startDateType;
    }

    /**
     * date when subsequent registration was sampled
     * 
     */
    @JsonProperty("sample_date")
    public LocalDate getSampleDate() {
        return sampleDate;
    }

    /**
     * date when subsequent registration was sampled
     * 
     */
    @JsonProperty("sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    /**
     * date when subsequent registration was retrieved
     * (Required)
     * 
     */
    @JsonProperty("retrieved_at")
    public LocalDate getRetrievedAt() {
        return retrievedAt;
    }

    /**
     * date when subsequent registration was retrieved
     * (Required)
     * 
     */
    @JsonProperty("retrieved_at")
    public void setRetrievedAt(LocalDate retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    /**
     * URL of the source of the data (e.g. download URL), or if there is not persistent URL the page from which it can be found (e.g. search page)
     * 
     */
    @JsonProperty("source_url")
    public String getSourceUrl() {
        return sourceUrl;
    }

    /**
     * URL of the source of the data (e.g. download URL), or if there is not persistent URL the page from which it can be found (e.g. search page)
     * 
     */
    @JsonProperty("source_url")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    /**
     * Confidence in accuracy of data
     * (Required)
     * 
     */
    @JsonProperty("confidence")
    public OCSubsequentRegistrationSchema.Confidence getConfidence() {
        return confidence;
    }

    /**
     * Confidence in accuracy of data
     * (Required)
     * 
     */
    @JsonProperty("confidence")
    public void setConfidence(OCSubsequentRegistrationSchema.Confidence confidence) {
        this.confidence = confidence;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCSubsequentRegistrationSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dataType");
        sb.append('=');
        sb.append(((this.dataType == null)?"<null>":this.dataType));
        sb.append(',');
        sb.append("previousEntity");
        sb.append('=');
        sb.append(((this.previousEntity == null)?"<null>":this.previousEntity));
        sb.append(',');
        sb.append("subsequentEntity");
        sb.append('=');
        sb.append(((this.subsequentEntity == null)?"<null>":this.subsequentEntity));
        sb.append(',');
        sb.append("subsequentRegistrationStartDate");
        sb.append('=');
        sb.append(((this.subsequentRegistrationStartDate == null)?"<null>":this.subsequentRegistrationStartDate));
        sb.append(',');
        sb.append("previousRegistrationEndDate");
        sb.append('=');
        sb.append(((this.previousRegistrationEndDate == null)?"<null>":this.previousRegistrationEndDate));
        sb.append(',');
        sb.append("publicationDate");
        sb.append('=');
        sb.append(((this.publicationDate == null)?"<null>":this.publicationDate));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("startDateType");
        sb.append('=');
        sb.append(((this.startDateType == null)?"<null>":this.startDateType));
        sb.append(',');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(((this.sampleDate == null)?"<null>":this.sampleDate));
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(((this.retrievedAt == null)?"<null>":this.retrievedAt));
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(((this.sourceUrl == null)?"<null>":this.sourceUrl));
        sb.append(',');
        sb.append("confidence");
        sb.append('=');
        sb.append(((this.confidence == null)?"<null>":this.confidence));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.startDateType == null)? 0 :this.startDateType.hashCode()));
        result = ((result* 31)+((this.dataType == null)? 0 :this.dataType.hashCode()));
        result = ((result* 31)+((this.confidence == null)? 0 :this.confidence.hashCode()));
        result = ((result* 31)+((this.subsequentRegistrationStartDate == null)? 0 :this.subsequentRegistrationStartDate.hashCode()));
        result = ((result* 31)+((this.sourceUrl == null)? 0 :this.sourceUrl.hashCode()));
        result = ((result* 31)+((this.retrievedAt == null)? 0 :this.retrievedAt.hashCode()));
        result = ((result* 31)+((this.previousRegistrationEndDate == null)? 0 :this.previousRegistrationEndDate.hashCode()));
        result = ((result* 31)+((this.sampleDate == null)? 0 :this.sampleDate.hashCode()));
        result = ((result* 31)+((this.subsequentEntity == null)? 0 :this.subsequentEntity.hashCode()));
        result = ((result* 31)+((this.previousEntity == null)? 0 :this.previousEntity.hashCode()));
        result = ((result* 31)+((this.publicationDate == null)? 0 :this.publicationDate.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCSubsequentRegistrationSchema) == false) {
            return false;
        }
        OCSubsequentRegistrationSchema rhs = ((OCSubsequentRegistrationSchema) other);
        return (((((((((((((this.startDateType == rhs.startDateType)||((this.startDateType!= null)&&this.startDateType.equals(rhs.startDateType)))&&((this.dataType == rhs.dataType)||((this.dataType!= null)&&this.dataType.equals(rhs.dataType))))&&((this.confidence == rhs.confidence)||((this.confidence!= null)&&this.confidence.equals(rhs.confidence))))&&((this.subsequentRegistrationStartDate == rhs.subsequentRegistrationStartDate)||((this.subsequentRegistrationStartDate!= null)&&this.subsequentRegistrationStartDate.equals(rhs.subsequentRegistrationStartDate))))&&((this.sourceUrl == rhs.sourceUrl)||((this.sourceUrl!= null)&&this.sourceUrl.equals(rhs.sourceUrl))))&&((this.retrievedAt == rhs.retrievedAt)||((this.retrievedAt!= null)&&this.retrievedAt.equals(rhs.retrievedAt))))&&((this.previousRegistrationEndDate == rhs.previousRegistrationEndDate)||((this.previousRegistrationEndDate!= null)&&this.previousRegistrationEndDate.equals(rhs.previousRegistrationEndDate))))&&((this.sampleDate == rhs.sampleDate)||((this.sampleDate!= null)&&this.sampleDate.equals(rhs.sampleDate))))&&((this.subsequentEntity == rhs.subsequentEntity)||((this.subsequentEntity!= null)&&this.subsequentEntity.equals(rhs.subsequentEntity))))&&((this.previousEntity == rhs.previousEntity)||((this.previousEntity!= null)&&this.previousEntity.equals(rhs.previousEntity))))&&((this.publicationDate == rhs.publicationDate)||((this.publicationDate!= null)&&this.publicationDate.equals(rhs.publicationDate))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))));
    }


    /**
     * Confidence in accuracy of data
     * 
     */
    public enum Confidence {

        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");
        private final String value;
        private final static Map<String, OCSubsequentRegistrationSchema.Confidence> CONSTANTS = new HashMap<String, OCSubsequentRegistrationSchema.Confidence>();

        static {
            for (OCSubsequentRegistrationSchema.Confidence c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Confidence(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCSubsequentRegistrationSchema.Confidence fromValue(String value) {
            OCSubsequentRegistrationSchema.Confidence constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum DataType {

        SUBSEQUENT_REGISTRATION("subsequent-registration");
        private final String value;
        private final static Map<String, OCSubsequentRegistrationSchema.DataType> CONSTANTS = new HashMap<String, OCSubsequentRegistrationSchema.DataType>();

        static {
            for (OCSubsequentRegistrationSchema.DataType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private DataType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCSubsequentRegistrationSchema.DataType fromValue(String value) {
            OCSubsequentRegistrationSchema.DataType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum StartDateType {

        AT("at"),
        BEFORE("before"),
        AFTER("after");
        private final String value;
        private final static Map<String, OCSubsequentRegistrationSchema.StartDateType> CONSTANTS = new HashMap<String, OCSubsequentRegistrationSchema.StartDateType>();

        static {
            for (OCSubsequentRegistrationSchema.StartDateType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private StartDateType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCSubsequentRegistrationSchema.StartDateType fromValue(String value) {
            OCSubsequentRegistrationSchema.StartDateType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
