
package com.opencorporates.schemas;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.opencorporates.schemas.includes.OCSubsidiaryRelationshipData;


/**
 * A relationship of control between two companies
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "sample_date",
    "start_date",
    "start_date_type",
    "end_date",
    "end_date_type",
    "retrieved_at",
    "source_jurisdiction",
    "company",
    "data"
})
public class OCSubsidiaryRelationshipSchema {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    @NotNull
    private LocalDate sampleDate;
    @JsonProperty("start_date")
    private LocalDate startDate;
    @JsonProperty("start_date_type")
    private String startDateType;
    @JsonProperty("end_date")
    private LocalDate endDate;
    @JsonProperty("end_date_type")
    private String endDateType;
    @JsonProperty("retrieved_at")
    private LocalDate retrievedAt;
    /**
     * Jurisdiction of the source of the data
     * 
     */
    @JsonProperty("source_jurisdiction")
    @JsonPropertyDescription("Jurisdiction of the source of the data")
    private String sourceJurisdiction;
    /**
     * A company which is the subject of a statement
     * (Required)
     * 
     */
    @JsonProperty("company")
    @JsonPropertyDescription("A company which is the subject of a statement")
    @Valid
    @NotNull
    private OCCompany company;
    /**
     * This is an array of data objects, that is the objects which actually contain the data about the datum. Generally there will only be one element in this, although in for some types of data_types there may naturally be several releated to the same company, e.g. shareholders
     * (Required)
     * 
     */
    @JsonProperty("data")
    @JsonPropertyDescription("This is an array of data objects, that is the objects which actually contain the data about the datum. Generally there will only be one element in this, although in for some types of data_types there may naturally be several releated to the same company, e.g. shareholders")
    @Valid
    @NotNull
    private List<OCSubsidiaryRelationshipData> data = new ArrayList<OCSubsidiaryRelationshipData>();

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    public LocalDate getSampleDate() {
        return sampleDate;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    @JsonProperty("start_date")
    public LocalDate getStartDate() {
        return startDate;
    }

    @JsonProperty("start_date")
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    @JsonProperty("start_date_type")
    public String getStartDateType() {
        return startDateType;
    }

    @JsonProperty("start_date_type")
    public void setStartDateType(String startDateType) {
        this.startDateType = startDateType;
    }

    @JsonProperty("end_date")
    public LocalDate getEndDate() {
        return endDate;
    }

    @JsonProperty("end_date")
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    @JsonProperty("end_date_type")
    public String getEndDateType() {
        return endDateType;
    }

    @JsonProperty("end_date_type")
    public void setEndDateType(String endDateType) {
        this.endDateType = endDateType;
    }

    @JsonProperty("retrieved_at")
    public LocalDate getRetrievedAt() {
        return retrievedAt;
    }

    @JsonProperty("retrieved_at")
    public void setRetrievedAt(LocalDate retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    /**
     * Jurisdiction of the source of the data
     * 
     */
    @JsonProperty("source_jurisdiction")
    public String getSourceJurisdiction() {
        return sourceJurisdiction;
    }

    /**
     * Jurisdiction of the source of the data
     * 
     */
    @JsonProperty("source_jurisdiction")
    public void setSourceJurisdiction(String sourceJurisdiction) {
        this.sourceJurisdiction = sourceJurisdiction;
    }

    /**
     * A company which is the subject of a statement
     * (Required)
     * 
     */
    @JsonProperty("company")
    public OCCompany getCompany() {
        return company;
    }

    /**
     * A company which is the subject of a statement
     * (Required)
     * 
     */
    @JsonProperty("company")
    public void setCompany(OCCompany company) {
        this.company = company;
    }

    /**
     * This is an array of data objects, that is the objects which actually contain the data about the datum. Generally there will only be one element in this, although in for some types of data_types there may naturally be several releated to the same company, e.g. shareholders
     * (Required)
     * 
     */
    @JsonProperty("data")
    public List<OCSubsidiaryRelationshipData> getData() {
        return data;
    }

    /**
     * This is an array of data objects, that is the objects which actually contain the data about the datum. Generally there will only be one element in this, although in for some types of data_types there may naturally be several releated to the same company, e.g. shareholders
     * (Required)
     * 
     */
    @JsonProperty("data")
    public void setData(List<OCSubsidiaryRelationshipData> data) {
        this.data = data;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCSubsidiaryRelationshipSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(((this.sampleDate == null)?"<null>":this.sampleDate));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("startDateType");
        sb.append('=');
        sb.append(((this.startDateType == null)?"<null>":this.startDateType));
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(((this.endDate == null)?"<null>":this.endDate));
        sb.append(',');
        sb.append("endDateType");
        sb.append('=');
        sb.append(((this.endDateType == null)?"<null>":this.endDateType));
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(((this.retrievedAt == null)?"<null>":this.retrievedAt));
        sb.append(',');
        sb.append("sourceJurisdiction");
        sb.append('=');
        sb.append(((this.sourceJurisdiction == null)?"<null>":this.sourceJurisdiction));
        sb.append(',');
        sb.append("company");
        sb.append('=');
        sb.append(((this.company == null)?"<null>":this.company));
        sb.append(',');
        sb.append("data");
        sb.append('=');
        sb.append(((this.data == null)?"<null>":this.data));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.retrievedAt == null)? 0 :this.retrievedAt.hashCode()));
        result = ((result* 31)+((this.sourceJurisdiction == null)? 0 :this.sourceJurisdiction.hashCode()));
        result = ((result* 31)+((this.data == null)? 0 :this.data.hashCode()));
        result = ((result* 31)+((this.startDateType == null)? 0 :this.startDateType.hashCode()));
        result = ((result* 31)+((this.endDate == null)? 0 :this.endDate.hashCode()));
        result = ((result* 31)+((this.sampleDate == null)? 0 :this.sampleDate.hashCode()));
        result = ((result* 31)+((this.endDateType == null)? 0 :this.endDateType.hashCode()));
        result = ((result* 31)+((this.company == null)? 0 :this.company.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCSubsidiaryRelationshipSchema) == false) {
            return false;
        }
        OCSubsidiaryRelationshipSchema rhs = ((OCSubsidiaryRelationshipSchema) other);
        return ((((((((((this.retrievedAt == rhs.retrievedAt)||((this.retrievedAt!= null)&&this.retrievedAt.equals(rhs.retrievedAt)))&&((this.sourceJurisdiction == rhs.sourceJurisdiction)||((this.sourceJurisdiction!= null)&&this.sourceJurisdiction.equals(rhs.sourceJurisdiction))))&&((this.data == rhs.data)||((this.data!= null)&&this.data.equals(rhs.data))))&&((this.startDateType == rhs.startDateType)||((this.startDateType!= null)&&this.startDateType.equals(rhs.startDateType))))&&((this.endDate == rhs.endDate)||((this.endDate!= null)&&this.endDate.equals(rhs.endDate))))&&((this.sampleDate == rhs.sampleDate)||((this.sampleDate!= null)&&this.sampleDate.equals(rhs.sampleDate))))&&((this.endDateType == rhs.endDateType)||((this.endDateType!= null)&&this.endDateType.equals(rhs.endDateType))))&&((this.company == rhs.company)||((this.company!= null)&&this.company.equals(rhs.company))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))));
    }

}
