
package com.opencorporates.schemas;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * A Trademark is a recognizable sign, design, or expression which identifies products or services of a particular source from those of others. This schema is actually for the trademark registration, i.e. not just the mark details, but the record of when it was registered and who holds the trademark. See also http://www.wipo.int/standards/XMLSchema/HTML/ST96TechnicalSpecification/V0-11/TrademarkComponents.html
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "register",
    "holders",
    "correspondent",
    "representative",
    "mark_details",
    "status",
    "uid",
    "url",
    "source_url",
    "confidence",
    "registration_date",
    "expiry_date",
    "start_date",
    "start_date_type",
    "retrieved_at",
    "sample_date",
    "other_attributes"
})
public class OCTrademarkRegistrationSchema {

    /**
     * The register on which the trademark is listed
     * (Required)
     * 
     */
    @JsonProperty("register")
    @JsonPropertyDescription("The register on which the trademark is listed")
    @NotNull
    private String register;
    /**
     * Details of the holder(s) of the trademark (sometimes called the owners)
     * (Required)
     * 
     */
    @JsonProperty("holders")
    @JsonPropertyDescription("Details of the holder(s) of the trademark (sometimes called the owners)")
    @Valid
    @NotNull
    private List<OCEntity> holders = new ArrayList<OCEntity>();
    @JsonProperty("correspondent")
    @Valid
    private OCEntity correspondent;
    @JsonProperty("representative")
    @Valid
    private OCEntity representative;
    /**
     * Details of the trademark itself (rather than the registration)
     * (Required)
     * 
     */
    @JsonProperty("mark_details")
    @JsonPropertyDescription("Details of the trademark itself (rather than the registration)")
    @Valid
    @NotNull
    private OCMarkDetails markDetails;
    /**
     * Status of the trademark registration
     * 
     */
    @JsonProperty("status")
    @JsonPropertyDescription("Status of the trademark registration")
    private String status;
    /**
     * Unique id/reference for the trademark registration
     * 
     */
    @JsonProperty("uid")
    @JsonPropertyDescription("Unique id/reference for the trademark registration")
    private String uid;
    /**
     * URL of trademark registration
     * 
     */
    @JsonProperty("url")
    @JsonPropertyDescription("URL of trademark registration")
    private String url;
    /**
     * Url of the source of the data (e.g. download URL), or if there is not persistent URL the page from which it can be found (e.g. search page). This field is required.
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    @JsonPropertyDescription("Url of the source of the data (e.g. download URL), or if there is not persistent URL the page from which it can be found (e.g. search page). This field is required.")
    @Size(min = 11)
    @NotNull
    private String sourceUrl;
    /**
     * Confidence in accuracy of data
     * (Required)
     * 
     */
    @JsonProperty("confidence")
    @JsonPropertyDescription("Confidence in accuracy of data")
    @NotNull
    private OCTrademarkRegistrationSchema.Confidence confidence;
    /**
     * Date on which the mark was registered
     * 
     */
    @JsonProperty("registration_date")
    @JsonPropertyDescription("Date on which the mark was registered")
    private LocalDate registrationDate;
    /**
     * Date on which the registration ended, or is scheduled to expire
     * 
     */
    @JsonProperty("expiry_date")
    @JsonPropertyDescription("Date on which the registration ended, or is scheduled to expire")
    private LocalDate expiryDate;
    /**
     * This should be the same as registration_date
     * 
     */
    @JsonProperty("start_date")
    @JsonPropertyDescription("This should be the same as registration_date")
    private LocalDate startDate;
    @JsonProperty("start_date_type")
    private OCTrademarkRegistrationSchema.StartDateType startDateType;
    /**
     * Date-time this was retrieved from the source
     * (Required)
     * 
     */
    @JsonProperty("retrieved_at")
    @JsonPropertyDescription("Date-time this was retrieved from the source")
    @NotNull
    private OffsetDateTime retrievedAt;
    /**
     * Date on which we know this to be true (for example the date the trademark data was retrieved if there's no explicit registration date)
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    @JsonPropertyDescription("Date on which we know this to be true (for example the date the trademark data was retrieved if there's no explicit registration date)")
    @NotNull
    private LocalDate sampleDate;
    /**
     * Use for other attributes for which we don't yet have curated schema attributes
     * 
     */
    @JsonProperty("other_attributes")
    @JsonPropertyDescription("Use for other attributes for which we don't yet have curated schema attributes")
    @Valid
    private OCOtherAttributes__8 otherAttributes;

    /**
     * The register on which the trademark is listed
     * (Required)
     * 
     */
    @JsonProperty("register")
    public String getRegister() {
        return register;
    }

    /**
     * The register on which the trademark is listed
     * (Required)
     * 
     */
    @JsonProperty("register")
    public void setRegister(String register) {
        this.register = register;
    }

    /**
     * Details of the holder(s) of the trademark (sometimes called the owners)
     * (Required)
     * 
     */
    @JsonProperty("holders")
    public List<OCEntity> getHolders() {
        return holders;
    }

    /**
     * Details of the holder(s) of the trademark (sometimes called the owners)
     * (Required)
     * 
     */
    @JsonProperty("holders")
    public void setHolders(List<OCEntity> holders) {
        this.holders = holders;
    }

    @JsonProperty("correspondent")
    public OCEntity getCorrespondent() {
        return correspondent;
    }

    @JsonProperty("correspondent")
    public void setCorrespondent(OCEntity correspondent) {
        this.correspondent = correspondent;
    }

    @JsonProperty("representative")
    public OCEntity getRepresentative() {
        return representative;
    }

    @JsonProperty("representative")
    public void setRepresentative(OCEntity representative) {
        this.representative = representative;
    }

    /**
     * Details of the trademark itself (rather than the registration)
     * (Required)
     * 
     */
    @JsonProperty("mark_details")
    public OCMarkDetails getMarkDetails() {
        return markDetails;
    }

    /**
     * Details of the trademark itself (rather than the registration)
     * (Required)
     * 
     */
    @JsonProperty("mark_details")
    public void setMarkDetails(OCMarkDetails markDetails) {
        this.markDetails = markDetails;
    }

    /**
     * Status of the trademark registration
     * 
     */
    @JsonProperty("status")
    public String getStatus() {
        return status;
    }

    /**
     * Status of the trademark registration
     * 
     */
    @JsonProperty("status")
    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * Unique id/reference for the trademark registration
     * 
     */
    @JsonProperty("uid")
    public String getUid() {
        return uid;
    }

    /**
     * Unique id/reference for the trademark registration
     * 
     */
    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    /**
     * URL of trademark registration
     * 
     */
    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    /**
     * URL of trademark registration
     * 
     */
    @JsonProperty("url")
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * Url of the source of the data (e.g. download URL), or if there is not persistent URL the page from which it can be found (e.g. search page). This field is required.
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    public String getSourceUrl() {
        return sourceUrl;
    }

    /**
     * Url of the source of the data (e.g. download URL), or if there is not persistent URL the page from which it can be found (e.g. search page). This field is required.
     * (Required)
     * 
     */
    @JsonProperty("source_url")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    /**
     * Confidence in accuracy of data
     * (Required)
     * 
     */
    @JsonProperty("confidence")
    public OCTrademarkRegistrationSchema.Confidence getConfidence() {
        return confidence;
    }

    /**
     * Confidence in accuracy of data
     * (Required)
     * 
     */
    @JsonProperty("confidence")
    public void setConfidence(OCTrademarkRegistrationSchema.Confidence confidence) {
        this.confidence = confidence;
    }

    /**
     * Date on which the mark was registered
     * 
     */
    @JsonProperty("registration_date")
    public LocalDate getRegistrationDate() {
        return registrationDate;
    }

    /**
     * Date on which the mark was registered
     * 
     */
    @JsonProperty("registration_date")
    public void setRegistrationDate(LocalDate registrationDate) {
        this.registrationDate = registrationDate;
    }

    /**
     * Date on which the registration ended, or is scheduled to expire
     * 
     */
    @JsonProperty("expiry_date")
    public LocalDate getExpiryDate() {
        return expiryDate;
    }

    /**
     * Date on which the registration ended, or is scheduled to expire
     * 
     */
    @JsonProperty("expiry_date")
    public void setExpiryDate(LocalDate expiryDate) {
        this.expiryDate = expiryDate;
    }

    /**
     * This should be the same as registration_date
     * 
     */
    @JsonProperty("start_date")
    public LocalDate getStartDate() {
        return startDate;
    }

    /**
     * This should be the same as registration_date
     * 
     */
    @JsonProperty("start_date")
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    @JsonProperty("start_date_type")
    public OCTrademarkRegistrationSchema.StartDateType getStartDateType() {
        return startDateType;
    }

    @JsonProperty("start_date_type")
    public void setStartDateType(OCTrademarkRegistrationSchema.StartDateType startDateType) {
        this.startDateType = startDateType;
    }

    /**
     * Date-time this was retrieved from the source
     * (Required)
     * 
     */
    @JsonProperty("retrieved_at")
    public OffsetDateTime getRetrievedAt() {
        return retrievedAt;
    }

    /**
     * Date-time this was retrieved from the source
     * (Required)
     * 
     */
    @JsonProperty("retrieved_at")
    public void setRetrievedAt(OffsetDateTime retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    /**
     * Date on which we know this to be true (for example the date the trademark data was retrieved if there's no explicit registration date)
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    public LocalDate getSampleDate() {
        return sampleDate;
    }

    /**
     * Date on which we know this to be true (for example the date the trademark data was retrieved if there's no explicit registration date)
     * (Required)
     * 
     */
    @JsonProperty("sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    /**
     * Use for other attributes for which we don't yet have curated schema attributes
     * 
     */
    @JsonProperty("other_attributes")
    public OCOtherAttributes__8 getOtherAttributes() {
        return otherAttributes;
    }

    /**
     * Use for other attributes for which we don't yet have curated schema attributes
     * 
     */
    @JsonProperty("other_attributes")
    public void setOtherAttributes(OCOtherAttributes__8 otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCTrademarkRegistrationSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("register");
        sb.append('=');
        sb.append(((this.register == null)?"<null>":this.register));
        sb.append(',');
        sb.append("holders");
        sb.append('=');
        sb.append(((this.holders == null)?"<null>":this.holders));
        sb.append(',');
        sb.append("correspondent");
        sb.append('=');
        sb.append(((this.correspondent == null)?"<null>":this.correspondent));
        sb.append(',');
        sb.append("representative");
        sb.append('=');
        sb.append(((this.representative == null)?"<null>":this.representative));
        sb.append(',');
        sb.append("markDetails");
        sb.append('=');
        sb.append(((this.markDetails == null)?"<null>":this.markDetails));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(((this.url == null)?"<null>":this.url));
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(((this.sourceUrl == null)?"<null>":this.sourceUrl));
        sb.append(',');
        sb.append("confidence");
        sb.append('=');
        sb.append(((this.confidence == null)?"<null>":this.confidence));
        sb.append(',');
        sb.append("registrationDate");
        sb.append('=');
        sb.append(((this.registrationDate == null)?"<null>":this.registrationDate));
        sb.append(',');
        sb.append("expiryDate");
        sb.append('=');
        sb.append(((this.expiryDate == null)?"<null>":this.expiryDate));
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(((this.startDate == null)?"<null>":this.startDate));
        sb.append(',');
        sb.append("startDateType");
        sb.append('=');
        sb.append(((this.startDateType == null)?"<null>":this.startDateType));
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(((this.retrievedAt == null)?"<null>":this.retrievedAt));
        sb.append(',');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(((this.sampleDate == null)?"<null>":this.sampleDate));
        sb.append(',');
        sb.append("otherAttributes");
        sb.append('=');
        sb.append(((this.otherAttributes == null)?"<null>":this.otherAttributes));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.startDateType == null)? 0 :this.startDateType.hashCode()));
        result = ((result* 31)+((this.confidence == null)? 0 :this.confidence.hashCode()));
        result = ((result* 31)+((this.markDetails == null)? 0 :this.markDetails.hashCode()));
        result = ((result* 31)+((this.otherAttributes == null)? 0 :this.otherAttributes.hashCode()));
        result = ((result* 31)+((this.url == null)? 0 :this.url.hashCode()));
        result = ((result* 31)+((this.sourceUrl == null)? 0 :this.sourceUrl.hashCode()));
        result = ((result* 31)+((this.expiryDate == null)? 0 :this.expiryDate.hashCode()));
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.retrievedAt == null)? 0 :this.retrievedAt.hashCode()));
        result = ((result* 31)+((this.holders == null)? 0 :this.holders.hashCode()));
        result = ((result* 31)+((this.registrationDate == null)? 0 :this.registrationDate.hashCode()));
        result = ((result* 31)+((this.sampleDate == null)? 0 :this.sampleDate.hashCode()));
        result = ((result* 31)+((this.correspondent == null)? 0 :this.correspondent.hashCode()));
        result = ((result* 31)+((this.representative == null)? 0 :this.representative.hashCode()));
        result = ((result* 31)+((this.startDate == null)? 0 :this.startDate.hashCode()));
        result = ((result* 31)+((this.register == null)? 0 :this.register.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCTrademarkRegistrationSchema) == false) {
            return false;
        }
        OCTrademarkRegistrationSchema rhs = ((OCTrademarkRegistrationSchema) other);
        return ((((((((((((((((((this.startDateType == rhs.startDateType)||((this.startDateType!= null)&&this.startDateType.equals(rhs.startDateType)))&&((this.confidence == rhs.confidence)||((this.confidence!= null)&&this.confidence.equals(rhs.confidence))))&&((this.markDetails == rhs.markDetails)||((this.markDetails!= null)&&this.markDetails.equals(rhs.markDetails))))&&((this.otherAttributes == rhs.otherAttributes)||((this.otherAttributes!= null)&&this.otherAttributes.equals(rhs.otherAttributes))))&&((this.url == rhs.url)||((this.url!= null)&&this.url.equals(rhs.url))))&&((this.sourceUrl == rhs.sourceUrl)||((this.sourceUrl!= null)&&this.sourceUrl.equals(rhs.sourceUrl))))&&((this.expiryDate == rhs.expiryDate)||((this.expiryDate!= null)&&this.expiryDate.equals(rhs.expiryDate))))&&((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid))))&&((this.retrievedAt == rhs.retrievedAt)||((this.retrievedAt!= null)&&this.retrievedAt.equals(rhs.retrievedAt))))&&((this.holders == rhs.holders)||((this.holders!= null)&&this.holders.equals(rhs.holders))))&&((this.registrationDate == rhs.registrationDate)||((this.registrationDate!= null)&&this.registrationDate.equals(rhs.registrationDate))))&&((this.sampleDate == rhs.sampleDate)||((this.sampleDate!= null)&&this.sampleDate.equals(rhs.sampleDate))))&&((this.correspondent == rhs.correspondent)||((this.correspondent!= null)&&this.correspondent.equals(rhs.correspondent))))&&((this.representative == rhs.representative)||((this.representative!= null)&&this.representative.equals(rhs.representative))))&&((this.startDate == rhs.startDate)||((this.startDate!= null)&&this.startDate.equals(rhs.startDate))))&&((this.register == rhs.register)||((this.register!= null)&&this.register.equals(rhs.register))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }


    /**
     * Confidence in accuracy of data
     * 
     */
    public enum Confidence {

        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");
        private final String value;
        private final static Map<String, OCTrademarkRegistrationSchema.Confidence> CONSTANTS = new HashMap<String, OCTrademarkRegistrationSchema.Confidence>();

        static {
            for (OCTrademarkRegistrationSchema.Confidence c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Confidence(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCTrademarkRegistrationSchema.Confidence fromValue(String value) {
            OCTrademarkRegistrationSchema.Confidence constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum StartDateType {

        AT("at"),
        BEFORE("before"),
        AFTER("after");
        private final String value;
        private final static Map<String, OCTrademarkRegistrationSchema.StartDateType> CONSTANTS = new HashMap<String, OCTrademarkRegistrationSchema.StartDateType>();

        static {
            for (OCTrademarkRegistrationSchema.StartDateType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private StartDateType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCTrademarkRegistrationSchema.StartDateType fromValue(String value) {
            OCTrademarkRegistrationSchema.StartDateType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
