
package com.opencorporates.schemas.includes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.opencorporates.schemas.OCCompany;
import com.opencorporates.schemas.OCFinancialPaymentDataObject;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "source_jurisdiction",
    "company",
    "data"
})
public class OCBaseStatement {

    /**
     * Jurisdiction of the source of the data
     * 
     */
    @JsonProperty("source_jurisdiction")
    @JsonPropertyDescription("Jurisdiction of the source of the data")
    private String sourceJurisdiction;
    /**
     * A company which is the subject of a statement
     * (Required)
     * 
     */
    @JsonProperty("company")
    @JsonPropertyDescription("A company which is the subject of a statement")
    @Valid
    @NotNull
    private OCCompany company;
    /**
     * This is an array of data objects, that is the objects which actually contain the data about the datum. Generally there will only be one element in this, although in for some types of data_types there may naturally be several releated to the same company, e.g. shareholders
     * (Required)
     * 
     */
    @JsonProperty("data")
    @JsonPropertyDescription("This is an array of data objects, that is the objects which actually contain the data about the datum. Generally there will only be one element in this, although in for some types of data_types there may naturally be several releated to the same company, e.g. shareholders")
    @Valid
    @NotNull
    private List<OCFinancialPaymentDataObject> data = new ArrayList<OCFinancialPaymentDataObject>();
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * Jurisdiction of the source of the data
     * 
     */
    @JsonProperty("source_jurisdiction")
    public String getSourceJurisdiction() {
        return sourceJurisdiction;
    }

    /**
     * Jurisdiction of the source of the data
     * 
     */
    @JsonProperty("source_jurisdiction")
    public void setSourceJurisdiction(String sourceJurisdiction) {
        this.sourceJurisdiction = sourceJurisdiction;
    }

    /**
     * A company which is the subject of a statement
     * (Required)
     * 
     */
    @JsonProperty("company")
    public OCCompany getCompany() {
        return company;
    }

    /**
     * A company which is the subject of a statement
     * (Required)
     * 
     */
    @JsonProperty("company")
    public void setCompany(OCCompany company) {
        this.company = company;
    }

    /**
     * This is an array of data objects, that is the objects which actually contain the data about the datum. Generally there will only be one element in this, although in for some types of data_types there may naturally be several releated to the same company, e.g. shareholders
     * (Required)
     * 
     */
    @JsonProperty("data")
    public List<OCFinancialPaymentDataObject> getData() {
        return data;
    }

    /**
     * This is an array of data objects, that is the objects which actually contain the data about the datum. Generally there will only be one element in this, although in for some types of data_types there may naturally be several releated to the same company, e.g. shareholders
     * (Required)
     * 
     */
    @JsonProperty("data")
    public void setData(List<OCFinancialPaymentDataObject> data) {
        this.data = data;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCBaseStatement.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("sourceJurisdiction");
        sb.append('=');
        sb.append(((this.sourceJurisdiction == null)?"<null>":this.sourceJurisdiction));
        sb.append(',');
        sb.append("company");
        sb.append('=');
        sb.append(((this.company == null)?"<null>":this.company));
        sb.append(',');
        sb.append("data");
        sb.append('=');
        sb.append(((this.data == null)?"<null>":this.data));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.company == null)? 0 :this.company.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.sourceJurisdiction == null)? 0 :this.sourceJurisdiction.hashCode()));
        result = ((result* 31)+((this.data == null)? 0 :this.data.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCBaseStatement) == false) {
            return false;
        }
        OCBaseStatement rhs = ((OCBaseStatement) other);
        return (((((this.company == rhs.company)||((this.company!= null)&&this.company.equals(rhs.company)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.sourceJurisdiction == rhs.sourceJurisdiction)||((this.sourceJurisdiction!= null)&&this.sourceJurisdiction.equals(rhs.sourceJurisdiction))))&&((this.data == rhs.data)||((this.data!= null)&&this.data.equals(rhs.data))));
    }

}
