
package com.opencorporates.schemas.includes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Classification
 * <p>
 * A classification from a code list
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "code_scheme_id",
    "code",
    "name"
})
public class OCClassification {

    /**
     * The scheme of the classification
     * 
     */
    @JsonProperty("code_scheme_id")
    @JsonPropertyDescription("The scheme of the classification")
    private String codeSchemeId;
    /**
     * The classification
     * 
     */
    @JsonProperty("code")
    @JsonPropertyDescription("The classification")
    private String code;
    /**
     * A title or description of the classification, especially if the value is a code
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("A title or description of the classification, especially if the value is a code")
    private String name;

    /**
     * The scheme of the classification
     * 
     */
    @JsonProperty("code_scheme_id")
    public String getCodeSchemeId() {
        return codeSchemeId;
    }

    /**
     * The scheme of the classification
     * 
     */
    @JsonProperty("code_scheme_id")
    public void setCodeSchemeId(String codeSchemeId) {
        this.codeSchemeId = codeSchemeId;
    }

    /**
     * The classification
     * 
     */
    @JsonProperty("code")
    public String getCode() {
        return code;
    }

    /**
     * The classification
     * 
     */
    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    /**
     * A title or description of the classification, especially if the value is a code
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * A title or description of the classification, especially if the value is a code
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCClassification.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("codeSchemeId");
        sb.append('=');
        sb.append(((this.codeSchemeId == null)?"<null>":this.codeSchemeId));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.codeSchemeId == null)? 0 :this.codeSchemeId.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCClassification) == false) {
            return false;
        }
        OCClassification rhs = ((OCClassification) other);
        return ((((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name)))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.codeSchemeId == rhs.codeSchemeId)||((this.codeSchemeId!= null)&&this.codeSchemeId.equals(rhs.codeSchemeId))));
    }

}
