
package com.opencorporates.schemas.includes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * A parsed date object. This allows us to represent not just normal dates, but also partial dates too
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "year",
    "month",
    "day"
})
public class OCDate {

    /**
     * year part as YYYY
     * 
     */
    @JsonProperty("year")
    @JsonPropertyDescription("year part as YYYY")
    private Double year;
    /**
     * month part of date in numbers e.g. 11 for November, 4 for April
     * 
     */
    @JsonProperty("month")
    @JsonPropertyDescription("month part of date in numbers e.g. 11 for November, 4 for April")
    private Double month;
    /**
     * day part of date in numbers
     * 
     */
    @JsonProperty("day")
    @JsonPropertyDescription("day part of date in numbers")
    private Double day;

    /**
     * year part as YYYY
     * 
     */
    @JsonProperty("year")
    public Double getYear() {
        return year;
    }

    /**
     * year part as YYYY
     * 
     */
    @JsonProperty("year")
    public void setYear(Double year) {
        this.year = year;
    }

    /**
     * month part of date in numbers e.g. 11 for November, 4 for April
     * 
     */
    @JsonProperty("month")
    public Double getMonth() {
        return month;
    }

    /**
     * month part of date in numbers e.g. 11 for November, 4 for April
     * 
     */
    @JsonProperty("month")
    public void setMonth(Double month) {
        this.month = month;
    }

    /**
     * day part of date in numbers
     * 
     */
    @JsonProperty("day")
    public Double getDay() {
        return day;
    }

    /**
     * day part of date in numbers
     * 
     */
    @JsonProperty("day")
    public void setDay(Double day) {
        this.day = day;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCDate.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("year");
        sb.append('=');
        sb.append(((this.year == null)?"<null>":this.year));
        sb.append(',');
        sb.append("month");
        sb.append('=');
        sb.append(((this.month == null)?"<null>":this.month));
        sb.append(',');
        sb.append("day");
        sb.append('=');
        sb.append(((this.day == null)?"<null>":this.day));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.month == null)? 0 :this.month.hashCode()));
        result = ((result* 31)+((this.year == null)? 0 :this.year.hashCode()));
        result = ((result* 31)+((this.day == null)? 0 :this.day.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCDate) == false) {
            return false;
        }
        OCDate rhs = ((OCDate) other);
        return ((((this.month == rhs.month)||((this.month!= null)&&this.month.equals(rhs.month)))&&((this.year == rhs.year)||((this.year!= null)&&this.year.equals(rhs.year))))&&((this.day == rhs.day)||((this.day!= null)&&this.day.equals(rhs.day))));
    }

}
