
package com.opencorporates.schemas.includes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "regulator",
    "category",
    "jurisdiction_code",
    "licence_number",
    "jurisdiction_classification",
    "oc_classification"
})
public class OCProperties {

    /**
     * The regulating body that issued the licence
     * 
     */
    @JsonProperty("regulator")
    @JsonPropertyDescription("The regulating body that issued the licence")
    private String regulator;
    /**
     * The category of licence. Current possible values are: 'Financial','Business'
     * (Required)
     * 
     */
    @JsonProperty("category")
    @JsonPropertyDescription("The category of licence. Current possible values are: 'Financial','Business'")
    @NotNull
    private OCProperties.Category category;
    /**
     * The jurisdiction for which licence was issued
     * (Required)
     * 
     */
    @JsonProperty("jurisdiction_code")
    @JsonPropertyDescription("The jurisdiction for which licence was issued")
    @NotNull
    private String jurisdictionCode;
    /**
     * Licence number or code (can be null)
     * 
     */
    @JsonProperty("licence_number")
    @JsonPropertyDescription("Licence number or code (can be null)")
    private String licenceNumber;
    /**
     * The local classification given by the regulator
     * (Required)
     * 
     */
    @JsonProperty("jurisdiction_classification")
    @JsonPropertyDescription("The local classification given by the regulator")
    @Size(min = 1)
    @Valid
    @NotNull
    private List<Object> jurisdictionClassification = new ArrayList<Object>();
    @JsonProperty("oc_classification")
    @Valid
    private List<Object> ocClassification = new ArrayList<Object>();
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The regulating body that issued the licence
     * 
     */
    @JsonProperty("regulator")
    public String getRegulator() {
        return regulator;
    }

    /**
     * The regulating body that issued the licence
     * 
     */
    @JsonProperty("regulator")
    public void setRegulator(String regulator) {
        this.regulator = regulator;
    }

    /**
     * The category of licence. Current possible values are: 'Financial','Business'
     * (Required)
     * 
     */
    @JsonProperty("category")
    public OCProperties.Category getCategory() {
        return category;
    }

    /**
     * The category of licence. Current possible values are: 'Financial','Business'
     * (Required)
     * 
     */
    @JsonProperty("category")
    public void setCategory(OCProperties.Category category) {
        this.category = category;
    }

    /**
     * The jurisdiction for which licence was issued
     * (Required)
     * 
     */
    @JsonProperty("jurisdiction_code")
    public String getJurisdictionCode() {
        return jurisdictionCode;
    }

    /**
     * The jurisdiction for which licence was issued
     * (Required)
     * 
     */
    @JsonProperty("jurisdiction_code")
    public void setJurisdictionCode(String jurisdictionCode) {
        this.jurisdictionCode = jurisdictionCode;
    }

    /**
     * Licence number or code (can be null)
     * 
     */
    @JsonProperty("licence_number")
    public String getLicenceNumber() {
        return licenceNumber;
    }

    /**
     * Licence number or code (can be null)
     * 
     */
    @JsonProperty("licence_number")
    public void setLicenceNumber(String licenceNumber) {
        this.licenceNumber = licenceNumber;
    }

    /**
     * The local classification given by the regulator
     * (Required)
     * 
     */
    @JsonProperty("jurisdiction_classification")
    public List<Object> getJurisdictionClassification() {
        return jurisdictionClassification;
    }

    /**
     * The local classification given by the regulator
     * (Required)
     * 
     */
    @JsonProperty("jurisdiction_classification")
    public void setJurisdictionClassification(List<Object> jurisdictionClassification) {
        this.jurisdictionClassification = jurisdictionClassification;
    }

    @JsonProperty("oc_classification")
    public List<Object> getOcClassification() {
        return ocClassification;
    }

    @JsonProperty("oc_classification")
    public void setOcClassification(List<Object> ocClassification) {
        this.ocClassification = ocClassification;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCProperties.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("regulator");
        sb.append('=');
        sb.append(((this.regulator == null)?"<null>":this.regulator));
        sb.append(',');
        sb.append("category");
        sb.append('=');
        sb.append(((this.category == null)?"<null>":this.category));
        sb.append(',');
        sb.append("jurisdictionCode");
        sb.append('=');
        sb.append(((this.jurisdictionCode == null)?"<null>":this.jurisdictionCode));
        sb.append(',');
        sb.append("licenceNumber");
        sb.append('=');
        sb.append(((this.licenceNumber == null)?"<null>":this.licenceNumber));
        sb.append(',');
        sb.append("jurisdictionClassification");
        sb.append('=');
        sb.append(((this.jurisdictionClassification == null)?"<null>":this.jurisdictionClassification));
        sb.append(',');
        sb.append("ocClassification");
        sb.append('=');
        sb.append(((this.ocClassification == null)?"<null>":this.ocClassification));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.ocClassification == null)? 0 :this.ocClassification.hashCode()));
        result = ((result* 31)+((this.licenceNumber == null)? 0 :this.licenceNumber.hashCode()));
        result = ((result* 31)+((this.regulator == null)? 0 :this.regulator.hashCode()));
        result = ((result* 31)+((this.jurisdictionCode == null)? 0 :this.jurisdictionCode.hashCode()));
        result = ((result* 31)+((this.jurisdictionClassification == null)? 0 :this.jurisdictionClassification.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.category == null)? 0 :this.category.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCProperties) == false) {
            return false;
        }
        OCProperties rhs = ((OCProperties) other);
        return ((((((((this.ocClassification == rhs.ocClassification)||((this.ocClassification!= null)&&this.ocClassification.equals(rhs.ocClassification)))&&((this.licenceNumber == rhs.licenceNumber)||((this.licenceNumber!= null)&&this.licenceNumber.equals(rhs.licenceNumber))))&&((this.regulator == rhs.regulator)||((this.regulator!= null)&&this.regulator.equals(rhs.regulator))))&&((this.jurisdictionCode == rhs.jurisdictionCode)||((this.jurisdictionCode!= null)&&this.jurisdictionCode.equals(rhs.jurisdictionCode))))&&((this.jurisdictionClassification == rhs.jurisdictionClassification)||((this.jurisdictionClassification!= null)&&this.jurisdictionClassification.equals(rhs.jurisdictionClassification))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.category == rhs.category)||((this.category!= null)&&this.category.equals(rhs.category))));
    }


    /**
     * The category of licence. Current possible values are: 'Financial','Business'
     * 
     */
    public enum Category {

        FINANCIAL("Financial"),
        BUSINESS("Business");
        private final String value;
        private final static Map<String, OCProperties.Category> CONSTANTS = new HashMap<String, OCProperties.Category>();

        static {
            for (OCProperties.Category c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Category(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OCProperties.Category fromValue(String value) {
            OCProperties.Category constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
