
package com.opencorporates.schemas.includes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "number_of_shares",
    "percentage_of_shares",
    "shareholders"
})
public class OCProperties__1 {

    /**
     * Number of shares, if known
     * 
     */
    @JsonProperty("number_of_shares")
    @JsonPropertyDescription("Number of shares, if known")
    private Integer numberOfShares;
    /**
     * Percentage of shares, if known
     * 
     */
    @JsonProperty("percentage_of_shares")
    @JsonPropertyDescription("Percentage of shares, if known")
    private Double percentageOfShares;
    /**
     * Legal persons who own this share parcel
     * (Required)
     * 
     */
    @JsonProperty("shareholders")
    @JsonPropertyDescription("Legal persons who own this share parcel")
    @Size(min = 1)
    @Valid
    @NotNull
    private List<Object> shareholders = new ArrayList<Object>();
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * Number of shares, if known
     * 
     */
    @JsonProperty("number_of_shares")
    public Integer getNumberOfShares() {
        return numberOfShares;
    }

    /**
     * Number of shares, if known
     * 
     */
    @JsonProperty("number_of_shares")
    public void setNumberOfShares(Integer numberOfShares) {
        this.numberOfShares = numberOfShares;
    }

    /**
     * Percentage of shares, if known
     * 
     */
    @JsonProperty("percentage_of_shares")
    public Double getPercentageOfShares() {
        return percentageOfShares;
    }

    /**
     * Percentage of shares, if known
     * 
     */
    @JsonProperty("percentage_of_shares")
    public void setPercentageOfShares(Double percentageOfShares) {
        this.percentageOfShares = percentageOfShares;
    }

    /**
     * Legal persons who own this share parcel
     * (Required)
     * 
     */
    @JsonProperty("shareholders")
    public List<Object> getShareholders() {
        return shareholders;
    }

    /**
     * Legal persons who own this share parcel
     * (Required)
     * 
     */
    @JsonProperty("shareholders")
    public void setShareholders(List<Object> shareholders) {
        this.shareholders = shareholders;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCProperties__1 .class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("numberOfShares");
        sb.append('=');
        sb.append(((this.numberOfShares == null)?"<null>":this.numberOfShares));
        sb.append(',');
        sb.append("percentageOfShares");
        sb.append('=');
        sb.append(((this.percentageOfShares == null)?"<null>":this.percentageOfShares));
        sb.append(',');
        sb.append("shareholders");
        sb.append('=');
        sb.append(((this.shareholders == null)?"<null>":this.shareholders));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shareholders == null)? 0 :this.shareholders.hashCode()));
        result = ((result* 31)+((this.percentageOfShares == null)? 0 :this.percentageOfShares.hashCode()));
        result = ((result* 31)+((this.numberOfShares == null)? 0 :this.numberOfShares.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCProperties__1) == false) {
            return false;
        }
        OCProperties__1 rhs = ((OCProperties__1) other);
        return (((((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties)))&&((this.shareholders == rhs.shareholders)||((this.shareholders!= null)&&this.shareholders.equals(rhs.shareholders))))&&((this.percentageOfShares == rhs.percentageOfShares)||((this.percentageOfShares!= null)&&this.percentageOfShares.equals(rhs.percentageOfShares))))&&((this.numberOfShares == rhs.numberOfShares)||((this.numberOfShares!= null)&&this.numberOfShares.equals(rhs.numberOfShares))));
    }

}
