
package com.opencorporates.schemas.includes;

import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.opencorporates.schemas.OCAlternativeName;
import com.opencorporates.schemas.OCIdentifier;
import com.opencorporates.schemas.OCIndustryCode;
import com.opencorporates.schemas.OCPreviousName;


/**
 * An entity of unknown type - potentially a company, a person, government entity, or some unincorporated organisation
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "jurisdiction",
    "uid",
    "website",
    "telephone_number",
    "fax_number",
    "registered_address",
    "headquarters_address",
    "mailing_address",
    "addresses",
    "identifiers",
    "industry_codes",
    "previous_names",
    "alternative_names",
    "other_attributes"
})
public class OCUnknownEntityType {

    /**
     * Name of the entity
     * (Required)
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Name of the entity")
    @Size(min = 1)
    @NotNull
    private String name;
    /**
     * Name of the jurisdiction in which the entity is incorporated/domiciled
     * 
     */
    @JsonProperty("jurisdiction")
    @JsonPropertyDescription("Name of the jurisdiction in which the entity is incorporated/domiciled")
    private String jurisdiction;
    /**
     * Unique id for the entity if it has one
     * 
     */
    @JsonProperty("uid")
    @JsonPropertyDescription("Unique id for the entity if it has one")
    private String uid;
    @JsonProperty("website")
    private Object website;
    @JsonProperty("telephone_number")
    @Size(min = 4)
    private String telephoneNumber;
    @JsonProperty("fax_number")
    @Size(min = 4)
    private String faxNumber;
    @JsonProperty("registered_address")
    private Object registeredAddress;
    @JsonProperty("headquarters_address")
    private Object headquartersAddress;
    @JsonProperty("mailing_address")
    private Object mailingAddress;
    @JsonProperty("addresses")
    @Valid
    private List<OCAddressWithType> addresses = new ArrayList<OCAddressWithType>();
    @JsonProperty("identifiers")
    private List<OCIdentifier> identifiers = new ArrayList<OCIdentifier>();
    @JsonProperty("industry_codes")
    @Valid
    private List<OCIndustryCode> industryCodes = new ArrayList<OCIndustryCode>();
    @JsonProperty("previous_names")
    @Valid
    private List<OCPreviousName> previousNames = new ArrayList<OCPreviousName>();
    @JsonProperty("alternative_names")
    @Valid
    private List<OCAlternativeName> alternativeNames = new ArrayList<OCAlternativeName>();
    /**
     * Use for other attributes for which we don't yet have curated schema attributes
     * 
     */
    @JsonProperty("other_attributes")
    @JsonPropertyDescription("Use for other attributes for which we don't yet have curated schema attributes")
    @Valid
    private OCOtherAttributes__2 otherAttributes;

    /**
     * Name of the entity
     * (Required)
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * Name of the entity
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Name of the jurisdiction in which the entity is incorporated/domiciled
     * 
     */
    @JsonProperty("jurisdiction")
    public String getJurisdiction() {
        return jurisdiction;
    }

    /**
     * Name of the jurisdiction in which the entity is incorporated/domiciled
     * 
     */
    @JsonProperty("jurisdiction")
    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    /**
     * Unique id for the entity if it has one
     * 
     */
    @JsonProperty("uid")
    public String getUid() {
        return uid;
    }

    /**
     * Unique id for the entity if it has one
     * 
     */
    @JsonProperty("uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    @JsonProperty("website")
    public Object getWebsite() {
        return website;
    }

    @JsonProperty("website")
    public void setWebsite(Object website) {
        this.website = website;
    }

    @JsonProperty("telephone_number")
    public String getTelephoneNumber() {
        return telephoneNumber;
    }

    @JsonProperty("telephone_number")
    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    @JsonProperty("fax_number")
    public String getFaxNumber() {
        return faxNumber;
    }

    @JsonProperty("fax_number")
    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
    }

    @JsonProperty("registered_address")
    public Object getRegisteredAddress() {
        return registeredAddress;
    }

    @JsonProperty("registered_address")
    public void setRegisteredAddress(Object registeredAddress) {
        this.registeredAddress = registeredAddress;
    }

    @JsonProperty("headquarters_address")
    public Object getHeadquartersAddress() {
        return headquartersAddress;
    }

    @JsonProperty("headquarters_address")
    public void setHeadquartersAddress(Object headquartersAddress) {
        this.headquartersAddress = headquartersAddress;
    }

    @JsonProperty("mailing_address")
    public Object getMailingAddress() {
        return mailingAddress;
    }

    @JsonProperty("mailing_address")
    public void setMailingAddress(Object mailingAddress) {
        this.mailingAddress = mailingAddress;
    }

    @JsonProperty("addresses")
    public List<OCAddressWithType> getAddresses() {
        return addresses;
    }

    @JsonProperty("addresses")
    public void setAddresses(List<OCAddressWithType> addresses) {
        this.addresses = addresses;
    }

    @JsonProperty("identifiers")
    public List<OCIdentifier> getIdentifiers() {
        return identifiers;
    }

    @JsonProperty("identifiers")
    public void setIdentifiers(List<OCIdentifier> identifiers) {
        this.identifiers = identifiers;
    }

    @JsonProperty("industry_codes")
    public List<OCIndustryCode> getIndustryCodes() {
        return industryCodes;
    }

    @JsonProperty("industry_codes")
    public void setIndustryCodes(List<OCIndustryCode> industryCodes) {
        this.industryCodes = industryCodes;
    }

    @JsonProperty("previous_names")
    public List<OCPreviousName> getPreviousNames() {
        return previousNames;
    }

    @JsonProperty("previous_names")
    public void setPreviousNames(List<OCPreviousName> previousNames) {
        this.previousNames = previousNames;
    }

    @JsonProperty("alternative_names")
    public List<OCAlternativeName> getAlternativeNames() {
        return alternativeNames;
    }

    @JsonProperty("alternative_names")
    public void setAlternativeNames(List<OCAlternativeName> alternativeNames) {
        this.alternativeNames = alternativeNames;
    }

    /**
     * Use for other attributes for which we don't yet have curated schema attributes
     * 
     */
    @JsonProperty("other_attributes")
    public OCOtherAttributes__2 getOtherAttributes() {
        return otherAttributes;
    }

    /**
     * Use for other attributes for which we don't yet have curated schema attributes
     * 
     */
    @JsonProperty("other_attributes")
    public void setOtherAttributes(OCOtherAttributes__2 otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCUnknownEntityType.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("jurisdiction");
        sb.append('=');
        sb.append(((this.jurisdiction == null)?"<null>":this.jurisdiction));
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(((this.uid == null)?"<null>":this.uid));
        sb.append(',');
        sb.append("website");
        sb.append('=');
        sb.append(((this.website == null)?"<null>":this.website));
        sb.append(',');
        sb.append("telephoneNumber");
        sb.append('=');
        sb.append(((this.telephoneNumber == null)?"<null>":this.telephoneNumber));
        sb.append(',');
        sb.append("faxNumber");
        sb.append('=');
        sb.append(((this.faxNumber == null)?"<null>":this.faxNumber));
        sb.append(',');
        sb.append("registeredAddress");
        sb.append('=');
        sb.append(((this.registeredAddress == null)?"<null>":this.registeredAddress));
        sb.append(',');
        sb.append("headquartersAddress");
        sb.append('=');
        sb.append(((this.headquartersAddress == null)?"<null>":this.headquartersAddress));
        sb.append(',');
        sb.append("mailingAddress");
        sb.append('=');
        sb.append(((this.mailingAddress == null)?"<null>":this.mailingAddress));
        sb.append(',');
        sb.append("addresses");
        sb.append('=');
        sb.append(((this.addresses == null)?"<null>":this.addresses));
        sb.append(',');
        sb.append("identifiers");
        sb.append('=');
        sb.append(((this.identifiers == null)?"<null>":this.identifiers));
        sb.append(',');
        sb.append("industryCodes");
        sb.append('=');
        sb.append(((this.industryCodes == null)?"<null>":this.industryCodes));
        sb.append(',');
        sb.append("previousNames");
        sb.append('=');
        sb.append(((this.previousNames == null)?"<null>":this.previousNames));
        sb.append(',');
        sb.append("alternativeNames");
        sb.append('=');
        sb.append(((this.alternativeNames == null)?"<null>":this.alternativeNames));
        sb.append(',');
        sb.append("otherAttributes");
        sb.append('=');
        sb.append(((this.otherAttributes == null)?"<null>":this.otherAttributes));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.website == null)? 0 :this.website.hashCode()));
        result = ((result* 31)+((this.addresses == null)? 0 :this.addresses.hashCode()));
        result = ((result* 31)+((this.telephoneNumber == null)? 0 :this.telephoneNumber.hashCode()));
        result = ((result* 31)+((this.identifiers == null)? 0 :this.identifiers.hashCode()));
        result = ((result* 31)+((this.jurisdiction == null)? 0 :this.jurisdiction.hashCode()));
        result = ((result* 31)+((this.headquartersAddress == null)? 0 :this.headquartersAddress.hashCode()));
        result = ((result* 31)+((this.industryCodes == null)? 0 :this.industryCodes.hashCode()));
        result = ((result* 31)+((this.otherAttributes == null)? 0 :this.otherAttributes.hashCode()));
        result = ((result* 31)+((this.uid == null)? 0 :this.uid.hashCode()));
        result = ((result* 31)+((this.alternativeNames == null)? 0 :this.alternativeNames.hashCode()));
        result = ((result* 31)+((this.registeredAddress == null)? 0 :this.registeredAddress.hashCode()));
        result = ((result* 31)+((this.mailingAddress == null)? 0 :this.mailingAddress.hashCode()));
        result = ((result* 31)+((this.previousNames == null)? 0 :this.previousNames.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.faxNumber == null)? 0 :this.faxNumber.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OCUnknownEntityType) == false) {
            return false;
        }
        OCUnknownEntityType rhs = ((OCUnknownEntityType) other);
        return ((((((((((((((((this.website == rhs.website)||((this.website!= null)&&this.website.equals(rhs.website)))&&((this.addresses == rhs.addresses)||((this.addresses!= null)&&this.addresses.equals(rhs.addresses))))&&((this.telephoneNumber == rhs.telephoneNumber)||((this.telephoneNumber!= null)&&this.telephoneNumber.equals(rhs.telephoneNumber))))&&((this.identifiers == rhs.identifiers)||((this.identifiers!= null)&&this.identifiers.equals(rhs.identifiers))))&&((this.jurisdiction == rhs.jurisdiction)||((this.jurisdiction!= null)&&this.jurisdiction.equals(rhs.jurisdiction))))&&((this.headquartersAddress == rhs.headquartersAddress)||((this.headquartersAddress!= null)&&this.headquartersAddress.equals(rhs.headquartersAddress))))&&((this.industryCodes == rhs.industryCodes)||((this.industryCodes!= null)&&this.industryCodes.equals(rhs.industryCodes))))&&((this.otherAttributes == rhs.otherAttributes)||((this.otherAttributes!= null)&&this.otherAttributes.equals(rhs.otherAttributes))))&&((this.uid == rhs.uid)||((this.uid!= null)&&this.uid.equals(rhs.uid))))&&((this.alternativeNames == rhs.alternativeNames)||((this.alternativeNames!= null)&&this.alternativeNames.equals(rhs.alternativeNames))))&&((this.registeredAddress == rhs.registeredAddress)||((this.registeredAddress!= null)&&this.registeredAddress.equals(rhs.registeredAddress))))&&((this.mailingAddress == rhs.mailingAddress)||((this.mailingAddress!= null)&&this.mailingAddress.equals(rhs.mailingAddress))))&&((this.previousNames == rhs.previousNames)||((this.previousNames!= null)&&this.previousNames.equals(rhs.previousNames))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.faxNumber == rhs.faxNumber)||((this.faxNumber!= null)&&this.faxNumber.equals(rhs.faxNumber))));
    }

}
