/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.opencorporates.schemas.OCEntity;
import com.opencorporates.schemas.OCOtherAttributes__2;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"subject_entity", "control_level", "ultimate_beneficial_owner", "controlling_entities", "control_mechanisms", "no_controlling_entities_reasons", "uid", "url", "source_url", "confidence", "start_date", "start_date_type", "end_date", "end_date_type", "retrieved_at", "sample_date", "other_attributes"})
public class OCControlStatementSchema {
    @JsonProperty(value="subject_entity")
    @Valid
    @NotNull
    private OCEntity subjectEntity;
    @JsonProperty(value="control_level")
    @JsonPropertyDescription(value="The level of control, i.e. whether the control is direct (i.e. there are no intermediaries), indirect (there are intermediaries) or unknown. It can be null in the case where a company is saying that there are no controlling entities")
    @NotNull
    private ControlLevel controlLevel;
    @JsonProperty(value="ultimate_beneficial_owner")
    @JsonPropertyDescription(value="Whether the controlling entities are the ultimate beneficial owners (i.e. individuals who ultimately control the company)")
    private Boolean ultimateBeneficialOwner;
    @JsonProperty(value="controlling_entities")
    @Valid
    private List<OCEntity> controllingEntities = new ArrayList<OCEntity>();
    @JsonProperty(value="control_mechanisms")
    @JsonPropertyDescription(value="The mechanism(s) by which the controlling party/parties control the company")
    @Valid
    private List<Object> controlMechanisms = new ArrayList<Object>();
    @JsonProperty(value="no_controlling_entities_reasons")
    @JsonPropertyDescription(value="The reason why no controlling entities are declared, for example because the entity has been unable to discover them, or there are no controlling entities (e.g. 100 people owned 1% each), or the companies is exempt from reporting (as some listed companies are in some jurisdictions)")
    @Valid
    private List<String> noControllingEntitiesReasons = new ArrayList<String>();
    @JsonProperty(value="uid")
    @JsonPropertyDescription(value="Unique id/reference for the control relationship entity record if the external source has given it one")
    private String uid;
    @JsonProperty(value="url")
    @JsonPropertyDescription(value="Persistent URL on the external source for the control relationship entity record, if there is one")
    private String url;
    @JsonProperty(value="source_url")
    @JsonPropertyDescription(value="Source url of the web page for the filing or if there is not persistent URL the page from which it can be found (e.g. search page). This field is required.")
    @Size(min=11)
    @NotNull
    private @Size(min=11) @NotNull String sourceUrl;
    @JsonProperty(value="confidence")
    @JsonPropertyDescription(value="Confidence in accuracy of data")
    @NotNull
    private Confidence confidence;
    @JsonProperty(value="start_date")
    @JsonPropertyDescription(value="Date on which control started")
    private LocalDate startDate;
    @JsonProperty(value="start_date_type")
    private StartDateType startDateType;
    @JsonProperty(value="end_date")
    @JsonPropertyDescription(value="Date on which control ended")
    private LocalDate endDate;
    @JsonProperty(value="end_date_type")
    private EndDateType endDateType;
    @JsonProperty(value="retrieved_at")
    @JsonPropertyDescription(value="Date-time this was retrieved from the source")
    @NotNull
    private OffsetDateTime retrievedAt;
    @JsonProperty(value="sample_date")
    @JsonPropertyDescription(value="Date on which we know this to be true (for example the date the control statement was published)")
    @NotNull
    private LocalDate sampleDate;
    @JsonProperty(value="other_attributes")
    @JsonPropertyDescription(value="Use for other attributes for which we don't yet have curated schema attributes")
    @Valid
    private OCOtherAttributes__2 otherAttributes;

    @JsonProperty(value="subject_entity")
    public OCEntity getSubjectEntity() {
        return this.subjectEntity;
    }

    @JsonProperty(value="subject_entity")
    public void setSubjectEntity(OCEntity subjectEntity) {
        this.subjectEntity = subjectEntity;
    }

    @JsonProperty(value="control_level")
    public ControlLevel getControlLevel() {
        return this.controlLevel;
    }

    @JsonProperty(value="control_level")
    public void setControlLevel(ControlLevel controlLevel) {
        this.controlLevel = controlLevel;
    }

    @JsonProperty(value="ultimate_beneficial_owner")
    public Boolean getUltimateBeneficialOwner() {
        return this.ultimateBeneficialOwner;
    }

    @JsonProperty(value="ultimate_beneficial_owner")
    public void setUltimateBeneficialOwner(Boolean ultimateBeneficialOwner) {
        this.ultimateBeneficialOwner = ultimateBeneficialOwner;
    }

    @JsonProperty(value="controlling_entities")
    public List<OCEntity> getControllingEntities() {
        return this.controllingEntities;
    }

    @JsonProperty(value="controlling_entities")
    public void setControllingEntities(List<OCEntity> controllingEntities) {
        this.controllingEntities = controllingEntities;
    }

    @JsonProperty(value="control_mechanisms")
    public List<Object> getControlMechanisms() {
        return this.controlMechanisms;
    }

    @JsonProperty(value="control_mechanisms")
    public void setControlMechanisms(List<Object> controlMechanisms) {
        this.controlMechanisms = controlMechanisms;
    }

    @JsonProperty(value="no_controlling_entities_reasons")
    public List<String> getNoControllingEntitiesReasons() {
        return this.noControllingEntitiesReasons;
    }

    @JsonProperty(value="no_controlling_entities_reasons")
    public void setNoControllingEntitiesReasons(List<String> noControllingEntitiesReasons) {
        this.noControllingEntitiesReasons = noControllingEntitiesReasons;
    }

    @JsonProperty(value="uid")
    public String getUid() {
        return this.uid;
    }

    @JsonProperty(value="uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty(value="source_url")
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="source_url")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    @JsonProperty(value="confidence")
    public Confidence getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="confidence")
    public void setConfidence(Confidence confidence) {
        this.confidence = confidence;
    }

    @JsonProperty(value="start_date")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="start_date")
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    @JsonProperty(value="start_date_type")
    public StartDateType getStartDateType() {
        return this.startDateType;
    }

    @JsonProperty(value="start_date_type")
    public void setStartDateType(StartDateType startDateType) {
        this.startDateType = startDateType;
    }

    @JsonProperty(value="end_date")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="end_date")
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    @JsonProperty(value="end_date_type")
    public EndDateType getEndDateType() {
        return this.endDateType;
    }

    @JsonProperty(value="end_date_type")
    public void setEndDateType(EndDateType endDateType) {
        this.endDateType = endDateType;
    }

    @JsonProperty(value="retrieved_at")
    public OffsetDateTime getRetrievedAt() {
        return this.retrievedAt;
    }

    @JsonProperty(value="retrieved_at")
    public void setRetrievedAt(OffsetDateTime retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    @JsonProperty(value="sample_date")
    public LocalDate getSampleDate() {
        return this.sampleDate;
    }

    @JsonProperty(value="sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    @JsonProperty(value="other_attributes")
    public OCOtherAttributes__2 getOtherAttributes() {
        return this.otherAttributes;
    }

    @JsonProperty(value="other_attributes")
    public void setOtherAttributes(OCOtherAttributes__2 otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCControlStatementSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("subjectEntity");
        sb.append('=');
        sb.append(this.subjectEntity == null ? "<null>" : this.subjectEntity);
        sb.append(',');
        sb.append("controlLevel");
        sb.append('=');
        sb.append(this.controlLevel == null ? "<null>" : this.controlLevel);
        sb.append(',');
        sb.append("ultimateBeneficialOwner");
        sb.append('=');
        sb.append(this.ultimateBeneficialOwner == null ? "<null>" : this.ultimateBeneficialOwner);
        sb.append(',');
        sb.append("controllingEntities");
        sb.append('=');
        sb.append(this.controllingEntities == null ? "<null>" : this.controllingEntities);
        sb.append(',');
        sb.append("controlMechanisms");
        sb.append('=');
        sb.append(this.controlMechanisms == null ? "<null>" : this.controlMechanisms);
        sb.append(',');
        sb.append("noControllingEntitiesReasons");
        sb.append('=');
        sb.append(this.noControllingEntitiesReasons == null ? "<null>" : this.noControllingEntitiesReasons);
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(this.uid == null ? "<null>" : this.uid);
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(this.url == null ? "<null>" : this.url);
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(this.sourceUrl == null ? "<null>" : this.sourceUrl);
        sb.append(',');
        sb.append("confidence");
        sb.append('=');
        sb.append(this.confidence == null ? "<null>" : this.confidence);
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(this.startDate == null ? "<null>" : this.startDate);
        sb.append(',');
        sb.append("startDateType");
        sb.append('=');
        sb.append(this.startDateType == null ? "<null>" : this.startDateType);
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(this.endDate == null ? "<null>" : this.endDate);
        sb.append(',');
        sb.append("endDateType");
        sb.append('=');
        sb.append(this.endDateType == null ? "<null>" : this.endDateType);
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(this.retrievedAt == null ? "<null>" : this.retrievedAt);
        sb.append(',');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(this.sampleDate == null ? "<null>" : this.sampleDate);
        sb.append(',');
        sb.append("otherAttributes");
        sb.append('=');
        sb.append(this.otherAttributes == null ? "<null>" : this.otherAttributes);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.subjectEntity == null ? 0 : this.subjectEntity.hashCode());
        result = result * 31 + (this.startDateType == null ? 0 : this.startDateType.hashCode());
        result = result * 31 + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = result * 31 + (this.confidence == null ? 0 : this.confidence.hashCode());
        result = result * 31 + (this.ultimateBeneficialOwner == null ? 0 : this.ultimateBeneficialOwner.hashCode());
        result = result * 31 + (this.noControllingEntitiesReasons == null ? 0 : this.noControllingEntitiesReasons.hashCode());
        result = result * 31 + (this.otherAttributes == null ? 0 : this.otherAttributes.hashCode());
        result = result * 31 + (this.url == null ? 0 : this.url.hashCode());
        result = result * 31 + (this.sourceUrl == null ? 0 : this.sourceUrl.hashCode());
        result = result * 31 + (this.uid == null ? 0 : this.uid.hashCode());
        result = result * 31 + (this.controllingEntities == null ? 0 : this.controllingEntities.hashCode());
        result = result * 31 + (this.retrievedAt == null ? 0 : this.retrievedAt.hashCode());
        result = result * 31 + (this.controlLevel == null ? 0 : this.controlLevel.hashCode());
        result = result * 31 + (this.sampleDate == null ? 0 : this.sampleDate.hashCode());
        result = result * 31 + (this.endDateType == null ? 0 : this.endDateType.hashCode());
        result = result * 31 + (this.controlMechanisms == null ? 0 : this.controlMechanisms.hashCode());
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCControlStatementSchema)) {
            return false;
        }
        OCControlStatementSchema rhs = (OCControlStatementSchema)other;
        return (this.subjectEntity == rhs.subjectEntity || this.subjectEntity != null && this.subjectEntity.equals(rhs.subjectEntity)) && (this.startDateType == rhs.startDateType || this.startDateType != null && this.startDateType.equals((Object)rhs.startDateType)) && (this.endDate == rhs.endDate || this.endDate != null && this.endDate.equals(rhs.endDate)) && (this.confidence == rhs.confidence || this.confidence != null && this.confidence.equals((Object)rhs.confidence)) && (this.ultimateBeneficialOwner == rhs.ultimateBeneficialOwner || this.ultimateBeneficialOwner != null && this.ultimateBeneficialOwner.equals(rhs.ultimateBeneficialOwner)) && (this.noControllingEntitiesReasons == rhs.noControllingEntitiesReasons || this.noControllingEntitiesReasons != null && this.noControllingEntitiesReasons.equals(rhs.noControllingEntitiesReasons)) && (this.otherAttributes == rhs.otherAttributes || this.otherAttributes != null && this.otherAttributes.equals(rhs.otherAttributes)) && (this.url == rhs.url || this.url != null && this.url.equals(rhs.url)) && (this.sourceUrl == rhs.sourceUrl || this.sourceUrl != null && this.sourceUrl.equals(rhs.sourceUrl)) && (this.uid == rhs.uid || this.uid != null && this.uid.equals(rhs.uid)) && (this.controllingEntities == rhs.controllingEntities || this.controllingEntities != null && this.controllingEntities.equals(rhs.controllingEntities)) && (this.retrievedAt == rhs.retrievedAt || this.retrievedAt != null && this.retrievedAt.equals(rhs.retrievedAt)) && (this.controlLevel == rhs.controlLevel || this.controlLevel != null && this.controlLevel.equals((Object)rhs.controlLevel)) && (this.sampleDate == rhs.sampleDate || this.sampleDate != null && this.sampleDate.equals(rhs.sampleDate)) && (this.endDateType == rhs.endDateType || this.endDateType != null && this.endDateType.equals((Object)rhs.endDateType)) && (this.controlMechanisms == rhs.controlMechanisms || this.controlMechanisms != null && this.controlMechanisms.equals(rhs.controlMechanisms)) && (this.startDate == rhs.startDate || this.startDate != null && this.startDate.equals(rhs.startDate));
    }

    public static enum StartDateType {
        AT("at"),
        BEFORE("before"),
        AFTER("after");

        private final String value;
        private static final Map<String, StartDateType> CONSTANTS;

        private StartDateType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static StartDateType fromValue(String value) {
            StartDateType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, StartDateType>();
            for (StartDateType c : StartDateType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum EndDateType {
        AT("at"),
        BEFORE("before"),
        AFTER("after");

        private final String value;
        private static final Map<String, EndDateType> CONSTANTS;

        private EndDateType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static EndDateType fromValue(String value) {
            EndDateType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, EndDateType>();
            for (EndDateType c : EndDateType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ControlLevel {
        DIRECT("direct"),
        INDIRECT("indirect"),
        UNKNOWN("unknown");

        private final String value;
        private static final Map<String, ControlLevel> CONSTANTS;

        private ControlLevel(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ControlLevel fromValue(String value) {
            ControlLevel constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ControlLevel>();
            for (ControlLevel c : ControlLevel.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Confidence {
        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");

        private final String value;
        private static final Map<String, Confidence> CONSTANTS;

        private Confidence(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Confidence fromValue(String value) {
            Confidence constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Confidence>();
            for (Confidence c : Confidence.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

