/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.opencorporates.schemas.OCPublication;
import java.net.URI;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"publication", "identifier", "title", "edition_id", "page_range", "url", "media_type"})
public class OCIssue__1 {
    @JsonProperty(value="publication")
    @JsonPropertyDescription(value="A gazette")
    @Valid
    @NotNull
    private OCPublication publication;
    @JsonProperty(value="identifier")
    @JsonPropertyDescription(value="The identifier of the issue")
    private String identifier;
    @JsonProperty(value="title")
    @JsonPropertyDescription(value="The title of the issue")
    private String title;
    @JsonProperty(value="edition_id")
    @JsonPropertyDescription(value="The identifier of the edition of which the issue is a part")
    private String editionId;
    @JsonProperty(value="page_range")
    @JsonPropertyDescription(value="The page range of the issue within the edition")
    @Pattern(regexp="^[0-9]*(-[0-9]*)?$")
    private @Pattern(regexp="^[0-9]*(-[0-9]*)?$") String pageRange;
    @JsonProperty(value="url")
    @JsonPropertyDescription(value="The URL of the issue")
    private URI url;
    @JsonProperty(value="media_type")
    @JsonPropertyDescription(value="The media type of the URL resource")
    private String mediaType;

    @JsonProperty(value="publication")
    public OCPublication getPublication() {
        return this.publication;
    }

    @JsonProperty(value="publication")
    public void setPublication(OCPublication publication) {
        this.publication = publication;
    }

    @JsonProperty(value="identifier")
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="edition_id")
    public String getEditionId() {
        return this.editionId;
    }

    @JsonProperty(value="edition_id")
    public void setEditionId(String editionId) {
        this.editionId = editionId;
    }

    @JsonProperty(value="page_range")
    public String getPageRange() {
        return this.pageRange;
    }

    @JsonProperty(value="page_range")
    public void setPageRange(String pageRange) {
        this.pageRange = pageRange;
    }

    @JsonProperty(value="url")
    public URI getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(URI url) {
        this.url = url;
    }

    @JsonProperty(value="media_type")
    public String getMediaType() {
        return this.mediaType;
    }

    @JsonProperty(value="media_type")
    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCIssue__1.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("publication");
        sb.append('=');
        sb.append(this.publication == null ? "<null>" : this.publication);
        sb.append(',');
        sb.append("identifier");
        sb.append('=');
        sb.append(this.identifier == null ? "<null>" : this.identifier);
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(this.title == null ? "<null>" : this.title);
        sb.append(',');
        sb.append("editionId");
        sb.append('=');
        sb.append(this.editionId == null ? "<null>" : this.editionId);
        sb.append(',');
        sb.append("pageRange");
        sb.append('=');
        sb.append(this.pageRange == null ? "<null>" : this.pageRange);
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(this.url == null ? "<null>" : this.url);
        sb.append(',');
        sb.append("mediaType");
        sb.append('=');
        sb.append(this.mediaType == null ? "<null>" : this.mediaType);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = result * 31 + (this.pageRange == null ? 0 : this.pageRange.hashCode());
        result = result * 31 + (this.publication == null ? 0 : this.publication.hashCode());
        result = result * 31 + (this.editionId == null ? 0 : this.editionId.hashCode());
        result = result * 31 + (this.mediaType == null ? 0 : this.mediaType.hashCode());
        result = result * 31 + (this.title == null ? 0 : this.title.hashCode());
        result = result * 31 + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCIssue__1)) {
            return false;
        }
        OCIssue__1 rhs = (OCIssue__1)other;
        return (this.identifier == rhs.identifier || this.identifier != null && this.identifier.equals(rhs.identifier)) && (this.pageRange == rhs.pageRange || this.pageRange != null && this.pageRange.equals(rhs.pageRange)) && (this.publication == rhs.publication || this.publication != null && this.publication.equals(rhs.publication)) && (this.editionId == rhs.editionId || this.editionId != null && this.editionId.equals(rhs.editionId)) && (this.mediaType == rhs.mediaType || this.mediaType != null && this.mediaType.equals(rhs.mediaType)) && (this.title == rhs.title || this.title != null && this.title.equals(rhs.title)) && (this.url == rhs.url || this.url != null && this.url.equals(rhs.url));
    }
}

