/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"value", "payee_name", "currency", "date", "transaction_number", "jurisdiction", "more_details_url", "description", "expense_type", "expense_area", "entity_name", "entity_uri", "department_name", "csv_line_number"})
public class OCProperties {
    @JsonProperty(value="value")
    @JsonPropertyDescription(value="The amount transacted (e.g. 19.95)")
    @NotNull
    private String value;
    @JsonProperty(value="payee_name")
    @JsonPropertyDescription(value="The name of the payee (the entity that received the money)")
    @NotNull
    private String payeeName;
    @JsonProperty(value="currency")
    @JsonPropertyDescription(value="The currency of the payment (three letter symbol, e.g. USD, GBP, EUR)")
    @NotNull
    private String currency;
    @JsonProperty(value="date")
    @JsonPropertyDescription(value="The date on which the payment was made")
    @NotNull
    private LocalDate date;
    @JsonProperty(value="transaction_number")
    @JsonPropertyDescription(value="The unique identifier for the transaction, scoped to this bot")
    private String transactionNumber;
    @JsonProperty(value="jurisdiction")
    @JsonPropertyDescription(value="The jurisdiction of the body that made the payment, eg. UK, France, Delaware, Manchester")
    private String jurisdiction;
    @JsonProperty(value="more_details_url")
    @JsonPropertyDescription(value="A url from which more details can be seen (may be the same as the source_url)")
    private String moreDetailsUrl;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="The description of the transaction as given in the raw data")
    private String description;
    @JsonProperty(value="expense_type")
    @JsonPropertyDescription(value="The type of expense -- can be either capital, revenue (i.e. current expenditure) or null")
    private ExpenseType expenseType;
    @JsonProperty(value="expense_area")
    @JsonPropertyDescription(value="category (in words) of the expenditure")
    private String expenseArea;
    @JsonProperty(value="entity_name")
    @JsonPropertyDescription(value="The name of the government entity that made the payment, e.g. Environment Agency")
    private String entityName;
    @JsonProperty(value="entity_uri")
    @JsonPropertyDescription(value="A unique URL (ideally a dereferencable URI) for the government entity")
    private String entityUri;
    @JsonProperty(value="department_name")
    @JsonPropertyDescription(value="The name of the government department which the entity belongs to (if relevant), e.g. Department of Health")
    private String departmentName;
    @JsonProperty(value="csv_line_number")
    @JsonPropertyDescription(value="If the source for the data is a CSV file, you can optionally include the line number of the CSV from which this data was retrieved")
    private String csvLineNumber;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public void setValue(String value) {
        this.value = value;
    }

    @JsonProperty(value="payee_name")
    public String getPayeeName() {
        return this.payeeName;
    }

    @JsonProperty(value="payee_name")
    public void setPayeeName(String payeeName) {
        this.payeeName = payeeName;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @JsonProperty(value="date")
    public LocalDate getDate() {
        return this.date;
    }

    @JsonProperty(value="date")
    public void setDate(LocalDate date) {
        this.date = date;
    }

    @JsonProperty(value="transaction_number")
    public String getTransactionNumber() {
        return this.transactionNumber;
    }

    @JsonProperty(value="transaction_number")
    public void setTransactionNumber(String transactionNumber) {
        this.transactionNumber = transactionNumber;
    }

    @JsonProperty(value="jurisdiction")
    public String getJurisdiction() {
        return this.jurisdiction;
    }

    @JsonProperty(value="jurisdiction")
    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    @JsonProperty(value="more_details_url")
    public String getMoreDetailsUrl() {
        return this.moreDetailsUrl;
    }

    @JsonProperty(value="more_details_url")
    public void setMoreDetailsUrl(String moreDetailsUrl) {
        this.moreDetailsUrl = moreDetailsUrl;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="expense_type")
    public ExpenseType getExpenseType() {
        return this.expenseType;
    }

    @JsonProperty(value="expense_type")
    public void setExpenseType(ExpenseType expenseType) {
        this.expenseType = expenseType;
    }

    @JsonProperty(value="expense_area")
    public String getExpenseArea() {
        return this.expenseArea;
    }

    @JsonProperty(value="expense_area")
    public void setExpenseArea(String expenseArea) {
        this.expenseArea = expenseArea;
    }

    @JsonProperty(value="entity_name")
    public String getEntityName() {
        return this.entityName;
    }

    @JsonProperty(value="entity_name")
    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    @JsonProperty(value="entity_uri")
    public String getEntityUri() {
        return this.entityUri;
    }

    @JsonProperty(value="entity_uri")
    public void setEntityUri(String entityUri) {
        this.entityUri = entityUri;
    }

    @JsonProperty(value="department_name")
    public String getDepartmentName() {
        return this.departmentName;
    }

    @JsonProperty(value="department_name")
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    @JsonProperty(value="csv_line_number")
    public String getCsvLineNumber() {
        return this.csvLineNumber;
    }

    @JsonProperty(value="csv_line_number")
    public void setCsvLineNumber(String csvLineNumber) {
        this.csvLineNumber = csvLineNumber;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCProperties.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("value");
        sb.append('=');
        sb.append(this.value == null ? "<null>" : this.value);
        sb.append(',');
        sb.append("payeeName");
        sb.append('=');
        sb.append(this.payeeName == null ? "<null>" : this.payeeName);
        sb.append(',');
        sb.append("currency");
        sb.append('=');
        sb.append(this.currency == null ? "<null>" : this.currency);
        sb.append(',');
        sb.append("date");
        sb.append('=');
        sb.append(this.date == null ? "<null>" : this.date);
        sb.append(',');
        sb.append("transactionNumber");
        sb.append('=');
        sb.append(this.transactionNumber == null ? "<null>" : this.transactionNumber);
        sb.append(',');
        sb.append("jurisdiction");
        sb.append('=');
        sb.append(this.jurisdiction == null ? "<null>" : this.jurisdiction);
        sb.append(',');
        sb.append("moreDetailsUrl");
        sb.append('=');
        sb.append(this.moreDetailsUrl == null ? "<null>" : this.moreDetailsUrl);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("expenseType");
        sb.append('=');
        sb.append(this.expenseType == null ? "<null>" : this.expenseType);
        sb.append(',');
        sb.append("expenseArea");
        sb.append('=');
        sb.append(this.expenseArea == null ? "<null>" : this.expenseArea);
        sb.append(',');
        sb.append("entityName");
        sb.append('=');
        sb.append(this.entityName == null ? "<null>" : this.entityName);
        sb.append(',');
        sb.append("entityUri");
        sb.append('=');
        sb.append(this.entityUri == null ? "<null>" : this.entityUri);
        sb.append(',');
        sb.append("departmentName");
        sb.append('=');
        sb.append(this.departmentName == null ? "<null>" : this.departmentName);
        sb.append(',');
        sb.append("csvLineNumber");
        sb.append('=');
        sb.append(this.csvLineNumber == null ? "<null>" : this.csvLineNumber);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.date == null ? 0 : this.date.hashCode());
        result = result * 31 + (this.departmentName == null ? 0 : this.departmentName.hashCode());
        result = result * 31 + (this.expenseType == null ? 0 : this.expenseType.hashCode());
        result = result * 31 + (this.transactionNumber == null ? 0 : this.transactionNumber.hashCode());
        result = result * 31 + (this.jurisdiction == null ? 0 : this.jurisdiction.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.moreDetailsUrl == null ? 0 : this.moreDetailsUrl.hashCode());
        result = result * 31 + (this.expenseArea == null ? 0 : this.expenseArea.hashCode());
        result = result * 31 + (this.payeeName == null ? 0 : this.payeeName.hashCode());
        result = result * 31 + (this.entityUri == null ? 0 : this.entityUri.hashCode());
        result = result * 31 + (this.csvLineNumber == null ? 0 : this.csvLineNumber.hashCode());
        result = result * 31 + (this.entityName == null ? 0 : this.entityName.hashCode());
        result = result * 31 + (this.currency == null ? 0 : this.currency.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCProperties)) {
            return false;
        }
        OCProperties rhs = (OCProperties)other;
        return (this.date == rhs.date || this.date != null && this.date.equals(rhs.date)) && (this.departmentName == rhs.departmentName || this.departmentName != null && this.departmentName.equals(rhs.departmentName)) && (this.expenseType == rhs.expenseType || this.expenseType != null && this.expenseType.equals((Object)rhs.expenseType)) && (this.transactionNumber == rhs.transactionNumber || this.transactionNumber != null && this.transactionNumber.equals(rhs.transactionNumber)) && (this.jurisdiction == rhs.jurisdiction || this.jurisdiction != null && this.jurisdiction.equals(rhs.jurisdiction)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.moreDetailsUrl == rhs.moreDetailsUrl || this.moreDetailsUrl != null && this.moreDetailsUrl.equals(rhs.moreDetailsUrl)) && (this.expenseArea == rhs.expenseArea || this.expenseArea != null && this.expenseArea.equals(rhs.expenseArea)) && (this.payeeName == rhs.payeeName || this.payeeName != null && this.payeeName.equals(rhs.payeeName)) && (this.entityUri == rhs.entityUri || this.entityUri != null && this.entityUri.equals(rhs.entityUri)) && (this.csvLineNumber == rhs.csvLineNumber || this.csvLineNumber != null && this.csvLineNumber.equals(rhs.csvLineNumber)) && (this.entityName == rhs.entityName || this.entityName != null && this.entityName.equals(rhs.entityName)) && (this.currency == rhs.currency || this.currency != null && this.currency.equals(rhs.currency)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.value == rhs.value || this.value != null && this.value.equals(rhs.value));
    }

    public static enum ExpenseType {
        CAPITAL("capital"),
        REVENUE("revenue");

        private final String value;
        private static final Map<String, ExpenseType> CONSTANTS;

        private ExpenseType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ExpenseType fromValue(String value) {
            ExpenseType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ExpenseType>();
            for (ExpenseType c : ExpenseType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

