/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.opencorporates.schemas.OCEntity;
import com.opencorporates.schemas.OCOtherAttributes__6;
import com.opencorporates.schemas.OCRegister;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"subject_entity", "register", "identifier", "identifier_system_code", "start_date", "end_date", "source_url", "register_url", "confidence", "sample_date", "retrieved_at", "status", "category", "other_attributes"})
public class OCRegisterEntrySchema {
    @JsonProperty(value="subject_entity")
    @Valid
    @NotNull
    private OCEntity subjectEntity;
    @JsonProperty(value="register")
    @JsonPropertyDescription(value="The official register of which this entry is a part")
    @Valid
    @NotNull
    private OCRegister register;
    @JsonProperty(value="identifier")
    @JsonPropertyDescription(value="A unique identifier used by the register to identifier the register entry. In some cases \u2013 e.g. Charity Register for England & Wales, these identifiers (in this case known as the 'charity number') are used outside of the context of the register")
    private String identifier;
    @JsonProperty(value="identifier_system_code")
    @JsonPropertyDescription(value="A code representing the identifier scheme. Some examples of this are us_fein (US Federal tax number), us_sec_cik (US Securities and Exchange Commission CIK), uk_ew_cc (Charity Commission of England & Wales), lei (Global Legal Entity Identifier System). Not all registers have identifier_systems, and some registers may use identifiers from other identifiers systems (e.g. the EBA is planning on using LEI in its bank register)")
    private String identifierSystemCode;
    @JsonProperty(value="start_date")
    @JsonPropertyDescription(value="The date the register entry started, e.g. the date the entity was registered from, or appeared on the register the first time")
    private LocalDate startDate;
    @JsonProperty(value="end_date")
    @JsonPropertyDescription(value="The date the register entry ended, e.g. the date the charity was deregistered from")
    private LocalDate endDate;
    @JsonProperty(value="source_url")
    @JsonPropertyDescription(value="Source of the data \u2013 this may be the url of the entity on the register, the URL of an open data dump, or if there is no permanent URLs, the main URL for the register")
    @Size(min=8)
    @NotNull
    private @Size(min=8) @NotNull String sourceUrl;
    @JsonProperty(value="register_url")
    @JsonPropertyDescription(value="URL of the entity on the register, if there is a permanent URL")
    @Size(min=8)
    private @Size(min=8) String registerUrl;
    @JsonProperty(value="confidence")
    @JsonPropertyDescription(value="Confidence in accuracy of data")
    private Confidence confidence;
    @JsonProperty(value="sample_date")
    @JsonPropertyDescription(value="Date on which we know this to be true (usually date this information was retrieved from the source)")
    @NotNull
    private LocalDate sampleDate;
    @JsonProperty(value="retrieved_at")
    @JsonPropertyDescription(value="The time or date at which the source URL was requested")
    @NotNull
    private LocalDate retrievedAt;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="The status of the register entry")
    private String status;
    @JsonProperty(value="category")
    @JsonPropertyDescription(value="Category of register entry (NB some registers may have more than one type of entry, so we record at the register entry level, rather than the register level)")
    @NotNull
    private Category category;
    @JsonProperty(value="other_attributes")
    @JsonPropertyDescription(value="Use for other licence attributes for which we don't yet have curated schema attributes")
    @Valid
    private OCOtherAttributes__6 otherAttributes;

    @JsonProperty(value="subject_entity")
    public OCEntity getSubjectEntity() {
        return this.subjectEntity;
    }

    @JsonProperty(value="subject_entity")
    public void setSubjectEntity(OCEntity subjectEntity) {
        this.subjectEntity = subjectEntity;
    }

    @JsonProperty(value="register")
    public OCRegister getRegister() {
        return this.register;
    }

    @JsonProperty(value="register")
    public void setRegister(OCRegister register) {
        this.register = register;
    }

    @JsonProperty(value="identifier")
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @JsonProperty(value="identifier_system_code")
    public String getIdentifierSystemCode() {
        return this.identifierSystemCode;
    }

    @JsonProperty(value="identifier_system_code")
    public void setIdentifierSystemCode(String identifierSystemCode) {
        this.identifierSystemCode = identifierSystemCode;
    }

    @JsonProperty(value="start_date")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="start_date")
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    @JsonProperty(value="end_date")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="end_date")
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    @JsonProperty(value="source_url")
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="source_url")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    @JsonProperty(value="register_url")
    public String getRegisterUrl() {
        return this.registerUrl;
    }

    @JsonProperty(value="register_url")
    public void setRegisterUrl(String registerUrl) {
        this.registerUrl = registerUrl;
    }

    @JsonProperty(value="confidence")
    public Confidence getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="confidence")
    public void setConfidence(Confidence confidence) {
        this.confidence = confidence;
    }

    @JsonProperty(value="sample_date")
    public LocalDate getSampleDate() {
        return this.sampleDate;
    }

    @JsonProperty(value="sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    @JsonProperty(value="retrieved_at")
    public LocalDate getRetrievedAt() {
        return this.retrievedAt;
    }

    @JsonProperty(value="retrieved_at")
    public void setRetrievedAt(LocalDate retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty(value="category")
    public Category getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    public void setCategory(Category category) {
        this.category = category;
    }

    @JsonProperty(value="other_attributes")
    public OCOtherAttributes__6 getOtherAttributes() {
        return this.otherAttributes;
    }

    @JsonProperty(value="other_attributes")
    public void setOtherAttributes(OCOtherAttributes__6 otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCRegisterEntrySchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("subjectEntity");
        sb.append('=');
        sb.append(this.subjectEntity == null ? "<null>" : this.subjectEntity);
        sb.append(',');
        sb.append("register");
        sb.append('=');
        sb.append(this.register == null ? "<null>" : this.register);
        sb.append(',');
        sb.append("identifier");
        sb.append('=');
        sb.append(this.identifier == null ? "<null>" : this.identifier);
        sb.append(',');
        sb.append("identifierSystemCode");
        sb.append('=');
        sb.append(this.identifierSystemCode == null ? "<null>" : this.identifierSystemCode);
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(this.startDate == null ? "<null>" : this.startDate);
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(this.endDate == null ? "<null>" : this.endDate);
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(this.sourceUrl == null ? "<null>" : this.sourceUrl);
        sb.append(',');
        sb.append("registerUrl");
        sb.append('=');
        sb.append(this.registerUrl == null ? "<null>" : this.registerUrl);
        sb.append(',');
        sb.append("confidence");
        sb.append('=');
        sb.append(this.confidence == null ? "<null>" : this.confidence);
        sb.append(',');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(this.sampleDate == null ? "<null>" : this.sampleDate);
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(this.retrievedAt == null ? "<null>" : this.retrievedAt);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("category");
        sb.append('=');
        sb.append(this.category == null ? "<null>" : this.category);
        sb.append(',');
        sb.append("otherAttributes");
        sb.append('=');
        sb.append(this.otherAttributes == null ? "<null>" : this.otherAttributes);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = result * 31 + (this.subjectEntity == null ? 0 : this.subjectEntity.hashCode());
        result = result * 31 + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = result * 31 + (this.confidence == null ? 0 : this.confidence.hashCode());
        result = result * 31 + (this.otherAttributes == null ? 0 : this.otherAttributes.hashCode());
        result = result * 31 + (this.sourceUrl == null ? 0 : this.sourceUrl.hashCode());
        result = result * 31 + (this.identifierSystemCode == null ? 0 : this.identifierSystemCode.hashCode());
        result = result * 31 + (this.registerUrl == null ? 0 : this.registerUrl.hashCode());
        result = result * 31 + (this.retrievedAt == null ? 0 : this.retrievedAt.hashCode());
        result = result * 31 + (this.sampleDate == null ? 0 : this.sampleDate.hashCode());
        result = result * 31 + (this.category == null ? 0 : this.category.hashCode());
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = result * 31 + (this.register == null ? 0 : this.register.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCRegisterEntrySchema)) {
            return false;
        }
        OCRegisterEntrySchema rhs = (OCRegisterEntrySchema)other;
        return (this.identifier == rhs.identifier || this.identifier != null && this.identifier.equals(rhs.identifier)) && (this.subjectEntity == rhs.subjectEntity || this.subjectEntity != null && this.subjectEntity.equals(rhs.subjectEntity)) && (this.endDate == rhs.endDate || this.endDate != null && this.endDate.equals(rhs.endDate)) && (this.confidence == rhs.confidence || this.confidence != null && this.confidence.equals((Object)rhs.confidence)) && (this.otherAttributes == rhs.otherAttributes || this.otherAttributes != null && this.otherAttributes.equals(rhs.otherAttributes)) && (this.sourceUrl == rhs.sourceUrl || this.sourceUrl != null && this.sourceUrl.equals(rhs.sourceUrl)) && (this.identifierSystemCode == rhs.identifierSystemCode || this.identifierSystemCode != null && this.identifierSystemCode.equals(rhs.identifierSystemCode)) && (this.registerUrl == rhs.registerUrl || this.registerUrl != null && this.registerUrl.equals(rhs.registerUrl)) && (this.retrievedAt == rhs.retrievedAt || this.retrievedAt != null && this.retrievedAt.equals(rhs.retrievedAt)) && (this.sampleDate == rhs.sampleDate || this.sampleDate != null && this.sampleDate.equals(rhs.sampleDate)) && (this.category == rhs.category || this.category != null && this.category.equals((Object)rhs.category)) && (this.startDate == rhs.startDate || this.startDate != null && this.startDate.equals(rhs.startDate)) && (this.register == rhs.register || this.register != null && this.register.equals(rhs.register)) && (this.status == rhs.status || this.status != null && this.status.equals(rhs.status));
    }

    public static enum Confidence {
        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");

        private final String value;
        private static final Map<String, Confidence> CONSTANTS;

        private Confidence(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Confidence fromValue(String value) {
            Confidence constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Confidence>();
            for (Confidence c : Confidence.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Category {
        CHARITY_NON_PROFIT("Charity-NonProfit"),
        LOBBYING("Lobbying"),
        LEGAL_ENTITY("LegalEntity"),
        OTHER("Other");

        private final String value;
        private static final Map<String, Category> CONSTANTS;

        private Category(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Category fromValue(String value) {
            Category constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Category>();
            for (Category c : Category.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

