/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "jurisdiction", "company_number", "identifier", "type", "address", "address_country"})
public class OCShareholder {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of natural person or company")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String name;
    @JsonProperty(value="jurisdiction")
    @JsonPropertyDescription(value="Jurisdiction of registration, if company")
    private String jurisdiction;
    @JsonProperty(value="company_number")
    @JsonPropertyDescription(value="Company number, if company and known")
    private String companyNumber;
    @JsonProperty(value="identifier")
    @JsonPropertyDescription(value="Unique identifier of person")
    private String identifier;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Type of person if known (company or natural person)")
    private Type type;
    @JsonProperty(value="address")
    private Object address;
    @JsonProperty(value="address_country")
    @JsonPropertyDescription(value="Country part of owner's address (for example if address not given)")
    private String addressCountry;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="jurisdiction")
    public String getJurisdiction() {
        return this.jurisdiction;
    }

    @JsonProperty(value="jurisdiction")
    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    @JsonProperty(value="company_number")
    public String getCompanyNumber() {
        return this.companyNumber;
    }

    @JsonProperty(value="company_number")
    public void setCompanyNumber(String companyNumber) {
        this.companyNumber = companyNumber;
    }

    @JsonProperty(value="identifier")
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    @JsonProperty(value="address")
    public Object getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    public void setAddress(Object address) {
        this.address = address;
    }

    @JsonProperty(value="address_country")
    public String getAddressCountry() {
        return this.addressCountry;
    }

    @JsonProperty(value="address_country")
    public void setAddressCountry(String addressCountry) {
        this.addressCountry = addressCountry;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCShareholder.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("jurisdiction");
        sb.append('=');
        sb.append(this.jurisdiction == null ? "<null>" : this.jurisdiction);
        sb.append(',');
        sb.append("companyNumber");
        sb.append('=');
        sb.append(this.companyNumber == null ? "<null>" : this.companyNumber);
        sb.append(',');
        sb.append("identifier");
        sb.append('=');
        sb.append(this.identifier == null ? "<null>" : this.identifier);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("address");
        sb.append('=');
        sb.append(this.address == null ? "<null>" : this.address);
        sb.append(',');
        sb.append("addressCountry");
        sb.append('=');
        sb.append(this.addressCountry == null ? "<null>" : this.addressCountry);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.addressCountry == null ? 0 : this.addressCountry.hashCode());
        result = result * 31 + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = result * 31 + (this.address == null ? 0 : this.address.hashCode());
        result = result * 31 + (this.companyNumber == null ? 0 : this.companyNumber.hashCode());
        result = result * 31 + (this.jurisdiction == null ? 0 : this.jurisdiction.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCShareholder)) {
            return false;
        }
        OCShareholder rhs = (OCShareholder)other;
        return (this.addressCountry == rhs.addressCountry || this.addressCountry != null && this.addressCountry.equals(rhs.addressCountry)) && (this.identifier == rhs.identifier || this.identifier != null && this.identifier.equals(rhs.identifier)) && (this.address == rhs.address || this.address != null && this.address.equals(rhs.address)) && (this.companyNumber == rhs.companyNumber || this.companyNumber != null && this.companyNumber.equals(rhs.companyNumber)) && (this.jurisdiction == rhs.jurisdiction || this.jurisdiction != null && this.jurisdiction.equals(rhs.jurisdiction)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type));
    }

    public static enum Type {
        COMPANY("Company"),
        PERSON("Person");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

