/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.opencorporates.schemas.OCEntity;
import com.opencorporates.schemas.OCMarkDetails;
import com.opencorporates.schemas.OCOtherAttributes__8;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"register", "holders", "correspondent", "representative", "mark_details", "status", "uid", "url", "source_url", "confidence", "registration_date", "expiry_date", "start_date", "start_date_type", "retrieved_at", "sample_date", "other_attributes"})
public class OCTrademarkRegistrationSchema {
    @JsonProperty(value="register")
    @JsonPropertyDescription(value="The register on which the trademark is listed")
    @NotNull
    private String register;
    @JsonProperty(value="holders")
    @JsonPropertyDescription(value="Details of the holder(s) of the trademark (sometimes called the owners)")
    @Valid
    @NotNull
    private List<OCEntity> holders = new ArrayList<OCEntity>();
    @JsonProperty(value="correspondent")
    @Valid
    private OCEntity correspondent;
    @JsonProperty(value="representative")
    @Valid
    private OCEntity representative;
    @JsonProperty(value="mark_details")
    @JsonPropertyDescription(value="Details of the trademark itself (rather than the registration)")
    @Valid
    @NotNull
    private OCMarkDetails markDetails;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="Status of the trademark registration")
    private String status;
    @JsonProperty(value="uid")
    @JsonPropertyDescription(value="Unique id/reference for the trademark registration")
    private String uid;
    @JsonProperty(value="url")
    @JsonPropertyDescription(value="URL of trademark registration")
    private String url;
    @JsonProperty(value="source_url")
    @JsonPropertyDescription(value="Url of the source of the data (e.g. download URL), or if there is not persistent URL the page from which it can be found (e.g. search page). This field is required.")
    @Size(min=11)
    @NotNull
    private @Size(min=11) @NotNull String sourceUrl;
    @JsonProperty(value="confidence")
    @JsonPropertyDescription(value="Confidence in accuracy of data")
    @NotNull
    private Confidence confidence;
    @JsonProperty(value="registration_date")
    @JsonPropertyDescription(value="Date on which the mark was registered")
    private LocalDate registrationDate;
    @JsonProperty(value="expiry_date")
    @JsonPropertyDescription(value="Date on which the registration ended, or is scheduled to expire")
    private LocalDate expiryDate;
    @JsonProperty(value="start_date")
    @JsonPropertyDescription(value="This should be the same as registration_date")
    private LocalDate startDate;
    @JsonProperty(value="start_date_type")
    private StartDateType startDateType;
    @JsonProperty(value="retrieved_at")
    @JsonPropertyDescription(value="Date-time this was retrieved from the source")
    @NotNull
    private OffsetDateTime retrievedAt;
    @JsonProperty(value="sample_date")
    @JsonPropertyDescription(value="Date on which we know this to be true (for example the date the trademark data was retrieved if there's no explicit registration date)")
    @NotNull
    private LocalDate sampleDate;
    @JsonProperty(value="other_attributes")
    @JsonPropertyDescription(value="Use for other attributes for which we don't yet have curated schema attributes")
    @Valid
    private OCOtherAttributes__8 otherAttributes;

    @JsonProperty(value="register")
    public String getRegister() {
        return this.register;
    }

    @JsonProperty(value="register")
    public void setRegister(String register) {
        this.register = register;
    }

    @JsonProperty(value="holders")
    public List<OCEntity> getHolders() {
        return this.holders;
    }

    @JsonProperty(value="holders")
    public void setHolders(List<OCEntity> holders) {
        this.holders = holders;
    }

    @JsonProperty(value="correspondent")
    public OCEntity getCorrespondent() {
        return this.correspondent;
    }

    @JsonProperty(value="correspondent")
    public void setCorrespondent(OCEntity correspondent) {
        this.correspondent = correspondent;
    }

    @JsonProperty(value="representative")
    public OCEntity getRepresentative() {
        return this.representative;
    }

    @JsonProperty(value="representative")
    public void setRepresentative(OCEntity representative) {
        this.representative = representative;
    }

    @JsonProperty(value="mark_details")
    public OCMarkDetails getMarkDetails() {
        return this.markDetails;
    }

    @JsonProperty(value="mark_details")
    public void setMarkDetails(OCMarkDetails markDetails) {
        this.markDetails = markDetails;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty(value="uid")
    public String getUid() {
        return this.uid;
    }

    @JsonProperty(value="uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty(value="source_url")
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="source_url")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    @JsonProperty(value="confidence")
    public Confidence getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="confidence")
    public void setConfidence(Confidence confidence) {
        this.confidence = confidence;
    }

    @JsonProperty(value="registration_date")
    public LocalDate getRegistrationDate() {
        return this.registrationDate;
    }

    @JsonProperty(value="registration_date")
    public void setRegistrationDate(LocalDate registrationDate) {
        this.registrationDate = registrationDate;
    }

    @JsonProperty(value="expiry_date")
    public LocalDate getExpiryDate() {
        return this.expiryDate;
    }

    @JsonProperty(value="expiry_date")
    public void setExpiryDate(LocalDate expiryDate) {
        this.expiryDate = expiryDate;
    }

    @JsonProperty(value="start_date")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="start_date")
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    @JsonProperty(value="start_date_type")
    public StartDateType getStartDateType() {
        return this.startDateType;
    }

    @JsonProperty(value="start_date_type")
    public void setStartDateType(StartDateType startDateType) {
        this.startDateType = startDateType;
    }

    @JsonProperty(value="retrieved_at")
    public OffsetDateTime getRetrievedAt() {
        return this.retrievedAt;
    }

    @JsonProperty(value="retrieved_at")
    public void setRetrievedAt(OffsetDateTime retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    @JsonProperty(value="sample_date")
    public LocalDate getSampleDate() {
        return this.sampleDate;
    }

    @JsonProperty(value="sample_date")
    public void setSampleDate(LocalDate sampleDate) {
        this.sampleDate = sampleDate;
    }

    @JsonProperty(value="other_attributes")
    public OCOtherAttributes__8 getOtherAttributes() {
        return this.otherAttributes;
    }

    @JsonProperty(value="other_attributes")
    public void setOtherAttributes(OCOtherAttributes__8 otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCTrademarkRegistrationSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("register");
        sb.append('=');
        sb.append(this.register == null ? "<null>" : this.register);
        sb.append(',');
        sb.append("holders");
        sb.append('=');
        sb.append(this.holders == null ? "<null>" : this.holders);
        sb.append(',');
        sb.append("correspondent");
        sb.append('=');
        sb.append(this.correspondent == null ? "<null>" : this.correspondent);
        sb.append(',');
        sb.append("representative");
        sb.append('=');
        sb.append(this.representative == null ? "<null>" : this.representative);
        sb.append(',');
        sb.append("markDetails");
        sb.append('=');
        sb.append(this.markDetails == null ? "<null>" : this.markDetails);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(this.uid == null ? "<null>" : this.uid);
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(this.url == null ? "<null>" : this.url);
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(this.sourceUrl == null ? "<null>" : this.sourceUrl);
        sb.append(',');
        sb.append("confidence");
        sb.append('=');
        sb.append(this.confidence == null ? "<null>" : this.confidence);
        sb.append(',');
        sb.append("registrationDate");
        sb.append('=');
        sb.append(this.registrationDate == null ? "<null>" : this.registrationDate);
        sb.append(',');
        sb.append("expiryDate");
        sb.append('=');
        sb.append(this.expiryDate == null ? "<null>" : this.expiryDate);
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(this.startDate == null ? "<null>" : this.startDate);
        sb.append(',');
        sb.append("startDateType");
        sb.append('=');
        sb.append(this.startDateType == null ? "<null>" : this.startDateType);
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(this.retrievedAt == null ? "<null>" : this.retrievedAt);
        sb.append(',');
        sb.append("sampleDate");
        sb.append('=');
        sb.append(this.sampleDate == null ? "<null>" : this.sampleDate);
        sb.append(',');
        sb.append("otherAttributes");
        sb.append('=');
        sb.append(this.otherAttributes == null ? "<null>" : this.otherAttributes);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.startDateType == null ? 0 : this.startDateType.hashCode());
        result = result * 31 + (this.confidence == null ? 0 : this.confidence.hashCode());
        result = result * 31 + (this.markDetails == null ? 0 : this.markDetails.hashCode());
        result = result * 31 + (this.otherAttributes == null ? 0 : this.otherAttributes.hashCode());
        result = result * 31 + (this.url == null ? 0 : this.url.hashCode());
        result = result * 31 + (this.sourceUrl == null ? 0 : this.sourceUrl.hashCode());
        result = result * 31 + (this.expiryDate == null ? 0 : this.expiryDate.hashCode());
        result = result * 31 + (this.uid == null ? 0 : this.uid.hashCode());
        result = result * 31 + (this.retrievedAt == null ? 0 : this.retrievedAt.hashCode());
        result = result * 31 + (this.holders == null ? 0 : this.holders.hashCode());
        result = result * 31 + (this.registrationDate == null ? 0 : this.registrationDate.hashCode());
        result = result * 31 + (this.sampleDate == null ? 0 : this.sampleDate.hashCode());
        result = result * 31 + (this.correspondent == null ? 0 : this.correspondent.hashCode());
        result = result * 31 + (this.representative == null ? 0 : this.representative.hashCode());
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = result * 31 + (this.register == null ? 0 : this.register.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCTrademarkRegistrationSchema)) {
            return false;
        }
        OCTrademarkRegistrationSchema rhs = (OCTrademarkRegistrationSchema)other;
        return (this.startDateType == rhs.startDateType || this.startDateType != null && this.startDateType.equals((Object)rhs.startDateType)) && (this.confidence == rhs.confidence || this.confidence != null && this.confidence.equals((Object)rhs.confidence)) && (this.markDetails == rhs.markDetails || this.markDetails != null && this.markDetails.equals(rhs.markDetails)) && (this.otherAttributes == rhs.otherAttributes || this.otherAttributes != null && this.otherAttributes.equals(rhs.otherAttributes)) && (this.url == rhs.url || this.url != null && this.url.equals(rhs.url)) && (this.sourceUrl == rhs.sourceUrl || this.sourceUrl != null && this.sourceUrl.equals(rhs.sourceUrl)) && (this.expiryDate == rhs.expiryDate || this.expiryDate != null && this.expiryDate.equals(rhs.expiryDate)) && (this.uid == rhs.uid || this.uid != null && this.uid.equals(rhs.uid)) && (this.retrievedAt == rhs.retrievedAt || this.retrievedAt != null && this.retrievedAt.equals(rhs.retrievedAt)) && (this.holders == rhs.holders || this.holders != null && this.holders.equals(rhs.holders)) && (this.registrationDate == rhs.registrationDate || this.registrationDate != null && this.registrationDate.equals(rhs.registrationDate)) && (this.sampleDate == rhs.sampleDate || this.sampleDate != null && this.sampleDate.equals(rhs.sampleDate)) && (this.correspondent == rhs.correspondent || this.correspondent != null && this.correspondent.equals(rhs.correspondent)) && (this.representative == rhs.representative || this.representative != null && this.representative.equals(rhs.representative)) && (this.startDate == rhs.startDate || this.startDate != null && this.startDate.equals(rhs.startDate)) && (this.register == rhs.register || this.register != null && this.register.equals(rhs.register)) && (this.status == rhs.status || this.status != null && this.status.equals(rhs.status));
    }

    public static enum StartDateType {
        AT("at"),
        BEFORE("before"),
        AFTER("after");

        private final String value;
        private static final Map<String, StartDateType> CONSTANTS;

        private StartDateType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static StartDateType fromValue(String value) {
            StartDateType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, StartDateType>();
            for (StartDateType c : StartDateType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Confidence {
        HIGH("HIGH"),
        MEDIUM("MEDIUM"),
        LOW("LOW");

        private final String value;
        private static final Map<String, Confidence> CONSTANTS;

        private Confidence(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Confidence fromValue(String value) {
            Confidence constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Confidence>();
            for (Confidence c : Confidence.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

