/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas.includes;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.opencorporates.schemas.includes.OCMergedInto;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"jurisdiction_of_origin", "home_company_number", "home_legal_name", "registered_agent_address", "registered_agent_name", "number_of_employees", "merged_into"})
public class OCAllAttributes {
    @JsonProperty(value="jurisdiction_of_origin")
    @JsonPropertyDescription(value="The jurisdiction of the 'home' company if this is a branch")
    @Size(min=1)
    private @Size(min=1) String jurisdictionOfOrigin;
    @JsonProperty(value="home_company_number")
    @JsonPropertyDescription(value="If the entity is a 'branch', this is the company_number of the 'home' company in the home company's jurisdiction")
    @Size(min=1)
    private @Size(min=1) String homeCompanyNumber;
    @JsonProperty(value="home_legal_name")
    @JsonPropertyDescription(value="The legal name of the 'home' company in its jurisdiction if this is a branch, and the name is different from the legal name of the branch")
    @Size(min=1)
    private @Size(min=1) String homeLegalName;
    @JsonProperty(value="registered_agent_address")
    @JsonPropertyDescription(value="The address of the 'Agent', a public address to which legal papers can be served")
    @Size(min=1)
    private @Size(min=1) String registeredAgentAddress;
    @JsonProperty(value="registered_agent_name")
    @JsonPropertyDescription(value="The 'Agent' of the company \u2013 a person or entity that is empowered to accept service for the company")
    @Size(min=1)
    private @Size(min=1) String registeredAgentName;
    @JsonProperty(value="number_of_employees")
    @JsonPropertyDescription(value="The number of employees")
    private Object numberOfEmployees;
    @JsonProperty(value="merged_into")
    @JsonPropertyDescription(value="Information on the merger of this company into a 'survivor' company")
    @Valid
    private OCMergedInto mergedInto;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="jurisdiction_of_origin")
    public String getJurisdictionOfOrigin() {
        return this.jurisdictionOfOrigin;
    }

    @JsonProperty(value="jurisdiction_of_origin")
    public void setJurisdictionOfOrigin(String jurisdictionOfOrigin) {
        this.jurisdictionOfOrigin = jurisdictionOfOrigin;
    }

    @JsonProperty(value="home_company_number")
    public String getHomeCompanyNumber() {
        return this.homeCompanyNumber;
    }

    @JsonProperty(value="home_company_number")
    public void setHomeCompanyNumber(String homeCompanyNumber) {
        this.homeCompanyNumber = homeCompanyNumber;
    }

    @JsonProperty(value="home_legal_name")
    public String getHomeLegalName() {
        return this.homeLegalName;
    }

    @JsonProperty(value="home_legal_name")
    public void setHomeLegalName(String homeLegalName) {
        this.homeLegalName = homeLegalName;
    }

    @JsonProperty(value="registered_agent_address")
    public String getRegisteredAgentAddress() {
        return this.registeredAgentAddress;
    }

    @JsonProperty(value="registered_agent_address")
    public void setRegisteredAgentAddress(String registeredAgentAddress) {
        this.registeredAgentAddress = registeredAgentAddress;
    }

    @JsonProperty(value="registered_agent_name")
    public String getRegisteredAgentName() {
        return this.registeredAgentName;
    }

    @JsonProperty(value="registered_agent_name")
    public void setRegisteredAgentName(String registeredAgentName) {
        this.registeredAgentName = registeredAgentName;
    }

    @JsonProperty(value="number_of_employees")
    public Object getNumberOfEmployees() {
        return this.numberOfEmployees;
    }

    @JsonProperty(value="number_of_employees")
    public void setNumberOfEmployees(Object numberOfEmployees) {
        this.numberOfEmployees = numberOfEmployees;
    }

    @JsonProperty(value="merged_into")
    public OCMergedInto getMergedInto() {
        return this.mergedInto;
    }

    @JsonProperty(value="merged_into")
    public void setMergedInto(OCMergedInto mergedInto) {
        this.mergedInto = mergedInto;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCAllAttributes.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("jurisdictionOfOrigin");
        sb.append('=');
        sb.append(this.jurisdictionOfOrigin == null ? "<null>" : this.jurisdictionOfOrigin);
        sb.append(',');
        sb.append("homeCompanyNumber");
        sb.append('=');
        sb.append(this.homeCompanyNumber == null ? "<null>" : this.homeCompanyNumber);
        sb.append(',');
        sb.append("homeLegalName");
        sb.append('=');
        sb.append(this.homeLegalName == null ? "<null>" : this.homeLegalName);
        sb.append(',');
        sb.append("registeredAgentAddress");
        sb.append('=');
        sb.append(this.registeredAgentAddress == null ? "<null>" : this.registeredAgentAddress);
        sb.append(',');
        sb.append("registeredAgentName");
        sb.append('=');
        sb.append(this.registeredAgentName == null ? "<null>" : this.registeredAgentName);
        sb.append(',');
        sb.append("numberOfEmployees");
        sb.append('=');
        sb.append(this.numberOfEmployees == null ? "<null>" : this.numberOfEmployees);
        sb.append(',');
        sb.append("mergedInto");
        sb.append('=');
        sb.append(this.mergedInto == null ? "<null>" : this.mergedInto);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.jurisdictionOfOrigin == null ? 0 : this.jurisdictionOfOrigin.hashCode());
        result = result * 31 + (this.registeredAgentAddress == null ? 0 : this.registeredAgentAddress.hashCode());
        result = result * 31 + (this.registeredAgentName == null ? 0 : this.registeredAgentName.hashCode());
        result = result * 31 + (this.homeLegalName == null ? 0 : this.homeLegalName.hashCode());
        result = result * 31 + (this.mergedInto == null ? 0 : this.mergedInto.hashCode());
        result = result * 31 + (this.homeCompanyNumber == null ? 0 : this.homeCompanyNumber.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.numberOfEmployees == null ? 0 : this.numberOfEmployees.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCAllAttributes)) {
            return false;
        }
        OCAllAttributes rhs = (OCAllAttributes)other;
        return (this.jurisdictionOfOrigin == rhs.jurisdictionOfOrigin || this.jurisdictionOfOrigin != null && this.jurisdictionOfOrigin.equals(rhs.jurisdictionOfOrigin)) && (this.registeredAgentAddress == rhs.registeredAgentAddress || this.registeredAgentAddress != null && this.registeredAgentAddress.equals(rhs.registeredAgentAddress)) && (this.registeredAgentName == rhs.registeredAgentName || this.registeredAgentName != null && this.registeredAgentName.equals(rhs.registeredAgentName)) && (this.homeLegalName == rhs.homeLegalName || this.homeLegalName != null && this.homeLegalName.equals(rhs.homeLegalName)) && (this.mergedInto == rhs.mergedInto || this.mergedInto != null && this.mergedInto.equals(rhs.mergedInto)) && (this.homeCompanyNumber == rhs.homeCompanyNumber || this.homeCompanyNumber != null && this.homeCompanyNumber.equals(rhs.homeCompanyNumber)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.numberOfEmployees == rhs.numberOfEmployees || this.numberOfEmployees != null && this.numberOfEmployees.equals(rhs.numberOfEmployees));
    }
}

