/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas.includes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.opencorporates.schemas.OCAlternativeName;
import com.opencorporates.schemas.OCFiling;
import com.opencorporates.schemas.OCIdentifier;
import com.opencorporates.schemas.OCIndustryCode;
import com.opencorporates.schemas.OCOfficer;
import com.opencorporates.schemas.OCPreviousName;
import com.opencorporates.schemas.OCShareParcel;
import com.opencorporates.schemas.OCTotalShares;
import com.opencorporates.schemas.includes.OCAddressWithType;
import com.opencorporates.schemas.includes.OCAllAttributes;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"company_number", "name", "jurisdiction", "jurisdiction_code", "incorporation_date", "dissolution_date", "retrieved_at", "current_status", "company_type", "registry_url", "website", "telephone_number", "fax_number", "registered_address", "headquarters_address", "mailing_address", "addresses", "officers", "share_parcels", "total_shares", "filings", "identifiers", "industry_codes", "previous_names", "alternative_names", "branch", "all_attributes"})
public class OCCompanyForNesting {
    @JsonProperty(value="company_number")
    @JsonPropertyDescription(value="unique identifier given by the corporate register with which it is incorporated")
    @Size(min=1)
    private @Size(min=1) String companyNumber;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Legal name of the company")
    @Size(min=1)
    private @Size(min=1) String name;
    @JsonProperty(value="jurisdiction")
    @JsonPropertyDescription(value="A free text field for the jurisdiction where the company is registered \u2013 this can be either the ISO 3166-2 code, the underscored version, or the standard name for the jurisdiction, e.g. France")
    private String jurisdiction;
    @JsonProperty(value="jurisdiction_code")
    @JsonPropertyDescription(value="Code representing the jurisdiction/company register which is the canonical record of the company\u2019s existence. Uses underscored ISO 3166-2 to represent it, e.g. es for Spain, us_de for Delaware")
    @Size(min=2, max=5)
    private @Size(min=2, max=5) String jurisdictionCode;
    @JsonProperty(value="incorporation_date")
    private LocalDate incorporationDate;
    @JsonProperty(value="dissolution_date")
    private LocalDate dissolutionDate;
    @JsonProperty(value="retrieved_at")
    private LocalDate retrievedAt;
    @JsonProperty(value="current_status")
    private String currentStatus;
    @JsonProperty(value="company_type")
    private String companyType;
    @JsonProperty(value="registry_url")
    private String registryUrl;
    @JsonProperty(value="website")
    private Object website;
    @JsonProperty(value="telephone_number")
    @Size(min=4)
    private @Size(min=4) String telephoneNumber;
    @JsonProperty(value="fax_number")
    @Size(min=4)
    private @Size(min=4) String faxNumber;
    @JsonProperty(value="registered_address")
    private Object registeredAddress;
    @JsonProperty(value="headquarters_address")
    private Object headquartersAddress;
    @JsonProperty(value="mailing_address")
    private Object mailingAddress;
    @JsonProperty(value="addresses")
    @Valid
    private List<OCAddressWithType> addresses = new ArrayList<OCAddressWithType>();
    @JsonProperty(value="officers")
    @Valid
    private List<OCOfficer> officers = new ArrayList<OCOfficer>();
    @JsonProperty(value="share_parcels")
    @Valid
    private List<OCShareParcel> shareParcels = new ArrayList<OCShareParcel>();
    @JsonProperty(value="total_shares")
    @JsonPropertyDescription(value="The total number of shares a company has issued")
    @Valid
    private OCTotalShares totalShares;
    @JsonProperty(value="filings")
    @Valid
    private List<OCFiling> filings = new ArrayList<OCFiling>();
    @JsonProperty(value="identifiers")
    @Valid
    private List<OCIdentifier> identifiers = new ArrayList<OCIdentifier>();
    @JsonProperty(value="industry_codes")
    @Valid
    private List<OCIndustryCode> industryCodes = new ArrayList<OCIndustryCode>();
    @JsonProperty(value="previous_names")
    @Valid
    private List<OCPreviousName> previousNames = new ArrayList<OCPreviousName>();
    @JsonProperty(value="alternative_names")
    @Valid
    private List<OCAlternativeName> alternativeNames = new ArrayList<OCAlternativeName>();
    @JsonProperty(value="branch")
    @JsonPropertyDescription(value="A flag to denote whether a company is a branch entity. This should only be set if the company is a type of branch (otherwise should be null). In general the only option here is 'F' for a 'Foreign' branch, i.e. an out-of-jurisdiction entity that has registered as having a presence in the jurisdiction. In the US this is sometimes called a Foreign Corporation")
    private Branch branch;
    @JsonProperty(value="all_attributes")
    @JsonPropertyDescription(value="Other arbitrary attributes for a given company")
    @Valid
    private OCAllAttributes allAttributes;

    @JsonProperty(value="company_number")
    public String getCompanyNumber() {
        return this.companyNumber;
    }

    @JsonProperty(value="company_number")
    public void setCompanyNumber(String companyNumber) {
        this.companyNumber = companyNumber;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="jurisdiction")
    public String getJurisdiction() {
        return this.jurisdiction;
    }

    @JsonProperty(value="jurisdiction")
    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    @JsonProperty(value="jurisdiction_code")
    public String getJurisdictionCode() {
        return this.jurisdictionCode;
    }

    @JsonProperty(value="jurisdiction_code")
    public void setJurisdictionCode(String jurisdictionCode) {
        this.jurisdictionCode = jurisdictionCode;
    }

    @JsonProperty(value="incorporation_date")
    public LocalDate getIncorporationDate() {
        return this.incorporationDate;
    }

    @JsonProperty(value="incorporation_date")
    public void setIncorporationDate(LocalDate incorporationDate) {
        this.incorporationDate = incorporationDate;
    }

    @JsonProperty(value="dissolution_date")
    public LocalDate getDissolutionDate() {
        return this.dissolutionDate;
    }

    @JsonProperty(value="dissolution_date")
    public void setDissolutionDate(LocalDate dissolutionDate) {
        this.dissolutionDate = dissolutionDate;
    }

    @JsonProperty(value="retrieved_at")
    public LocalDate getRetrievedAt() {
        return this.retrievedAt;
    }

    @JsonProperty(value="retrieved_at")
    public void setRetrievedAt(LocalDate retrievedAt) {
        this.retrievedAt = retrievedAt;
    }

    @JsonProperty(value="current_status")
    public String getCurrentStatus() {
        return this.currentStatus;
    }

    @JsonProperty(value="current_status")
    public void setCurrentStatus(String currentStatus) {
        this.currentStatus = currentStatus;
    }

    @JsonProperty(value="company_type")
    public String getCompanyType() {
        return this.companyType;
    }

    @JsonProperty(value="company_type")
    public void setCompanyType(String companyType) {
        this.companyType = companyType;
    }

    @JsonProperty(value="registry_url")
    public String getRegistryUrl() {
        return this.registryUrl;
    }

    @JsonProperty(value="registry_url")
    public void setRegistryUrl(String registryUrl) {
        this.registryUrl = registryUrl;
    }

    @JsonProperty(value="website")
    public Object getWebsite() {
        return this.website;
    }

    @JsonProperty(value="website")
    public void setWebsite(Object website) {
        this.website = website;
    }

    @JsonProperty(value="telephone_number")
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    @JsonProperty(value="telephone_number")
    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    @JsonProperty(value="fax_number")
    public String getFaxNumber() {
        return this.faxNumber;
    }

    @JsonProperty(value="fax_number")
    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
    }

    @JsonProperty(value="registered_address")
    public Object getRegisteredAddress() {
        return this.registeredAddress;
    }

    @JsonProperty(value="registered_address")
    public void setRegisteredAddress(Object registeredAddress) {
        this.registeredAddress = registeredAddress;
    }

    @JsonProperty(value="headquarters_address")
    public Object getHeadquartersAddress() {
        return this.headquartersAddress;
    }

    @JsonProperty(value="headquarters_address")
    public void setHeadquartersAddress(Object headquartersAddress) {
        this.headquartersAddress = headquartersAddress;
    }

    @JsonProperty(value="mailing_address")
    public Object getMailingAddress() {
        return this.mailingAddress;
    }

    @JsonProperty(value="mailing_address")
    public void setMailingAddress(Object mailingAddress) {
        this.mailingAddress = mailingAddress;
    }

    @JsonProperty(value="addresses")
    public List<OCAddressWithType> getAddresses() {
        return this.addresses;
    }

    @JsonProperty(value="addresses")
    public void setAddresses(List<OCAddressWithType> addresses) {
        this.addresses = addresses;
    }

    @JsonProperty(value="officers")
    public List<OCOfficer> getOfficers() {
        return this.officers;
    }

    @JsonProperty(value="officers")
    public void setOfficers(List<OCOfficer> officers) {
        this.officers = officers;
    }

    @JsonProperty(value="share_parcels")
    public List<OCShareParcel> getShareParcels() {
        return this.shareParcels;
    }

    @JsonProperty(value="share_parcels")
    public void setShareParcels(List<OCShareParcel> shareParcels) {
        this.shareParcels = shareParcels;
    }

    @JsonProperty(value="total_shares")
    public OCTotalShares getTotalShares() {
        return this.totalShares;
    }

    @JsonProperty(value="total_shares")
    public void setTotalShares(OCTotalShares totalShares) {
        this.totalShares = totalShares;
    }

    @JsonProperty(value="filings")
    public List<OCFiling> getFilings() {
        return this.filings;
    }

    @JsonProperty(value="filings")
    public void setFilings(List<OCFiling> filings) {
        this.filings = filings;
    }

    @JsonProperty(value="identifiers")
    public List<OCIdentifier> getIdentifiers() {
        return this.identifiers;
    }

    @JsonProperty(value="identifiers")
    public void setIdentifiers(List<OCIdentifier> identifiers) {
        this.identifiers = identifiers;
    }

    @JsonProperty(value="industry_codes")
    public List<OCIndustryCode> getIndustryCodes() {
        return this.industryCodes;
    }

    @JsonProperty(value="industry_codes")
    public void setIndustryCodes(List<OCIndustryCode> industryCodes) {
        this.industryCodes = industryCodes;
    }

    @JsonProperty(value="previous_names")
    public List<OCPreviousName> getPreviousNames() {
        return this.previousNames;
    }

    @JsonProperty(value="previous_names")
    public void setPreviousNames(List<OCPreviousName> previousNames) {
        this.previousNames = previousNames;
    }

    @JsonProperty(value="alternative_names")
    public List<OCAlternativeName> getAlternativeNames() {
        return this.alternativeNames;
    }

    @JsonProperty(value="alternative_names")
    public void setAlternativeNames(List<OCAlternativeName> alternativeNames) {
        this.alternativeNames = alternativeNames;
    }

    @JsonProperty(value="branch")
    public Branch getBranch() {
        return this.branch;
    }

    @JsonProperty(value="branch")
    public void setBranch(Branch branch) {
        this.branch = branch;
    }

    @JsonProperty(value="all_attributes")
    public OCAllAttributes getAllAttributes() {
        return this.allAttributes;
    }

    @JsonProperty(value="all_attributes")
    public void setAllAttributes(OCAllAttributes allAttributes) {
        this.allAttributes = allAttributes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCCompanyForNesting.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("companyNumber");
        sb.append('=');
        sb.append(this.companyNumber == null ? "<null>" : this.companyNumber);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("jurisdiction");
        sb.append('=');
        sb.append(this.jurisdiction == null ? "<null>" : this.jurisdiction);
        sb.append(',');
        sb.append("jurisdictionCode");
        sb.append('=');
        sb.append(this.jurisdictionCode == null ? "<null>" : this.jurisdictionCode);
        sb.append(',');
        sb.append("incorporationDate");
        sb.append('=');
        sb.append(this.incorporationDate == null ? "<null>" : this.incorporationDate);
        sb.append(',');
        sb.append("dissolutionDate");
        sb.append('=');
        sb.append(this.dissolutionDate == null ? "<null>" : this.dissolutionDate);
        sb.append(',');
        sb.append("retrievedAt");
        sb.append('=');
        sb.append(this.retrievedAt == null ? "<null>" : this.retrievedAt);
        sb.append(',');
        sb.append("currentStatus");
        sb.append('=');
        sb.append(this.currentStatus == null ? "<null>" : this.currentStatus);
        sb.append(',');
        sb.append("companyType");
        sb.append('=');
        sb.append(this.companyType == null ? "<null>" : this.companyType);
        sb.append(',');
        sb.append("registryUrl");
        sb.append('=');
        sb.append(this.registryUrl == null ? "<null>" : this.registryUrl);
        sb.append(',');
        sb.append("website");
        sb.append('=');
        sb.append(this.website == null ? "<null>" : this.website);
        sb.append(',');
        sb.append("telephoneNumber");
        sb.append('=');
        sb.append(this.telephoneNumber == null ? "<null>" : this.telephoneNumber);
        sb.append(',');
        sb.append("faxNumber");
        sb.append('=');
        sb.append(this.faxNumber == null ? "<null>" : this.faxNumber);
        sb.append(',');
        sb.append("registeredAddress");
        sb.append('=');
        sb.append(this.registeredAddress == null ? "<null>" : this.registeredAddress);
        sb.append(',');
        sb.append("headquartersAddress");
        sb.append('=');
        sb.append(this.headquartersAddress == null ? "<null>" : this.headquartersAddress);
        sb.append(',');
        sb.append("mailingAddress");
        sb.append('=');
        sb.append(this.mailingAddress == null ? "<null>" : this.mailingAddress);
        sb.append(',');
        sb.append("addresses");
        sb.append('=');
        sb.append(this.addresses == null ? "<null>" : this.addresses);
        sb.append(',');
        sb.append("officers");
        sb.append('=');
        sb.append(this.officers == null ? "<null>" : this.officers);
        sb.append(',');
        sb.append("shareParcels");
        sb.append('=');
        sb.append(this.shareParcels == null ? "<null>" : this.shareParcels);
        sb.append(',');
        sb.append("totalShares");
        sb.append('=');
        sb.append(this.totalShares == null ? "<null>" : this.totalShares);
        sb.append(',');
        sb.append("filings");
        sb.append('=');
        sb.append(this.filings == null ? "<null>" : this.filings);
        sb.append(',');
        sb.append("identifiers");
        sb.append('=');
        sb.append(this.identifiers == null ? "<null>" : this.identifiers);
        sb.append(',');
        sb.append("industryCodes");
        sb.append('=');
        sb.append(this.industryCodes == null ? "<null>" : this.industryCodes);
        sb.append(',');
        sb.append("previousNames");
        sb.append('=');
        sb.append(this.previousNames == null ? "<null>" : this.previousNames);
        sb.append(',');
        sb.append("alternativeNames");
        sb.append('=');
        sb.append(this.alternativeNames == null ? "<null>" : this.alternativeNames);
        sb.append(',');
        sb.append("branch");
        sb.append('=');
        sb.append(this.branch == null ? "<null>" : this.branch);
        sb.append(',');
        sb.append("allAttributes");
        sb.append('=');
        sb.append(this.allAttributes == null ? "<null>" : this.allAttributes);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.addresses == null ? 0 : this.addresses.hashCode());
        result = result * 31 + (this.telephoneNumber == null ? 0 : this.telephoneNumber.hashCode());
        result = result * 31 + (this.dissolutionDate == null ? 0 : this.dissolutionDate.hashCode());
        result = result * 31 + (this.jurisdiction == null ? 0 : this.jurisdiction.hashCode());
        result = result * 31 + (this.allAttributes == null ? 0 : this.allAttributes.hashCode());
        result = result * 31 + (this.industryCodes == null ? 0 : this.industryCodes.hashCode());
        result = result * 31 + (this.branch == null ? 0 : this.branch.hashCode());
        result = result * 31 + (this.filings == null ? 0 : this.filings.hashCode());
        result = result * 31 + (this.alternativeNames == null ? 0 : this.alternativeNames.hashCode());
        result = result * 31 + (this.registeredAddress == null ? 0 : this.registeredAddress.hashCode());
        result = result * 31 + (this.companyNumber == null ? 0 : this.companyNumber.hashCode());
        result = result * 31 + (this.incorporationDate == null ? 0 : this.incorporationDate.hashCode());
        result = result * 31 + (this.officers == null ? 0 : this.officers.hashCode());
        result = result * 31 + (this.registryUrl == null ? 0 : this.registryUrl.hashCode());
        result = result * 31 + (this.website == null ? 0 : this.website.hashCode());
        result = result * 31 + (this.currentStatus == null ? 0 : this.currentStatus.hashCode());
        result = result * 31 + (this.companyType == null ? 0 : this.companyType.hashCode());
        result = result * 31 + (this.identifiers == null ? 0 : this.identifiers.hashCode());
        result = result * 31 + (this.headquartersAddress == null ? 0 : this.headquartersAddress.hashCode());
        result = result * 31 + (this.shareParcels == null ? 0 : this.shareParcels.hashCode());
        result = result * 31 + (this.totalShares == null ? 0 : this.totalShares.hashCode());
        result = result * 31 + (this.retrievedAt == null ? 0 : this.retrievedAt.hashCode());
        result = result * 31 + (this.mailingAddress == null ? 0 : this.mailingAddress.hashCode());
        result = result * 31 + (this.previousNames == null ? 0 : this.previousNames.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.jurisdictionCode == null ? 0 : this.jurisdictionCode.hashCode());
        result = result * 31 + (this.faxNumber == null ? 0 : this.faxNumber.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCCompanyForNesting)) {
            return false;
        }
        OCCompanyForNesting rhs = (OCCompanyForNesting)other;
        return (this.addresses == rhs.addresses || this.addresses != null && this.addresses.equals(rhs.addresses)) && (this.telephoneNumber == rhs.telephoneNumber || this.telephoneNumber != null && this.telephoneNumber.equals(rhs.telephoneNumber)) && (this.dissolutionDate == rhs.dissolutionDate || this.dissolutionDate != null && this.dissolutionDate.equals(rhs.dissolutionDate)) && (this.jurisdiction == rhs.jurisdiction || this.jurisdiction != null && this.jurisdiction.equals(rhs.jurisdiction)) && (this.allAttributes == rhs.allAttributes || this.allAttributes != null && this.allAttributes.equals(rhs.allAttributes)) && (this.industryCodes == rhs.industryCodes || this.industryCodes != null && this.industryCodes.equals(rhs.industryCodes)) && (this.branch == rhs.branch || this.branch != null && this.branch.equals((Object)rhs.branch)) && (this.filings == rhs.filings || this.filings != null && this.filings.equals(rhs.filings)) && (this.alternativeNames == rhs.alternativeNames || this.alternativeNames != null && this.alternativeNames.equals(rhs.alternativeNames)) && (this.registeredAddress == rhs.registeredAddress || this.registeredAddress != null && this.registeredAddress.equals(rhs.registeredAddress)) && (this.companyNumber == rhs.companyNumber || this.companyNumber != null && this.companyNumber.equals(rhs.companyNumber)) && (this.incorporationDate == rhs.incorporationDate || this.incorporationDate != null && this.incorporationDate.equals(rhs.incorporationDate)) && (this.officers == rhs.officers || this.officers != null && this.officers.equals(rhs.officers)) && (this.registryUrl == rhs.registryUrl || this.registryUrl != null && this.registryUrl.equals(rhs.registryUrl)) && (this.website == rhs.website || this.website != null && this.website.equals(rhs.website)) && (this.currentStatus == rhs.currentStatus || this.currentStatus != null && this.currentStatus.equals(rhs.currentStatus)) && (this.companyType == rhs.companyType || this.companyType != null && this.companyType.equals(rhs.companyType)) && (this.identifiers == rhs.identifiers || this.identifiers != null && this.identifiers.equals(rhs.identifiers)) && (this.headquartersAddress == rhs.headquartersAddress || this.headquartersAddress != null && this.headquartersAddress.equals(rhs.headquartersAddress)) && (this.shareParcels == rhs.shareParcels || this.shareParcels != null && this.shareParcels.equals(rhs.shareParcels)) && (this.totalShares == rhs.totalShares || this.totalShares != null && this.totalShares.equals(rhs.totalShares)) && (this.retrievedAt == rhs.retrievedAt || this.retrievedAt != null && this.retrievedAt.equals(rhs.retrievedAt)) && (this.mailingAddress == rhs.mailingAddress || this.mailingAddress != null && this.mailingAddress.equals(rhs.mailingAddress)) && (this.previousNames == rhs.previousNames || this.previousNames != null && this.previousNames.equals(rhs.previousNames)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.jurisdictionCode == rhs.jurisdictionCode || this.jurisdictionCode != null && this.jurisdictionCode.equals(rhs.jurisdictionCode)) && (this.faxNumber == rhs.faxNumber || this.faxNumber != null && this.faxNumber.equals(rhs.faxNumber));
    }

    public static enum Branch {
        F("F"),
        L("L");

        private final String value;
        private static final Map<String, Branch> CONSTANTS;

        private Branch(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Branch fromValue(String value) {
            Branch constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Branch>();
            for (Branch c : Branch.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

