/*
 * Decompiled with CFR 0.152.
 */
package com.opencorporates.schemas.includes;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"regulator", "category", "jurisdiction_code", "licence_number", "jurisdiction_classification", "oc_classification"})
public class OCProperties {
    @JsonProperty(value="regulator")
    @JsonPropertyDescription(value="The regulating body that issued the licence")
    private String regulator;
    @JsonProperty(value="category")
    @JsonPropertyDescription(value="The category of licence. Current possible values are: 'Financial','Business'")
    @NotNull
    private Category category;
    @JsonProperty(value="jurisdiction_code")
    @JsonPropertyDescription(value="The jurisdiction for which licence was issued")
    @NotNull
    private String jurisdictionCode;
    @JsonProperty(value="licence_number")
    @JsonPropertyDescription(value="Licence number or code (can be null)")
    private String licenceNumber;
    @JsonProperty(value="jurisdiction_classification")
    @JsonPropertyDescription(value="The local classification given by the regulator")
    @Size(min=1)
    @Valid
    @NotNull
    private @Size(min=1) @Valid @NotNull List<Object> jurisdictionClassification = new ArrayList<Object>();
    @JsonProperty(value="oc_classification")
    @Valid
    private List<Object> ocClassification = new ArrayList<Object>();
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="regulator")
    public String getRegulator() {
        return this.regulator;
    }

    @JsonProperty(value="regulator")
    public void setRegulator(String regulator) {
        this.regulator = regulator;
    }

    @JsonProperty(value="category")
    public Category getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    public void setCategory(Category category) {
        this.category = category;
    }

    @JsonProperty(value="jurisdiction_code")
    public String getJurisdictionCode() {
        return this.jurisdictionCode;
    }

    @JsonProperty(value="jurisdiction_code")
    public void setJurisdictionCode(String jurisdictionCode) {
        this.jurisdictionCode = jurisdictionCode;
    }

    @JsonProperty(value="licence_number")
    public String getLicenceNumber() {
        return this.licenceNumber;
    }

    @JsonProperty(value="licence_number")
    public void setLicenceNumber(String licenceNumber) {
        this.licenceNumber = licenceNumber;
    }

    @JsonProperty(value="jurisdiction_classification")
    public List<Object> getJurisdictionClassification() {
        return this.jurisdictionClassification;
    }

    @JsonProperty(value="jurisdiction_classification")
    public void setJurisdictionClassification(List<Object> jurisdictionClassification) {
        this.jurisdictionClassification = jurisdictionClassification;
    }

    @JsonProperty(value="oc_classification")
    public List<Object> getOcClassification() {
        return this.ocClassification;
    }

    @JsonProperty(value="oc_classification")
    public void setOcClassification(List<Object> ocClassification) {
        this.ocClassification = ocClassification;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OCProperties.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("regulator");
        sb.append('=');
        sb.append(this.regulator == null ? "<null>" : this.regulator);
        sb.append(',');
        sb.append("category");
        sb.append('=');
        sb.append(this.category == null ? "<null>" : this.category);
        sb.append(',');
        sb.append("jurisdictionCode");
        sb.append('=');
        sb.append(this.jurisdictionCode == null ? "<null>" : this.jurisdictionCode);
        sb.append(',');
        sb.append("licenceNumber");
        sb.append('=');
        sb.append(this.licenceNumber == null ? "<null>" : this.licenceNumber);
        sb.append(',');
        sb.append("jurisdictionClassification");
        sb.append('=');
        sb.append(this.jurisdictionClassification == null ? "<null>" : this.jurisdictionClassification);
        sb.append(',');
        sb.append("ocClassification");
        sb.append('=');
        sb.append(this.ocClassification == null ? "<null>" : this.ocClassification);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.ocClassification == null ? 0 : this.ocClassification.hashCode());
        result = result * 31 + (this.licenceNumber == null ? 0 : this.licenceNumber.hashCode());
        result = result * 31 + (this.regulator == null ? 0 : this.regulator.hashCode());
        result = result * 31 + (this.jurisdictionCode == null ? 0 : this.jurisdictionCode.hashCode());
        result = result * 31 + (this.jurisdictionClassification == null ? 0 : this.jurisdictionClassification.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.category == null ? 0 : this.category.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OCProperties)) {
            return false;
        }
        OCProperties rhs = (OCProperties)other;
        return (this.ocClassification == rhs.ocClassification || this.ocClassification != null && this.ocClassification.equals(rhs.ocClassification)) && (this.licenceNumber == rhs.licenceNumber || this.licenceNumber != null && this.licenceNumber.equals(rhs.licenceNumber)) && (this.regulator == rhs.regulator || this.regulator != null && this.regulator.equals(rhs.regulator)) && (this.jurisdictionCode == rhs.jurisdictionCode || this.jurisdictionCode != null && this.jurisdictionCode.equals(rhs.jurisdictionCode)) && (this.jurisdictionClassification == rhs.jurisdictionClassification || this.jurisdictionClassification != null && this.jurisdictionClassification.equals(rhs.jurisdictionClassification)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.category == rhs.category || this.category != null && this.category.equals((Object)rhs.category));
    }

    public static enum Category {
        FINANCIAL("Financial"),
        BUSINESS("Business");

        private final String value;
        private static final Map<String, Category> CONSTANTS;

        private Category(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Category fromValue(String value) {
            Category constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Category>();
            for (Category c : Category.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

