/*
 * Decompiled with CFR 0.152.
 */
package org.purplejrank.jdk;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.purplejrank.io.PullInputStream;
import org.purplejrank.jdk.Block;
import org.purplejrank.jdk.JdkStream;
import org.purplejrank.jdk.block.HeaderBlock;
import org.purplejrank.jdk.rule.ContentRule;

public class JdkJrankInputStream
extends PullInputStream {
    protected ByteArrayOutputStream bout = new ByteArrayOutputStream();
    protected JdkStream jdk;
    protected byte[] bbuf;
    protected int pos;

    public JdkJrankInputStream(InputStream in) throws IOException {
        this.jdk = new JdkStream(in);
        this.pull(new HeaderBlock(this.jdk));
        this.pull();
    }

    protected void pull(Block b) throws IOException {
        this.bout.reset();
        b.writeJrank(new DataOutputStream(this.bout));
        this.bbuf = this.bout.toByteArray();
        this.pos = 0;
    }

    protected int pull() throws IOException {
        if (this.pos == this.bbuf.length) {
            this.pull(this.jdk.readBlock(ContentRule.class));
        }
        this.buf.clear();
        int r = Math.min(this.buf.remaining(), this.bbuf.length - this.pos);
        this.buf.put(this.bbuf, this.pos, r);
        this.pos += r;
        this.buf.flip();
        return r;
    }
}

