/*
 * Decompiled with CFR 0.152.
 */
package org.purplejrank.jdk;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.List;
import org.purplejrank.jdk.Block;
import org.purplejrank.jdk.WiredBlock;
import org.purplejrank.jdk.block.ArrayBlock;
import org.purplejrank.jdk.block.BlockdataBlock;
import org.purplejrank.jdk.block.BlockdatalongBlock;
import org.purplejrank.jdk.block.ClassBlock;
import org.purplejrank.jdk.block.ClassdescBlock;
import org.purplejrank.jdk.block.EndblockdataBlock;
import org.purplejrank.jdk.block.EnumBlock;
import org.purplejrank.jdk.block.ExceptionBlock;
import org.purplejrank.jdk.block.HeaderBlock;
import org.purplejrank.jdk.block.LongstringBlock;
import org.purplejrank.jdk.block.NullBlock;
import org.purplejrank.jdk.block.ObjectBlock;
import org.purplejrank.jdk.block.ProxyclassdescBlock;
import org.purplejrank.jdk.block.ReferenceBlock;
import org.purplejrank.jdk.block.ResetBlock;
import org.purplejrank.jdk.block.StringBlock;
import org.purplejrank.jdk.rule.ContentRule;

public class JdkStream
extends DataInputStream {
    protected List<WiredBlock> wiredBlocks = new ArrayList<WiredBlock>();

    public JdkStream(InputStream in) throws IOException {
        super(in);
        new HeaderBlock(this).parse();
    }

    public void verify() throws IOException {
        try {
            while (true) {
                this.readBlock(ContentRule.class);
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    public int wireBlock(WiredBlock ref) {
        this.wiredBlocks.add(ref);
        return 0x7E0000 + this.wiredBlocks.size() - 1;
    }

    public List<WiredBlock> getWiredBlocks() {
        return this.wiredBlocks;
    }

    public <T extends Block> T readBlock(Class<T> type) throws IOException {
        Block b = this.readBlock();
        if (type.isInstance(b)) {
            return (T)((Block)type.cast(b));
        }
        throw new StreamCorruptedException("Unexpected block:" + b);
    }

    public Block readBlock() throws IOException {
        int t = this.read();
        switch (t) {
            case 112: {
                return new NullBlock(this).parse();
            }
            case 113: {
                return new ReferenceBlock(this).parse();
            }
            case 114: {
                return new ClassdescBlock(this).parse();
            }
            case 115: {
                return new ObjectBlock(this).parse();
            }
            case 116: {
                return new StringBlock(this).parse();
            }
            case 117: {
                return new ArrayBlock(this).parse();
            }
            case 118: {
                return new ClassBlock(this).parse();
            }
            case 119: {
                return new BlockdataBlock(this).parse();
            }
            case 120: {
                return new EndblockdataBlock(this).parse();
            }
            case 121: {
                return new ResetBlock(this).parse();
            }
            case 122: {
                return new BlockdatalongBlock(this).parse();
            }
            case 123: {
                return new ExceptionBlock(this).parse();
            }
            case 124: {
                return new LongstringBlock(this).parse();
            }
            case 125: {
                return new ProxyclassdescBlock(this).parse();
            }
            case 126: {
                return new EnumBlock(this).parse();
            }
            case -1: {
                throw new EOFException();
            }
        }
        throw new StreamCorruptedException();
    }

    public String readLongUTF() throws IOException {
        int c;
        int count;
        int utflen = (int)this.readLong();
        byte[] bytearr = null;
        char[] chararr = null;
        bytearr = new byte[utflen];
        chararr = new char[utflen];
        int chararr_count = 0;
        this.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararr_count);
    }

    public static void writeEscapedInt(OutputStream out, int v) throws IOException {
        if ((v & 0x7F) != v) {
            out.write(0x80 | 0x7F & v);
            JdkStream.writeEscapedInt(out, v >>> 7);
        } else {
            out.write(v);
        }
    }

    public static void writeEscapedLong(OutputStream out, long v) throws IOException {
        if ((v & 0x7FL) != v) {
            out.write((int)(0x80L | 0x7FL & v));
            JdkStream.writeEscapedLong(out, v >>> 7);
        } else {
            out.write((int)v);
        }
    }

    public static void writeUTF(OutputStream out, String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            int c = s.charAt(i);
            if (c == 0) {
                c = 131071;
            }
            JdkStream.writeEscapedInt(out, c);
        }
        JdkStream.writeEscapedInt(out, 0);
    }
}

