/*
 * Decompiled with CFR 0.152.
 */
package org.purplejrank.jdk.block;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.purplejrank.jdk.Block;
import org.purplejrank.jdk.JdkBlock;
import org.purplejrank.jdk.JdkStream;
import org.purplejrank.jdk.WiredBlock;
import org.purplejrank.jdk.rule.ClassdescRule;
import org.purplejrank.jdk.rule.ObjectRule;

public class ArrayBlock
extends JdkBlock
implements ObjectRule,
WiredBlock {
    protected ClassdescRule classDesc;
    protected int size;
    protected byte[] primValues;
    protected List<ObjectRule> objValues;

    public ArrayBlock(JdkStream jdk) {
        super(jdk);
    }

    @Override
    public Block parse() throws IOException {
        this.classDesc = this.jdk.readBlock(ClassdescRule.class);
        this.jdk.wireBlock(this);
        this.size = this.jdk.readInt();
        switch (this.classDesc.getClassName().charAt(1)) {
            case 'B': {
                this.primValues = new byte[this.size];
                break;
            }
            case 'C': {
                this.primValues = new byte[this.size * 2];
                break;
            }
            case 'D': {
                this.primValues = new byte[this.size * 8];
                break;
            }
            case 'F': {
                this.primValues = new byte[this.size * 4];
                break;
            }
            case 'I': {
                this.primValues = new byte[this.size * 4];
                break;
            }
            case 'J': {
                this.primValues = new byte[this.size * 8];
                break;
            }
            case 'S': {
                this.primValues = new byte[this.size * 2];
                break;
            }
            case 'Z': {
                this.primValues = new byte[this.size];
                break;
            }
            case 'L': 
            case '[': {
                this.objValues = new ArrayList<ObjectRule>();
            }
        }
        if (this.primValues != null) {
            this.jdk.readFully(this.primValues);
        }
        if (this.objValues != null) {
            for (int i = 0; i < this.size; ++i) {
                this.objValues.add(this.jdk.readBlock(ObjectRule.class));
            }
        }
        return this;
    }

    @Override
    public void writeJrank(DataOutputStream out) throws IOException {
        out.write(5);
        this.classDesc.writeJrank(out);
        JdkStream.writeEscapedInt(out, this.size);
        if (this.primValues != null) {
            out.write(this.primValues);
        } else {
            for (ObjectRule o : this.objValues) {
                o.writeJrank(out);
            }
        }
    }
}

