/*
 * Decompiled with CFR 0.152.
 */
package org.purplejrank.jdk.block;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.List;
import org.purplejrank.jdk.Block;
import org.purplejrank.jdk.JdkBlock;
import org.purplejrank.jdk.JdkStream;
import org.purplejrank.jdk.WiredBlock;
import org.purplejrank.jdk.block.EndblockdataBlock;
import org.purplejrank.jdk.block.NullBlock;
import org.purplejrank.jdk.block.ReferenceBlock;
import org.purplejrank.jdk.rule.ContentRule;
import org.purplejrank.jdk.rule.NewclassdescRule;
import org.purplejrank.jdk.rule.ObjectRule;
import org.purplejrank.jdk.rule.StringRule;
import org.purplejrank.jdk.rule.SuperclassdescRule;

public class ClassdescBlock
extends JdkBlock
implements ObjectRule,
NewclassdescRule,
WiredBlock {
    protected String className;
    protected long serialVersionUID;
    protected byte classDescFlags;
    protected List<Field> fields = new ArrayList<Field>();
    protected List<ContentRule> classAnnotation = new ArrayList<ContentRule>();
    protected SuperclassdescRule superClassDesc;

    public ClassdescBlock(JdkStream jdk) {
        super(jdk);
    }

    @Override
    public Block parse() throws IOException {
        Block a;
        this.className = this.jdk.readUTF();
        this.serialVersionUID = this.jdk.readLong();
        this.jdk.wireBlock(this);
        this.classDescFlags = this.jdk.readByte();
        int fieldCount = this.jdk.readShort();
        for (int i = 0; i < fieldCount; ++i) {
            this.fields.add(new Field(this.jdk).parse());
        }
        while ((a = this.jdk.readBlock()) instanceof ContentRule) {
            this.classAnnotation.add((ContentRule)a);
        }
        EndblockdataBlock.class.cast(a);
        this.superClassDesc = this.jdk.readBlock(SuperclassdescRule.class);
        return this;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public ClassdescBlock getSuperClassDesc() {
        if (this.superClassDesc instanceof ReferenceBlock) {
            return (ClassdescBlock)((ReferenceBlock)this.superClassDesc).getWired();
        }
        if (this.superClassDesc instanceof NullBlock) {
            return null;
        }
        return (ClassdescBlock)this.superClassDesc;
    }

    public long getSerialVersionUID() {
        return this.serialVersionUID;
    }

    public byte getClassDescFlags() {
        return this.classDescFlags;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public List<ContentRule> getClassAnnotation() {
        return this.classAnnotation;
    }

    @Override
    public void writeJrank(DataOutputStream out) throws IOException {
        out.write(2);
        String className = this.className;
        if (!className.startsWith("[")) {
            className = "L" + className + ";";
        }
        JdkStream.writeUTF(out, className);
        JdkStream.writeEscapedLong(out, this.serialVersionUID);
        int jrflags = 0;
        byte osflags = this.classDescFlags;
        if ((osflags & 2) != 0) {
            jrflags = (byte)(jrflags | 0x10);
            jrflags = (osflags & 1) != 0 ? (int)((byte)(jrflags | 2)) : (int)((byte)(jrflags | 1));
        }
        if ((osflags & 4) != 0) {
            jrflags = (byte)(jrflags | 4);
        }
        if ((osflags & 0x10) != 0) {
            jrflags = (byte)(jrflags | 8);
        }
        out.write(jrflags);
        out.writeShort(this.fields.size());
        for (Field f : this.fields) {
            f.writeJrank(out);
        }
        this.superClassDesc.writeJrank(out);
    }

    public class Field
    extends JdkBlock {
        protected byte typeCode;
        protected String fieldName;
        protected StringRule className;

        public Field(JdkStream jdk) {
            super(jdk);
        }

        @Override
        public Field parse() throws IOException {
            this.typeCode = this.jdk.readByte();
            this.fieldName = this.jdk.readUTF();
            switch (this.typeCode) {
                case 76: 
                case 91: {
                    this.className = this.jdk.readBlock(StringRule.class);
                    break;
                }
                case 66: 
                case 67: 
                case 68: 
                case 70: 
                case 73: 
                case 74: 
                case 83: 
                case 90: {
                    break;
                }
                default: {
                    throw new StreamCorruptedException("Invalid typecode:" + this.typeCode);
                }
            }
            return this;
        }

        public byte getTypeCode() {
            return this.typeCode;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public StringRule getClassName() {
            return this.className;
        }

        @Override
        public void writeJrank(DataOutputStream out) throws IOException {
            out.writeByte(this.typeCode);
            JdkStream.writeUTF(out, this.fieldName);
            if (this.className != null) {
                this.className.writeJrank(out);
            }
        }
    }
}

