/*
 * Decompiled with CFR 0.152.
 */
package org.purplejrank.jdk.block;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.purplejrank.jdk.Block;
import org.purplejrank.jdk.JdkBlock;
import org.purplejrank.jdk.JdkStream;
import org.purplejrank.jdk.WiredBlock;
import org.purplejrank.jdk.block.ClassdescBlock;
import org.purplejrank.jdk.block.EndblockdataBlock;
import org.purplejrank.jdk.block.ReferenceBlock;
import org.purplejrank.jdk.rule.ClassdescRule;
import org.purplejrank.jdk.rule.ContentRule;
import org.purplejrank.jdk.rule.ObjectRule;

public class ObjectBlock
extends JdkBlock
implements ObjectRule,
WiredBlock {
    protected ClassdescRule classDesc;
    protected List<Classdata> classdata = new ArrayList<Classdata>();

    public ObjectBlock(JdkStream jdk) {
        super(jdk);
    }

    @Override
    public Block parse() throws IOException {
        this.classDesc = this.jdk.readBlock(ClassdescRule.class);
        this.jdk.wireBlock(this);
        int flags = 0;
        ClassdescRule cr = this.classDesc;
        if (cr instanceof ReferenceBlock) {
            cr = (ClassdescRule)((Object)((ReferenceBlock)cr).getWired());
        }
        if (cr instanceof ClassdescBlock) {
            flags = ((ClassdescBlock)cr).getClassDescFlags();
        }
        if ((flags & 4) == 4) {
            this.classdata.add(new Classdata(this.jdk, (ClassdescBlock)cr).parse());
        } else if ((flags & 2) == 2) {
            ArrayList<ClassdescBlock> cbl = new ArrayList<ClassdescBlock>();
            cbl.add(0, (ClassdescBlock)cr);
            for (ClassdescBlock cb = cr.getSuperClassDesc(); cb != null; cb = cb.getSuperClassDesc()) {
                cbl.add(0, cb);
            }
            for (ClassdescBlock c : cbl) {
                this.classdata.add(new Classdata(this.jdk, c).parse());
            }
        }
        return this;
    }

    @Override
    public void writeJrank(DataOutputStream out) throws IOException {
        out.write(3);
        this.classDesc.writeJrank(out);
        for (Classdata c : this.classdata) {
            c.writeJrank(out);
        }
    }

    public class Classdata
    extends JdkBlock {
        protected ClassdescBlock classDesc;
        protected List<FieldValue> values;
        protected List<ContentRule> objectAnnotation;

        public Classdata(JdkStream jdk, ClassdescBlock classDesc) {
            super(jdk);
            this.values = new ArrayList<FieldValue>();
            this.objectAnnotation = new ArrayList<ContentRule>();
            this.classDesc = classDesc;
        }

        @Override
        public Classdata parse() throws IOException {
            Block a;
            byte flags = this.classDesc.getClassDescFlags();
            if ((flags & 4) == 0) {
                for (ClassdescBlock.Field f : this.classDesc.getFields()) {
                    this.values.add(new FieldValue(this.jdk, f).parse());
                }
            }
            if ((flags & 2) == 2 && (flags & 1) == 0) {
                return this;
            }
            while ((a = this.jdk.readBlock()) instanceof ContentRule) {
                this.objectAnnotation.add((ContentRule)a);
            }
            EndblockdataBlock.class.cast(a);
            return this;
        }

        @Override
        public void writeJrank(DataOutputStream out) throws IOException {
            byte flags = this.classDesc.getClassDescFlags();
            if ((flags & 2) == 2) {
                out.write(12);
                for (FieldValue fv : this.values) {
                    fv.writeJrank(out);
                }
                out.write(8);
                if ((flags & 1) == 1) {
                    for (ContentRule c : this.objectAnnotation) {
                        c.writeJrank(out);
                    }
                }
                out.write(8);
            } else if ((flags & 4) == 4) {
                for (ContentRule c : this.objectAnnotation) {
                    c.writeJrank(out);
                }
                out.write(8);
            }
        }

        public class FieldValue
        extends JdkBlock {
            protected ClassdescBlock.Field field;
            protected Object primValue;
            protected ObjectRule objValue;

            public FieldValue(JdkStream jdk, ClassdescBlock.Field field) {
                super(jdk);
                this.field = field;
            }

            @Override
            public FieldValue parse() throws IOException {
                switch (this.field.getTypeCode()) {
                    case 66: {
                        this.primValue = this.jdk.readByte();
                        break;
                    }
                    case 67: {
                        this.primValue = Character.valueOf(this.jdk.readChar());
                        break;
                    }
                    case 68: {
                        this.primValue = this.jdk.readDouble();
                        break;
                    }
                    case 70: {
                        this.primValue = Float.valueOf(this.jdk.readFloat());
                        break;
                    }
                    case 73: {
                        this.primValue = this.jdk.readInt();
                        break;
                    }
                    case 74: {
                        this.primValue = this.jdk.readLong();
                        break;
                    }
                    case 83: {
                        this.primValue = this.jdk.readShort();
                        break;
                    }
                    case 90: {
                        this.primValue = this.jdk.readBoolean();
                        break;
                    }
                    case 76: 
                    case 91: {
                        this.objValue = this.jdk.readBlock(ObjectRule.class);
                    }
                }
                return this;
            }

            @Override
            public void writeJrank(DataOutputStream out) throws IOException {
                if (this.primValue != null) {
                    out.write(7);
                }
                switch (this.field.getTypeCode()) {
                    case 66: {
                        JdkStream.writeEscapedInt(out, 1);
                        out.writeByte(((Byte)this.primValue).byteValue());
                        break;
                    }
                    case 67: {
                        JdkStream.writeEscapedInt(out, 2);
                        out.writeChar(((Character)this.primValue).charValue());
                        break;
                    }
                    case 68: {
                        JdkStream.writeEscapedInt(out, 8);
                        out.writeDouble((Double)this.primValue);
                        break;
                    }
                    case 70: {
                        JdkStream.writeEscapedInt(out, 4);
                        out.writeFloat(((Float)this.primValue).floatValue());
                        break;
                    }
                    case 73: {
                        JdkStream.writeEscapedInt(out, 4);
                        out.writeInt((Integer)this.primValue);
                        break;
                    }
                    case 74: {
                        JdkStream.writeEscapedInt(out, 8);
                        out.writeLong((Long)this.primValue);
                        break;
                    }
                    case 83: {
                        JdkStream.writeEscapedInt(out, 2);
                        out.writeShort(((Short)this.primValue).shortValue());
                        break;
                    }
                    case 90: {
                        JdkStream.writeEscapedInt(out, 1);
                        out.writeBoolean((Boolean)this.primValue);
                        break;
                    }
                    case 76: 
                    case 91: {
                        this.objValue.writeJrank(out);
                    }
                }
            }
        }
    }
}

