/*
 * Decompiled with CFR 0.152.
 */
package org.qaddict;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.qaddict.Expectation;
import org.qaddict.expectation.ConditionalPredicate;
import org.qaddict.expectation.ExpectationBuilder;
import org.qaddict.expectation.ExpectationDescription;
import org.qaddict.expectation.FluentTransformation;
import org.qaddict.expectation.Negation;
import org.qaddict.expectation.OperatorExpectation;
import org.qaddict.expectation.PredicateExpectation;
import org.qaddict.expectation.TransformedExpectation;
import org.qaddict.expectation.iterable.InAnyOrderExpectation;
import org.qaddict.expectation.iterable.Mode;
import org.qaddict.functions.Logic;
import org.qaddict.functions.Transformation;

public final class Expectations {
    private static final Expectation<Object> IS_NULL = Expectations.sameInstanceAs(null);
    private static final Expectation<Object> NON_NULL = Expectations.not(IS_NULL);
    private static final Expectation<Object> ANYTHING = Expectations.expect0("anything", actualValue -> true);

    private Expectations() {
    }

    public static <D> Expectation<D> describe(Object description, Expectation<D> expectation) {
        return new ExpectationDescription<D>(description, expectation);
    }

    private static <D> Expectation<D> expect0(Object description, Logic<D> logic) {
        return Expectations.describe(description, new PredicateExpectation<D>(logic));
    }

    public static <D> Expectation<D> expect(String description, Logic<D> logic) {
        return Expectations.expect0(description, logic);
    }

    public static <D> Expectation<D> sameInstanceAs(D expectedInstance) {
        return Expectations.expect0(expectedInstance, actualInstance -> expectedInstance == actualInstance);
    }

    public static <D> Expectation<D> require(Expectation<? super D> requirement, Expectation<? super D> expectation) {
        return new ConditionalPredicate<D>(requirement, expectation);
    }

    public static <D> Expectation<D> requireNonNull(Expectation<? super D> expectation) {
        return Expectations.require(Expectations.nonNull(), expectation);
    }

    public static <D> Expectation<D> equalTo(D expectedValue) {
        if (expectedValue == null) {
            return IS_NULL;
        }
        if (expectedValue instanceof Double) {
            Double d = (Double)expectedValue;
            return Expectations.closeTo(d, d * 1.0E-9);
        }
        if (expectedValue instanceof Float) {
            Float f = (Float)expectedValue;
            return Expectations.closeTo(f.floatValue(), f.floatValue() * 1.0E-5f);
        }
        if (expectedValue.getClass().isArray()) {
            int length = Array.getLength(expectedValue);
            return Expectations.require(Expectations.nonNull(), Expectations.require(Expectations.expect("is array", v -> v.getClass().isArray()), Expectations.require(Expectations.expect("same length", v -> Array.getLength(v) == length), Expectations.allOf(IntStream.range(0, length).mapToObj(i -> Expectations.transform("item " + i, v -> Array.get(v, i), Expectations.equalTo(Array.get(expectedValue, i)))).collect(Collectors.toList())))));
        }
        return Expectations.expect0(expectedValue, expectedValue::equals);
    }

    public static <D, V> Expectation<D> transform(String name, Transformation<D, ? extends V> transformation, Expectation<? super V> expectation) {
        return Expectations.describe(name, new TransformedExpectation<D, V>(transformation, expectation));
    }

    public static <D> Expectation<D> not(Expectation<D> expectationToNegate) {
        return new Negation<D>(expectationToNegate);
    }

    public static <D> Expectation<D> not(D unexpectedValue) {
        return Expectations.not(Expectations.equalTo(unexpectedValue));
    }

    public static Expectation<Object> anything() {
        return ANYTHING;
    }

    public static Expectation<Object> isNull() {
        return IS_NULL;
    }

    public static Expectation<Object> nonNull() {
        return NON_NULL;
    }

    @SafeVarargs
    public static <D> Expectation<D> allOf(Expectation<? super D> ... operands) {
        return Expectations.allOf(List.of(operands));
    }

    public static <D> Expectation<D> allOf(Collection<Expectation<? super D>> operands) {
        return new OperatorExpectation<D>(operands, OperatorExpectation.AND);
    }

    @SafeVarargs
    public static <D> Expectation<D> anyOf(Expectation<? super D> ... operands) {
        return Expectations.anyOf(List.of(operands));
    }

    public static <D> Expectation<D> anyOf(Collection<Expectation<? super D>> operands) {
        return new OperatorExpectation<D>(operands, OperatorExpectation.OR);
    }

    @SafeVarargs
    public static <D> Expectation<D> anyOf(D ... operands) {
        Set<D> set = Set.of(operands);
        return Expectations.expect0("Any of " + String.valueOf(set), set::contains);
    }

    public static <D> Expectation<D> moreThan(D lowerBoundary, Comparator<? super D> comparator) {
        return Expectations.expect("> " + String.valueOf(lowerBoundary), actualValue -> comparator.compare((Object)lowerBoundary, (Object)actualValue) < 0);
    }

    public static <D extends Comparable<D>> Expectation<D> moreThan(D lowerBoundary) {
        return Expectations.moreThan(lowerBoundary, Comparator.naturalOrder());
    }

    public static <D> Expectation<D> moreOrEqualTo(D lowerBoundary, Comparator<? super D> comparator) {
        return Expectations.expect(">= " + String.valueOf(lowerBoundary), actualValue -> comparator.compare((Object)lowerBoundary, (Object)actualValue) <= 0);
    }

    public static <D extends Comparable<D>> Expectation<D> moreOrEqualTo(D lowerBoundary) {
        return Expectations.moreOrEqualTo(lowerBoundary, Comparator.naturalOrder());
    }

    public static <D> Expectation<D> lessThan(D upperBoundary, Comparator<? super D> comparator) {
        return Expectations.expect("< " + String.valueOf(upperBoundary), actualValue -> comparator.compare((Object)upperBoundary, (Object)actualValue) > 0);
    }

    public static <D extends Comparable<D>> Expectation<D> lessThan(D upperBoundary) {
        return Expectations.lessThan(upperBoundary, Comparator.naturalOrder());
    }

    public static <D> Expectation<D> lessOrEqualTo(D upperBoundary, Comparator<? super D> comparator) {
        return Expectations.expect("<= " + String.valueOf(upperBoundary), actualValue -> comparator.compare((Object)upperBoundary, (Object)actualValue) >= 0);
    }

    public static <D extends Comparable<D>> Expectation<D> lessOrEqualTo(D upperBoundary) {
        return Expectations.lessOrEqualTo(upperBoundary, Comparator.naturalOrder());
    }

    public static <D> Expectation<D> betweenInclusive(D lowerBoundary, D upperBoundary, Comparator<D> comparator) {
        return comparator.compare(lowerBoundary, upperBoundary) > 0 ? Expectations.allOf(Expectations.moreOrEqualTo(upperBoundary, comparator), Expectations.lessOrEqualTo(lowerBoundary, comparator)) : Expectations.allOf(Expectations.moreOrEqualTo(lowerBoundary, comparator), Expectations.lessOrEqualTo(upperBoundary, comparator));
    }

    public static <D extends Comparable<D>> Expectation<D> betweenInclusive(D lowerBoundary, D upperBoundary) {
        return Expectations.betweenInclusive(lowerBoundary, upperBoundary, Comparator.naturalOrder());
    }

    public static <D> Expectation<D> betweenExclusive(D lowerBoundary, D upperBoundary, Comparator<D> comparator) {
        return comparator.compare(lowerBoundary, upperBoundary) > 0 ? Expectations.allOf(Expectations.moreThan(upperBoundary, comparator), Expectations.lessThan(lowerBoundary, comparator)) : Expectations.allOf(Expectations.moreThan(lowerBoundary, comparator), Expectations.lessThan(upperBoundary, comparator));
    }

    public static <D extends Comparable<D>> Expectation<D> betweenExclusive(D lowerBoundary, D upperBoundary) {
        return Expectations.betweenExclusive(lowerBoundary, upperBoundary, Comparator.naturalOrder());
    }

    public static Expectation<Double> closeTo(double expectedValue, double tolerance) {
        double low = expectedValue - tolerance;
        double high = expectedValue + tolerance;
        return Expectations.expect(expectedValue + " with tolerance " + tolerance, actualValue -> low <= actualValue && actualValue <= high);
    }

    public static Expectation<Double> doubleIsNan() {
        return Expectations.expect("double NaN", actualValue -> Double.isNaN(actualValue));
    }

    public static Expectation<Float> closeTo(float expectedValue, float tolerance) {
        float low = expectedValue - tolerance;
        float high = expectedValue + tolerance;
        return Expectations.expect(expectedValue + " with tolerance " + tolerance, actualValue -> low <= actualValue.floatValue() && actualValue.floatValue() <= high);
    }

    public static Expectation<Float> floatIsNan() {
        return Expectations.expect("float NaN", actualValue -> Float.isNaN(actualValue.floatValue()));
    }

    public static Expectation<String> startsWith(String expectedPrefix) {
        return Expectations.expect("starts with " + expectedPrefix, actualValue -> actualValue.startsWith(expectedPrefix));
    }

    public static Expectation<String> endsWith(String expectedSuffix) {
        return Expectations.expect("ends with " + expectedSuffix, actualValue -> actualValue.endsWith(expectedSuffix));
    }

    public static Expectation<String> contains(String expectedPart) {
        return Expectations.expect("contains with " + expectedPart, actualValue -> actualValue.contains(expectedPart));
    }

    public static Expectation<String> equalToIgnoreCase(String expectedPart) {
        return Expectations.expect("<" + expectedPart + "> ignore case", actualValue -> actualValue.equalsIgnoreCase(expectedPart));
    }

    public static Expectation<String> findPattern(String expectedRegexPattern) {
        return Expectations.findPattern(Pattern.compile(expectedRegexPattern, 32));
    }

    public static Expectation<String> findPattern(Pattern expectedRegexPattern) {
        return Expectations.expect("/" + String.valueOf(expectedRegexPattern) + "/", expectedRegexPattern.asPredicate()::test);
    }

    public static Expectation<String> matchesPattern(String expectedRegexPattern) {
        return Expectations.matchesPattern(Pattern.compile(expectedRegexPattern, 32));
    }

    public static Expectation<String> matchesPattern(Pattern expectedRegexPattern) {
        return Expectations.expect("/" + String.valueOf(expectedRegexPattern) + "/", expectedRegexPattern.asMatchPredicate()::test);
    }

    public static Expectation<String> emptyString() {
        return Expectations.expect("empty string", String::isEmpty);
    }

    public static Expectation<String> nullOrEmptyString() {
        return Expectations.anyOf(Expectations.isNull(), Expectations.emptyString());
    }

    public static Expectation<String> nullOrBlankString() {
        return Expectations.anyOf(Expectations.isNull(), Expectations.blankString());
    }

    public static Expectation<String> blankString() {
        return Expectations.expect("blank string", String::isBlank);
    }

    public static Expectation<String> parseInt(Expectation<? super Integer> expectation) {
        return Expectations.describe("", new TransformedExpectation<String, Integer>(Transformation.nullOr(Integer::parseInt), expectation));
    }

    public static Expectation<String> parseInt(Integer expectedValue) {
        return Expectations.parseInt(Expectations.equalTo(expectedValue));
    }

    public static Expectation<String> parseLong(Expectation<? super Long> expectation) {
        return Expectations.describe("", new TransformedExpectation<String, Long>(Transformation.nullOr(Long::parseLong), expectation));
    }

    public static Expectation<String> parseLong(Long expectedValue) {
        return Expectations.parseLong(Expectations.equalTo(expectedValue));
    }

    public static Expectation<String> parseDouble(Expectation<? super Double> expectation) {
        return Expectations.describe("", new TransformedExpectation<String, Double>(Transformation.nullOr(Double::parseDouble), expectation));
    }

    public static Expectation<String> parseDouble(Double expectedValue) {
        return Expectations.parseDouble(Expectations.equalTo(expectedValue));
    }

    public static <T extends Enum<T>> Expectation<String> parseEnum(Expectation<? super T> expectation, Class<T> enumClass) {
        return Expectations.describe("", new TransformedExpectation<String, T>(Transformation.nullOr(v -> Enum.valueOf(enumClass, v)), expectation));
    }

    public static <T extends Enum<T>> Expectation<String> parseEnum(T expectedValue) {
        return expectedValue == null ? Expectations.sameInstanceAs(null) : Expectations.parseEnum(Expectations.equalTo(expectedValue), expectedValue.getDeclaringClass());
    }

    public static <D, V> FluentTransformation<V, ExpectationBuilder<D>> has(String name, Transformation<D, V> transformation) {
        return new ExpectationBuilder().and(name, transformation);
    }

    public static <D, V> FluentTransformation<V, ExpectationBuilder<D>> has(Transformation<D, V> transformation) {
        return new ExpectationBuilder().and(transformation);
    }

    public static <D> Expectation<Iterable<D>> collectionEqualsInAnyOrder(Collection<Expectation<? super D>> expectations) {
        return new InAnyOrderExpectation<D>(expectations, Mode.EQUALS);
    }

    @SafeVarargs
    public static <D> Expectation<Iterable<D>> collectionEqualsInAnyOrder(Expectation<? super D> ... expectations) {
        return Expectations.collectionEqualsInAnyOrder(List.of(expectations));
    }

    public static <D> Expectation<Iterable<D>> collectionContainsInAnyOrder(Collection<Expectation<? super D>> expectations) {
        return new InAnyOrderExpectation<D>(expectations, Mode.CONTAINS);
    }

    public static <D> Expectation<D> byExample(D exampleBean) {
        if (exampleBean == null) {
            return Expectations.sameInstanceAs(null);
        }
        return Expectations.allOf(Stream.of(exampleBean.getClass().getMethods()).filter(m -> m.getName().startsWith("get")).map(m -> new TransformedExpectation<Object, Object>(x$0 -> m.invoke(x$0, new Object[0]), new PredicateExpectation<Object>(v -> Objects.equals(v, m.invoke(exampleBean, new Object[0]))))).collect(Collectors.toList()));
    }
}

