/*
 * Decompiled with CFR 0.152.
 */
package org.qaddict.adapters;

import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

public class BlockingIterable<D>
implements Iterable<D> {
    private final BlockingQueue<D> queue;
    private final long timeout;
    private final TimeUnit timeUnit;

    public BlockingIterable(BlockingQueue<D> queue, long timeout, TimeUnit timeUnit) {
        this.queue = queue;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    @Override
    public Iterator<D> iterator() {
        return Stream.generate(this::poll).takeWhile(Objects::nonNull).iterator();
    }

    private D poll() {
        try {
            return this.queue.poll(this.timeout, this.timeUnit);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

