/*
 * Decompiled with CFR 0.152.
 */
package org.qaddict.evaluation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.qaddict.Expectation;
import org.qaddict.evaluation.EvaluationNode;
import org.qaddict.evaluation.EvaluationNodes;

public record ComposedNode(boolean result, List<EvaluationNode> children) implements EvaluationNode
{
    public static <D> List<Builder<D>> buildersFor(Collection<Expectation<? super D>> expectations) {
        return expectations.stream().map(ComposedNode::builderFor).toList();
    }

    public static <D> Builder<D> builderFor(Expectation<? super D> expectation) {
        return new BuilderImpl<D>(expectation, new ArrayList<EvaluationNode>());
    }

    private record BuilderImpl<D>(Expectation<? super D> expectation, List<EvaluationNode> nodes) implements Builder<D>
    {
        @Override
        public EvaluationNode evaluate(D item) {
            EvaluationNode evaluated = this.expectation.evaluate(item);
            this.nodes.add(EvaluationNodes.actualValue(item, evaluated));
            return evaluated;
        }

        @Override
        public EvaluationNode build(boolean result) {
            return EvaluationNodes.expectation(this.expectation().toString(), EvaluationNodes.compose(result, this.nodes));
        }
    }

    public static interface Builder<D> {
        public Expectation<? super D> expectation();

        public EvaluationNode evaluate(D var1);

        public EvaluationNode build(boolean var1);
    }
}

