/*
 * Decompiled with CFR 0.152.
 */
package org.qaddict.expectation.iterable;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.qaddict.Expectation;
import org.qaddict.evaluation.ComposedNode;
import org.qaddict.evaluation.EvaluationNode;
import org.qaddict.evaluation.EvaluationNodes;
import org.qaddict.expectation.iterable.Mode;
import org.qaddict.expectation.iterable.algo.MaximumMatching;

public record InAnyOrderExpectation<D>(Collection<Expectation<? super D>> expectations, Mode mode) implements Expectation<Iterable<D>>
{
    @Override
    public EvaluationNode evaluate(Iterable<D> data) {
        List<ComposedNode.Builder<D>> evaluationBuilders;
        MaximumMatching graph;
        block7: {
            graph = new MaximumMatching();
            evaluationBuilders = ComposedNode.buildersFor(this.expectations);
            Stream<D> stream = StreamSupport.stream(data.spliterator(), false);
            switch (this.mode) {
                default: {
                    throw new MatchException(null, null);
                }
                case EQUALS: {
                    if (this.equals(stream, evaluationBuilders, graph)) {
                        break;
                    }
                    break block7;
                }
                case CONTAINS: {
                    if (this.contains(stream, evaluationBuilders, graph)) {
                        break;
                    }
                    break block7;
                }
                case STARTS: {
                    if (!this.starts(stream, evaluationBuilders, graph)) break block7;
                }
            }
            return EvaluationNodes.expectation("collection " + String.valueOf((Object)this.mode) + " in any order " + String.valueOf(this.expectations()), EvaluationNodes.compose(true, InAnyOrderExpectation.byPairing(evaluationBuilders, graph)));
        }
        return EvaluationNodes.expectation("collection " + String.valueOf((Object)this.mode) + " in any order " + String.valueOf(this.expectations()), EvaluationNodes.compose(false, InAnyOrderExpectation.byPairing2(evaluationBuilders, graph)));
    }

    private boolean equals(Stream<D> data, List<ComposedNode.Builder<D>> evaluationBuilders, MaximumMatching<D, Expectation<? super D>> graph) {
        data.forEach(item -> InAnyOrderExpectation.update(item, evaluationBuilders, graph));
        return graph.pairing().size() == this.expectations.size() && graph.edges().size() == this.expectations.size();
    }

    private boolean contains(Stream<D> data, List<ComposedNode.Builder<D>> evaluationBuilders, MaximumMatching<D, Expectation<? super D>> graph) {
        return data.anyMatch(item -> InAnyOrderExpectation.update(item, evaluationBuilders, graph).size() == this.expectations.size());
    }

    private boolean starts(Stream<D> data, List<ComposedNode.Builder<D>> evaluationBuilders, MaximumMatching<D, Expectation<? super D>> graph) {
        return this.contains(data, evaluationBuilders, graph) && graph.edges().size() == this.expectations.size();
    }

    public static <D> Map<Expectation<? super D>, D> update(D item, Collection<ComposedNode.Builder<D>> expectations, MaximumMatching<D, Expectation<? super D>> graph) {
        return graph.update(item, expectations.stream().filter(e -> e.evaluate(item).result()).map(ComposedNode.Builder::expectation).collect(Collectors.toList()));
    }

    private static <D> List<EvaluationNode> byPairing2(List<ComposedNode.Builder<D>> evaluationBuilders, MaximumMatching<D, Expectation<? super D>> graph) {
        return graph.free().isEmpty() ? InAnyOrderExpectation.byPairing(evaluationBuilders, graph) : Stream.concat(evaluationBuilders.stream().map(builder -> builder.build(graph.pairing().containsKey(builder.expectation()))), Stream.of(EvaluationNodes.actualValue(graph.free().size() + " items", EvaluationNodes.expectation("No extra items", EvaluationNodes.result(false))))).collect(Collectors.toList());
    }

    public static <D> List<EvaluationNode> byPairing(List<ComposedNode.Builder<D>> evaluationBuilders, MaximumMatching<D, Expectation<? super D>> graph) {
        return evaluationBuilders.stream().map(builder -> builder.build(graph.pairing().containsKey(builder.expectation()))).collect(Collectors.toList());
    }
}

