/*
 * Decompiled with CFR 0.152.
 */
package org.qaddict.expectation.iterable;

import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;
import org.qaddict.Expectation;
import org.qaddict.evaluation.EvaluationNode;
import org.qaddict.evaluation.ResultNode;
import org.qaddict.expectation.iterable.Mode;

public record InOrderOfDefinitionExpectation<D>(Collection<Expectation<? super D>> expectations, Mode mode) implements Expectation<Iterable<D>>
{
    @Override
    public EvaluationNode evaluate(Iterable<D> data) {
        block7: {
            Iterator<D> iterator = data.iterator();
            Stream<Expectation<? super D>> stream = this.expectations.stream();
            switch (this.mode) {
                default: {
                    throw new MatchException(null, null);
                }
                case EQUALS: {
                    if (this.equals(iterator, stream)) {
                        break;
                    }
                    break block7;
                }
                case CONTAINS: {
                    if (this.contains(iterator, stream)) {
                        break;
                    }
                    break block7;
                }
                case STARTS: {
                    if (!this.starts(iterator, stream)) break block7;
                }
            }
            return new ResultNode(true);
        }
        return new ResultNode(false);
    }

    private boolean equals(Iterator<D> iterator, Stream<Expectation<? super D>> expectations) {
        return this.starts(iterator, expectations) && !iterator.hasNext();
    }

    private boolean starts(Iterator<D> iterator, Stream<Expectation<? super D>> expectations) {
        return expectations.map(expectation -> iterator.hasNext() && expectation.evaluate(iterator.next()).result()).reduce((l, r) -> l != false && r != false).orElse(true);
    }

    private boolean contains(Iterator<D> iterator, Stream<Expectation<? super D>> expectations) {
        return expectations.allMatch(expectation -> this.match((Expectation<? super D>)expectation, iterator));
    }

    private boolean match(Expectation<? super D> expectation, Iterator<D> iterator) {
        while (iterator.hasNext()) {
            if (!expectation.evaluate(iterator.next()).result()) continue;
            return true;
        }
        return false;
    }
}

