/*
 * Decompiled with CFR 0.152.
 */
package org.qaddict;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.qaddict.Described;
import org.qaddict.Expectation;
import org.qaddict.evaluation.ActualValueNode;
import org.qaddict.evaluation.CandidateInversionNode;
import org.qaddict.evaluation.ComposedNode;
import org.qaddict.evaluation.EvaluationNode;
import org.qaddict.evaluation.EvaluationNodes;
import org.qaddict.evaluation.ExpectationNode;
import org.qaddict.evaluation.PathNode;
import org.qaddict.evaluation.ResultNode;
import org.qaddict.evaluation.ThrowableNode;

public class Assert {
    public static <D> D that(D data, Expectation<? super D> expectation) {
        ActualValueNode actualValueNode = EvaluationNodes.actualValue(data, expectation.evaluate(data));
        if (!actualValueNode.result()) {
            throw new AssertionError((Object)Assert.describe(actualValueNode));
        }
        return data;
    }

    public static String describe(ActualValueNode node) {
        return Assert.describe(node.child(), new StringJoiner(" ", "", " "), Described.description(""), node.actualValue(), false, "");
    }

    private static String describe(EvaluationNode node, StringJoiner path, Described expectation, Object actualValue, boolean failureCandidate, String prefix) {
        EvaluationNode evaluationNode = node;
        Objects.requireNonNull(evaluationNode);
        EvaluationNode evaluationNode2 = evaluationNode;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CandidateInversionNode.class, ResultNode.class, PathNode.class, ActualValueNode.class, ExpectationNode.class, ThrowableNode.class, ComposedNode.class}, (Object)evaluationNode2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                CandidateInversionNode n = (CandidateInversionNode)evaluationNode2;
                yield Assert.describe(n.child(), path, expectation, actualValue, failureCandidate, prefix);
            }
            case 1 -> {
                ResultNode ignored = (ResultNode)evaluationNode2;
                yield prefix + "Expected: " + String.valueOf(path) + String.valueOf(expectation) + ", but was: " + String.valueOf(actualValue);
            }
            case 2 -> {
                PathNode n = (PathNode)evaluationNode2;
                yield Assert.describe(n.child(), path.add(String.valueOf(n.name())), expectation, actualValue, failureCandidate, prefix);
            }
            case 3 -> {
                ActualValueNode n = (ActualValueNode)evaluationNode2;
                yield Assert.describe(n.child(), path, expectation, n.actualValue(), failureCandidate, prefix);
            }
            case 4 -> {
                ExpectationNode n = (ExpectationNode)evaluationNode2;
                yield Assert.describe(n.child(), path, n.description(), actualValue, failureCandidate, prefix);
            }
            case 5 -> {
                ThrowableNode n = (ThrowableNode)evaluationNode2;
                yield prefix + "Expected: " + String.valueOf(path) + String.valueOf(expectation) + ", but has thrown: " + String.valueOf(n.throwable());
            }
            case 6 -> {
                ComposedNode n = (ComposedNode)evaluationNode2;
                yield prefix + Assert.node(path, expectation, actualValue) + "\n" + n.children().stream().filter(child -> child.result() == failureCandidate).map(child -> Assert.describe(child, new StringJoiner(" ", "", " "), Described.description(""), actualValue, failureCandidate, prefix + "\t")).collect(Collectors.joining("\n"));
            }
        };
    }

    private static String node(StringJoiner path, Described expectation, Object actualValue) {
        return Objects.isNull(expectation) || expectation.toString().isBlank() ? "Item: " + String.valueOf(actualValue) : "Expected: " + String.valueOf(path) + String.valueOf(expectation);
    }
}

