/*
 * Decompiled with CFR 0.152.
 */
package org.qaddict.algo;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record MaximumMatching<I, O>(Map<I, Collection<O>> edges, Map<O, I> pairing, Set<I> free) {
    public MaximumMatching() {
        this(new HashMap(), new HashMap(), new HashSet());
    }

    public Map<O, I> update(I start, Collection<O> ends) {
        this.edges.computeIfAbsent(start, key -> new LinkedHashSet()).addAll(ends);
        this.free.add(start);
        Stream.generate(this::findImprovingPath).takeWhile(Objects::nonNull).flatMap(path -> Stream.iterate(path, Objects::nonNull, e -> e.prev.prev)).forEach(e -> {
            this.pairing.put(e.node, e.prev.node);
            this.free.remove(e.prev.node);
        });
        return this.pairing;
    }

    public Edge<O, I> findImprovingPath() {
        LinkedList queue = this.free.stream().map(i -> new Edge(null, i)).collect(Collectors.toCollection(LinkedList::new));
        HashSet visited = new HashSet();
        while (!queue.isEmpty()) {
            Edge a = (Edge)queue.poll();
            if (!visited.add(a.node)) continue;
            for (O b : this.edges.get(a.node)) {
                if (!this.pairing.containsKey(b)) {
                    return new Edge(a, b);
                }
                queue.add(new Edge(new Edge(a, b), this.pairing.get(b)));
            }
        }
        return null;
    }

    public static <I> Node<I> node(I i) {
        return () -> i;
    }

    public record Edge<I, O>(Edge<O, I> prev, I node) {
    }

    public static interface Node<I> {
        public I getValue();
    }
}

