/*
 * Decompiled with CFR 0.152.
 */
package org.qaddict.evaluation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.qaddict.Expectation;
import org.qaddict.algo.MaximumMatching;
import org.qaddict.evaluation.EvaluationNode;
import org.qaddict.evaluation.EvaluationNodes;

public record ComposedNode(boolean result, List<EvaluationNode> children) implements EvaluationNode
{
    public static <D> List<Builder<D>> buildersFor(Collection<Expectation<? super D>> expectations) {
        return expectations.stream().map(ComposedNode::builderFor).toList();
    }

    public static <D> Builder<D> builderFor(Expectation<? super D> expectation) {
        return new BuilderImpl<D>(expectation);
    }

    private static final class BuilderImpl<D>
    implements Builder<D> {
        private final Expectation<? super D> expectation;
        private final List<EvaluationNode> nodes = new ArrayList<EvaluationNode>();

        private BuilderImpl(Expectation<? super D> expectation) {
            this.expectation = expectation;
        }

        @Override
        public Expectation<? super D> expectation() {
            return this.expectation;
        }

        @Override
        public EvaluationNode add(EvaluationNode node) {
            this.nodes.add(node);
            return node;
        }

        @Override
        public EvaluationNode build(boolean result) {
            return EvaluationNodes.expectation(this.expectation(), EvaluationNodes.compose(result, this.nodes));
        }

        @Override
        public Expectation<? super D> getValue() {
            return this.expectation;
        }
    }

    public static interface Builder<D>
    extends MaximumMatching.Node<Expectation<? super D>> {
        public Expectation<? super D> expectation();

        default public EvaluationNode evaluate(D item) {
            return this.add(EvaluationNodes.actualValue(item, this.expectation().evaluate(item)));
        }

        public EvaluationNode add(EvaluationNode var1);

        default public boolean add(Builder<?> b, boolean result) {
            return this.add(EvaluationNodes.expectation(b.expectation(), b.build(result))).result();
        }

        public EvaluationNode build(boolean var1);
    }
}

